/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.mathandtrigonometry;

import com.celestecs.expression.Features;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.math.BigDecimal;
import java.math.RoundingMode;

public final class CalculatorRound
extends CalculatorBase {
    public CalculatorRound(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (null == objParams || objParams.length != 1 && objParams.length != 2) {
            throw new IllegalArgumentException("Invalid number of parameters.");
        }
        int p = 0;
        if (2 == objParams.length) {
            p = Long.valueOf(Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        double val = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        if (Features.ROUND_FUNC_DIGIT_NUMBER_FIX) {
            return CalculatorRound.round(val, p);
        }
        return CalculatorRound.roundUp(val, p);
    }

    public static double roundUp(double n, int p) {
        double retval = BigDecimal.valueOf(n).setScale(p, RoundingMode.HALF_UP).doubleValue();
        return retval;
    }

    public static double round(double value, int precision) {
        double scale = 1.0;
        if (precision > 0) {
            scale = Math.pow(10.0, precision);
        } else if (precision < 0) {
            scale = 1.0 / Math.pow(10.0, -1 * precision);
        }
        return Math.signum(value) * (double)Math.round(Math.abs(value) * scale) / scale;
    }
}

