/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dataaccess;

import com.celestecs.expression.Features;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;

public class CalculatorGetConfluencePageElementCount
extends CalculatorBase {
    private PageContentProvider pageContentProvider = null;

    public CalculatorGetConfluencePageElementCount(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    public PageContentProvider getPageContentProvider() {
        return this.pageContentProvider;
    }

    public void setPageContentProvider(PageContentProvider pageContentProvider) {
        this.pageContentProvider = pageContentProvider;
    }

    @Override
    public Object Calculate(Object[] objParams) {
        if (!Features.FIRST_DATA_ACCESS_FUNCTIONS_SUPPORT) {
            return "";
        }
        super.CheckParams(objParams, 2);
        super.CheckForNotHavingRanges(objParams);
        String page = objParams[0].toString();
        String selectQuery = objParams[1].toString();
        Long result = CalculatorGetConfluencePageElementCount.getConfluencePageElementCount(page, selectQuery, this.pageContentProvider, this.decimalSymbol, this.digitGroupingSymbol);
        return result;
    }

    static Long getConfluencePageElementCount(String page, String selectQuery, PageContentProvider pageContentProvider, char decimalSymbol, String digitGroupingSymbol) throws IllegalArgumentException {
        if (null == pageContentProvider) {
            return -1L;
        }
        try {
            String unsafe = pageContentProvider.getPage(page);
            String result = Jsoup.clean(unsafe, Safelist.relaxed());
            if (null != selectQuery && selectQuery.length() > 0) {
                Document doc = Jsoup.parseBodyFragment(result);
                Elements elements = doc.select(selectQuery);
                if (null != elements && null != elements.text() && elements.text().length() > 0) {
                    int size = elements.size();
                    return size;
                }
                return 0L;
            }
            return 0L;
        }
        catch (ExpressionCalculationException e) {
            throw new IllegalArgumentException("parameters");
        }
    }
}

