/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.OperationKind;
import com.celestecs.expression.calculators.IOperationCalculator;

public final class Operation {
    private String name;
    private OperationKind kind = OperationKind.values()[0];
    private int priority;
    private String[] signature;
    private int operandsCount;
    private IOperationCalculator calculator;

    public String getName() {
        return this.name;
    }

    public OperationKind getKind() {
        return this.kind;
    }

    public int getPriority() {
        return this.priority;
    }

    public String[] getSignature() {
        return this.signature;
    }

    public int getOperandsCount() {
        return this.operandsCount;
    }

    public void setOperandsCount(int newValue) {
        this.operandsCount = newValue;
    }

    public IOperationCalculator getCalculator() {
        return this.calculator;
    }

    public Operation(String name, OperationKind kind, String[] signature, int operandsCount, IOperationCalculator calculator, int priority) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("Empty name.");
        }
        if (signature == null) {
            throw new IllegalArgumentException("signature");
        }
        if (signature.length == 0) {
            throw new IllegalArgumentException("Signature is empty.");
        }
        if (calculator == null) {
            throw new IllegalArgumentException("calculator");
        }
        if (kind == OperationKind.Operator && operandsCount > 1 && signature.length != operandsCount - 1) {
            throw new IllegalArgumentException("Invalid array length.");
        }
        if (kind == OperationKind.Function && signature.length != 1) {
            throw new UnsupportedOperationException("Signature of function must contain one string item.");
        }
        if (kind == OperationKind.Operator) {
            this.priority = priority;
        }
        this.kind = kind;
        this.name = name;
        this.calculator = calculator;
        this.operandsCount = operandsCount;
        this.signature = signature;
    }

    public Operation getCopy() {
        Operation operation = new Operation(this.name, this.kind, (String[])this.signature.clone(), this.operandsCount, this.calculator);
        return operation;
    }

    public Operation(String name, OperationKind kind, String[] signature, int operandsCount, IOperationCalculator calculator) {
        this(name, kind, signature, operandsCount, calculator, 0);
    }

    public String toString() {
        return String.format("%1$s %2$s", new Object[]{this.kind, this.name});
    }
}

