/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.statistical;

import com.celestecs.expression.VariableRange;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.operators.CalculatorAddition;
import com.celestecs.expression.calculators.operators.CalculatorEqual;
import com.celestecs.expression.calculators.operators.CalculatorGreater;
import com.celestecs.expression.calculators.operators.CalculatorGreaterOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorLess;
import com.celestecs.expression.calculators.operators.CalculatorLessOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorNotEqual;

public final class CalculatorAverageIfs
extends CalculatorBase {
    public static final int NONE = 0;
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LE = 3;
    public static final int LT = 4;
    public static final int GT = 5;
    public static final int GE = 6;

    public CalculatorAverageIfs(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        if (null == objParams || objParams.length < 3 || (objParams.length - 1) % 2 != 0) {
            return 0L;
        }
        Object objAvgRange = null;
        Object[] objRanges = null;
        Object[] objCriterias = null;
        objAvgRange = objParams[0];
        if (!(objAvgRange instanceof VariableRange)) {
            return 0L;
        }
        int numOfCriterias = (objParams.length - 1) / 2;
        objRanges = new Object[numOfCriterias];
        objCriterias = new Object[numOfCriterias];
        for (int i = 0; i < numOfCriterias; ++i) {
            objRanges[i] = objParams[1 + i * 2];
            objCriterias[i] = objParams[1 + i * 2 + 1];
            if (objRanges[i] instanceof VariableRange && !(objCriterias[i] instanceof VariableRange)) continue;
            return 0L;
        }
        CalculatorAddition calcSumCaclulator = new CalculatorAddition(this.decimalSymbol, this.digitGroupingSymbol);
        CalculatorBase[] calcComparers = new CalculatorBase[numOfCriterias];
        Object[] arrAvgRanges = Conversion.objectArrayWithRangesToFlatObjectArray(new Object[]{objAvgRange});
        Object[][] arrRanges = new Object[numOfCriterias][];
        Object[] arrCriterias = new Object[numOfCriterias];
        for (int i = 0; i < numOfCriterias; ++i) {
            String strValue;
            arrRanges[i] = Conversion.objectArrayWithRangesToFlatObjectArray(new Object[]{objRanges[i]});
            if (null == arrRanges[i] || arrRanges[i].length != arrAvgRanges.length) {
                return 0L;
            }
            Object objValue = objCriterias[i];
            String string = strValue = null == objValue ? "" : CalculatorAverageIfs.getValue(objValue.toString());
            if (null == objValue || strValue.length() == objValue.toString().length()) {
                calcComparers[i] = this.getCalculator(1);
                arrCriterias[i] = objValue;
                continue;
            }
            int operation = CalculatorAverageIfs.getOperation(objValue.toString());
            calcComparers[i] = this.getCalculator(operation);
            arrCriterias[i] = strValue;
        }
        Object[] calcAvgmarizerParams = new Object[2];
        Object[] calcComparerParams = new Object[2];
        Object objSumResult = null;
        boolean bFirstTime = true;
        long sumCountResult = 0L;
        for (int j = 0; j < arrAvgRanges.length; ++j) {
            calcComparerParams[1] = arrCriterias[j];
            boolean bResult = true;
            for (int i = 0; i < numOfCriterias; ++i) {
                Object objParam;
                calcComparerParams[0] = objParam = arrRanges[j][i];
                Object objComparerResult = calcComparers[i].Calculate(calcComparerParams);
                if (null != objComparerResult && objComparerResult instanceof Boolean && ((Boolean)objComparerResult).booleanValue()) continue;
                bResult = false;
                break;
            }
            if (!bResult || !Conversion.isDoubleOrLong(arrAvgRanges[j], this.decimalSymbol, this.digitGroupingSymbol) && !Conversion.isDateTime(arrAvgRanges[j])) continue;
            if (bFirstTime) {
                objSumResult = arrAvgRanges[j];
                bFirstTime = false;
                ++sumCountResult;
                continue;
            }
            calcAvgmarizerParams[0] = objSumResult;
            calcAvgmarizerParams[1] = arrAvgRanges[j];
            objSumResult = calcSumCaclulator.Calculate(calcAvgmarizerParams);
            ++sumCountResult;
        }
        if (null == objSumResult || 0L == sumCountResult) {
            objSumResult = 0L;
        }
        double result = Conversion.objectToDouble(objSumResult, this.decimalSymbol, this.digitGroupingSymbol) / (double)sumCountResult;
        return result;
    }

    public CalculatorBase getCalculator(int operation) {
        CalculatorBase calc = null;
        switch (operation) {
            case 0: 
            case 1: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 2: {
                calc = new CalculatorNotEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 3: {
                calc = new CalculatorLessOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 4: {
                calc = new CalculatorLess(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 5: {
                calc = new CalculatorGreater(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 6: {
                calc = new CalculatorGreaterOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            default: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
            }
        }
        return calc;
    }

    public static int getOperation(String param) {
        int len = param.length();
        if (len < 1) {
            return 0;
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return 1;
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 6;
                        }
                    }
                }
                return 5;
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 3;
                        }
                        case '>': {
                            return 2;
                        }
                    }
                }
                return 4;
            }
        }
        return 1;
    }

    public static String getValue(String param) {
        if (null == param) {
            return "";
        }
        int len = param.length();
        if (len < 1) {
            return "";
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return param.substring(1);
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                        case '>': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
        }
        return param;
    }
}

