/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.financial.FinanceFunctions;

public final class CalculatorNpv
extends CalculatorBase {
    public CalculatorNpv(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected void checkToBeDouble(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    protected void checkToBeLong(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Long.");
        }
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 1) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 1.");
        }
        this.checkToBeDouble(objParams[0], "Rate");
        double Rate = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        int count = objParams.length - 1;
        double[] Values2 = new double[count];
        for (int i = 0; i < count; ++i) {
            int index = i + 1;
            this.checkToBeDouble(objParams[index], "Value" + (i + 1));
            Values2[i] = Conversion.objectToDouble(objParams[index], this.decimalSymbol, this.digitGroupingSymbol);
        }
        return FinanceFunctions.npv(Rate, Values2);
    }
}

