/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators;

import com.celestecs.expression.Calculator;
import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.Variable;
import com.celestecs.expression.VariableRange;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.dateandtime.CalculatorDateValue;
import com.celestecs.expression.exceptions.VariableNotInitializedException;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;

public class Conversion {
    public static double[] objectArrayToDoubleArray(Object[] objParams, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParams || 0 == objParams.length) {
            return new double[0];
        }
        double[] dblParams = new double[objParams.length];
        for (int i = 0; i < objParams.length; ++i) {
            dblParams[i] = Conversion.objectToDouble(objParams[i], decimalSymbol, digitGroupingSymbol);
        }
        return dblParams;
    }

    public static long[] objectArrayToLongArray(Object[] objParams, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParams || 0 == objParams.length) {
            return null;
        }
        long[] lParams = new long[objParams.length];
        for (int i = 0; i < objParams.length; ++i) {
            if (!Conversion.isLong(objParams[i], decimalSymbol, digitGroupingSymbol)) {
                return null;
            }
            lParams[i] = Conversion.objectToLong(objParams[i], decimalSymbol, digitGroupingSymbol);
        }
        return lParams;
    }

    public static DateTime[] objectArrayToDateTimeArray(Object[] objParams, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParams || 0 == objParams.length) {
            return null;
        }
        DateTime[] dtParams = new DateTime[objParams.length];
        for (int i = 0; i < objParams.length; ++i) {
            if (!(objParams[i] instanceof DateTime)) {
                return null;
            }
            dtParams[i] = (DateTime)objParams[i];
        }
        return dtParams;
    }

    public static Object sanitizeFromVariableValue(Object var) {
        if (null == var) {
            return null;
        }
        if (var instanceof VariableValue) {
            return ((VariableValue)var).getValue();
        }
        return var;
    }

    public static Object[] objectArrayWithRangesToFlatObjectArray(Object[] objParams) {
        if (null == objParams || 0 == objParams.length) {
            return new Object[0];
        }
        ArrayList<Object> objectParams = new ArrayList<Object>();
        for (int i = 0; i < objParams.length; ++i) {
            Variable var;
            Object v;
            int x;
            int y;
            Object[][] vvs;
            int rangeVarColCount;
            int rangeVarRowCount;
            VariableRange vr;
            if (objParams[i] instanceof VariableRange) {
                vr = (VariableRange)objParams[i];
                rangeVarRowCount = vr.getRowCount();
                rangeVarColCount = vr.getColCount();
                vvs = vr.getVariables();
                for (y = 0; y < rangeVarRowCount; ++y) {
                    for (x = 0; x < rangeVarColCount; ++x) {
                        v = vvs[y][x];
                        if (v instanceof Variable && (var = (Variable)v).getVariableName().equals(Variable.EMPTY_VAR_NAME)) continue;
                        objectParams.add(Conversion.sanitizeFromVariableValue(v));
                    }
                }
                continue;
            }
            if (MacroHelper.isArray(objParams[i])) {
                Object[] arr = (Object[])objParams[i];
                int len = arr.length;
                for (int idx = 0; idx < len; ++idx) {
                    objectParams.add(Conversion.sanitizeFromVariableValue(arr[idx]));
                }
                continue;
            }
            if (Features.SUPPORT_FOR_REPORTS && objParams[i] instanceof VariableValue && null != ((VariableValue)objParams[i]).getValue() && ((VariableValue)objParams[i]).getValue() instanceof VariableRange) {
                vr = (VariableRange)((VariableValue)objParams[i]).getValue();
                rangeVarRowCount = vr.getRowCount();
                rangeVarColCount = vr.getColCount();
                vvs = vr.getVariables();
                for (y = 0; y < rangeVarRowCount; ++y) {
                    for (x = 0; x < rangeVarColCount; ++x) {
                        v = vvs[y][x];
                        if (v instanceof Variable && (var = (Variable)v).getVariableName().equals(Variable.EMPTY_VAR_NAME)) continue;
                        objectParams.add(Conversion.sanitizeFromVariableValue(v));
                    }
                }
                continue;
            }
            objectParams.add(Conversion.sanitizeFromVariableValue(objParams[i]));
        }
        return objectParams.toArray();
    }

    public static boolean hasRanges(Object[] objParams) {
        if (null == objParams || 0 == objParams.length) {
            return false;
        }
        for (int i = 0; i < objParams.length; ++i) {
            if (!(objParams[i] instanceof VariableRange)) continue;
            return true;
        }
        return false;
    }

    public static Object objectToSpecificType(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam) {
            throw new VariableNotInitializedException("");
        }
        if (Conversion.isLong(objParam = Conversion.sanitizeFromVariableValue(objParam), decimalSymbol, digitGroupingSymbol)) {
            return Conversion.objectToLong(objParam, decimalSymbol, digitGroupingSymbol);
        }
        if (Conversion.isBoolean(objParam)) {
            return Conversion.objectToBoolean(objParam, decimalSymbol, digitGroupingSymbol);
        }
        if (Conversion.isDoubleOrLong(objParam, decimalSymbol, digitGroupingSymbol)) {
            return Conversion.objectToDouble(objParam, decimalSymbol, digitGroupingSymbol);
        }
        if (!Features.DONT_CONVERT_DATE_STRING_TO_DATETIME && Conversion.isDateTime(objParam)) {
            return Conversion.objectToDateTime(objParam);
        }
        return objParam.toString();
    }

    public static Object[] objectArrayToSpecificTypeArray(Object[] objParams, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParams || 0 == objParams.length) {
            return new Object[0];
        }
        Object[] resParams = new Object[objParams.length];
        for (int i = 0; i < objParams.length; ++i) {
            String strParam;
            Object objParam = Conversion.sanitizeFromVariableValue(objParams[i]);
            String string = strParam = null == objParam ? "" : Conversion.trimIfTrimmingIsEnabled(objParam);
            resParams[i] = null == objParam ? "" : ((!Features.ADD_TIME_TO_MACRO_DEF || 0 != strParam.length()) && Conversion.isLong(objParam, decimalSymbol, digitGroupingSymbol) ? Long.valueOf(Conversion.objectToLong(objParam, decimalSymbol, digitGroupingSymbol)) : (Conversion.isBoolean(objParam) ? Boolean.valueOf(Conversion.objectToBoolean(objParam, decimalSymbol, digitGroupingSymbol)) : ((!Features.ADD_TIME_TO_MACRO_DEF || 0 != strParam.length()) && Conversion.isDoubleOrLong(objParam, decimalSymbol, digitGroupingSymbol) ? Double.valueOf(Conversion.objectToDouble(objParam, decimalSymbol, digitGroupingSymbol)) : (!Features.DONT_CONVERT_DATE_STRING_TO_DATETIME && Conversion.isDateTime(objParam) ? Conversion.objectToDateTime(objParam) : objParam.toString()))));
        }
        return resParams;
    }

    public static DateTime objectToDateTime(Object objParam) {
        Object[] params;
        CalculatorDateValue calc;
        Object res;
        if (null == objParam) {
            return null;
        }
        objParam = Conversion.sanitizeFromVariableValue(objParam);
        DateTime result = null;
        if (objParam instanceof DateTime) {
            result = (DateTime)objParam;
        } else if (objParam instanceof Long) {
            result = new DateTime(((Long)objParam).longValue());
        } else if (objParam instanceof Double) {
            result = new DateTime((Double)objParam);
        } else if (Features.SMART_ISDATETIME_FUNC && CalculatorDateValue.isDateTime(objParam) && null != (res = (calc = new CalculatorDateValue('.', "")).Calculate(params = new Object[]{objParam})) && res instanceof DateTime) {
            result = (DateTime)res;
        }
        return result;
    }

    public static double parseDouble(Object value, char decimalSymbol, String digitGroupingSymbol) throws NumberFormatException {
        double result = 0.0;
        if (!Features.CORRECT_NUMBER_FORMATTING) {
            String strValue = null == value ? "" : value.toString();
            result = Double.parseDouble(strValue);
        } else {
            if (!Conversion.containsNumericalSymbolsOnly(value, true, decimalSymbol, digitGroupingSymbol)) {
                throw new NumberFormatException();
            }
            try {
                if (value instanceof Double) {
                    return (Double)value;
                }
                if (value instanceof Long) {
                    return ((Long)value).longValue();
                }
                DecimalFormat df = new DecimalFormat();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator(decimalSymbol);
                if (null != digitGroupingSymbol && digitGroupingSymbol.length() > 0) {
                    symbols.setGroupingSeparator(digitGroupingSymbol.charAt(0));
                }
                df.setParseIntegerOnly(false);
                df.setDecimalFormatSymbols(symbols);
                String strValue = null == value ? "" : value.toString();
                Number number = df.parse(strValue);
                result = number.doubleValue();
            }
            catch (Exception e) {
                String strValue = null == value ? "" : value.toString();
                result = Double.parseDouble(strValue);
            }
        }
        return result;
    }

    public static long parseLong(String value, char decimalSymbol, String digitGroupingSymbol) throws NumberFormatException {
        long result = 0L;
        if (!Features.CORRECT_NUMBER_FORMATTING) {
            result = Long.parseLong(value);
        } else {
            if (!Conversion.containsNumericalSymbolsOnly(value, false, decimalSymbol, digitGroupingSymbol)) {
                throw new NumberFormatException();
            }
            try {
                DecimalFormat df = new DecimalFormat();
                DecimalFormatSymbols symbols = new DecimalFormatSymbols();
                symbols.setDecimalSeparator(decimalSymbol);
                if (null != digitGroupingSymbol && digitGroupingSymbol.length() > 0) {
                    symbols.setGroupingSeparator(digitGroupingSymbol.charAt(0));
                }
                df.setParseIntegerOnly(true);
                df.setDecimalFormatSymbols(symbols);
                Number number = df.parse(value);
                if (value.contains("" + decimalSymbol)) {
                    throw new NumberFormatException("Value '" + value + "' looks to be double, while it should be integer.");
                }
                result = number.longValue();
            }
            catch (Exception e) {
                result = Long.parseLong(value);
            }
        }
        return result;
    }

    public static boolean containsNumericalSymbolsOnly(Object objParam, boolean mayBeDouble, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam) {
            return false;
        }
        if (objParam instanceof Double && (!Features.CORRECT_NUMBER_PARSING || mayBeDouble) || objParam instanceof Long) {
            return true;
        }
        String strParam = objParam.toString();
        int len = strParam.length();
        if (Features.CHANGES_IN_CONVERSION && len > 20) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            char ch = strParam.charAt(i);
            if (mayBeDouble && ch == decimalSymbol && i > 0 && i < len - 1 && Character.isDigit(strParam.charAt(i - 1)) && Character.isDigit(strParam.charAt(i + 1)) || null != digitGroupingSymbol && 1 == digitGroupingSymbol.length() && i > 0 && i < len - 1 && ch == digitGroupingSymbol.charAt(0) && Character.isDigit(strParam.charAt(i - 1)) && Character.isDigit(strParam.charAt(i + 1)) || ch == '-' && 0 == i || Character.isDigit(ch)) continue;
            return false;
        }
        return true;
    }

    public static double objectToDouble(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam || Features.ZERO_LENGTH_STRING_IS_ZERO && objParam.toString().length() < 1) {
            return 0.0;
        }
        objParam = Conversion.sanitizeFromVariableValue(objParam);
        double result = 0.0;
        if (objParam instanceof VariableValue) {
            objParam = ((VariableValue)objParam).getValue();
        }
        if (objParam instanceof Double) {
            result = (Double)objParam;
        } else if (objParam instanceof Long) {
            result = ((Long)objParam).longValue();
        } else {
            try {
                result = Conversion.parseDouble(Conversion.trimIfTrimmingIsEnabled(objParam), decimalSymbol, digitGroupingSymbol);
            }
            catch (NumberFormatException nfe) {
                result = MacroHelper.findNumber(Conversion.trimIfTrimmingIsEnabled(objParam), true, 0.0, decimalSymbol, digitGroupingSymbol);
            }
        }
        return result;
    }

    public static long objectToLong(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam) {
            return 0L;
        }
        objParam = Conversion.sanitizeFromVariableValue(objParam);
        long result = 0L;
        if (objParam instanceof Long) {
            result = (Long)objParam;
        } else {
            try {
                result = Conversion.parseLong(Conversion.trimIfTrimmingIsEnabled(objParam), decimalSymbol, digitGroupingSymbol);
            }
            catch (NumberFormatException nfe) {
                result = 0L;
            }
        }
        return result;
    }

    public static boolean isNumeric(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam || objParam.toString().length() < 1) {
            return false;
        }
        if ((objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof Long || objParam instanceof Double) {
            return true;
        }
        String strParam = Conversion.trimIfTrimmingIsEnabled(objParam);
        if (Features.CORRECT_NUMBER_FORMATTING) {
            try {
                Conversion.parseDouble(strParam, decimalSymbol, digitGroupingSymbol);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return strParam.matches("-?\\d+(\\.\\d+)?");
    }

    public static boolean isDateTime(Object objParam) {
        if (null == objParam || objParam.toString().length() < 1) {
            return false;
        }
        if ((objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof DateTime) {
            return true;
        }
        return Features.SMART_ISDATETIME_FUNC && CalculatorDateValue.isDateTime(objParam);
    }

    public static boolean isLong(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam || objParam.toString().length() < 1) {
            return false;
        }
        if ((objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof Long) {
            return true;
        }
        if (Features.CORRECT_NUMBER_PARSING && objParam instanceof Double) {
            return false;
        }
        String strParam = Conversion.trimIfTrimmingIsEnabled(objParam);
        if (Features.CORRECT_NUMBER_FORMATTING) {
            try {
                Conversion.parseLong(strParam, decimalSymbol, digitGroupingSymbol);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        String regex = "-?\\d+";
        return strParam.matches(regex);
    }

    public static boolean isRange(Object objParam) {
        if (null == objParam) {
            return false;
        }
        return (objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof VariableRange;
    }

    public static boolean isDoubleOrLong(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        String str;
        if (null == objParam || objParam.toString().length() < 1) {
            return false;
        }
        if (Features.ADDITIONAL_CHECKS_IN_TRIM && (null == (str = Conversion.trimIfTrimmingIsEnabled(objParam)) || 0 == str.length())) {
            return false;
        }
        if ((objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof Long || objParam instanceof Double) {
            return true;
        }
        String strParam = Conversion.trimIfTrimmingIsEnabled(objParam);
        if (Features.CORRECT_NUMBER_FORMATTING) {
            try {
                Conversion.parseDouble(strParam, decimalSymbol, digitGroupingSymbol);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        String regex = Features.BETTER_NUMBER_MATCHING_REGEXP ? "-?\\d*(\\.\\d+)?" : "-?\\d+(\\.\\d+)?";
        return strParam.matches(regex);
    }

    public static boolean isBoolean(Object objParam) {
        if (null == objParam || objParam.toString().length() < 1) {
            return false;
        }
        if ((objParam = Conversion.sanitizeFromVariableValue(objParam)) instanceof Boolean) {
            return true;
        }
        return 0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("true") || 0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("false");
    }

    public static String trimIfTrimmingIsEnabled(Object objParam) {
        if (null == objParam) {
            return null;
        }
        String strParam = objParam.toString();
        if (Features.TRIM_STRING_FOR_NUMERIC_VALUES) {
            strParam = Features.CHANGES_IN_CONVERSION ? Conversion.allTrim2(strParam) : Conversion.allTrim(strParam);
        }
        return strParam;
    }

    static String allTrim(String str) {
        int j = 0;
        int lspaces = 0;
        char[] ch = str.toCharArray();
        byte[] bytes = str.getBytes();
        String nbsp = "&nbsp;";
        j = 0;
        lspaces = 0;
        while (j < bytes.length) {
            if (j < bytes.length && (bytes[j] < 0 || ch[j] == ' ')) {
                ++lspaces;
                ++j;
                continue;
            }
            if (!Features.NBSP_SUPPORT_IN_TRIM || j >= ch.length - nbsp.length() + 1 || !str.startsWith(nbsp, j)) break;
            lspaces += nbsp.length();
            j += nbsp.length();
        }
        if (Features.ADDITIONAL_CHECKS_IN_TRIM && lspaces >= str.length()) {
            return "";
        }
        j = bytes.length - 1;
        int lastIndex = bytes.length - 1;
        while (j > lspaces) {
            if (!(j <= lspaces || Features.ADDITIONAL_CHECKS_IN_TRIM_2 && j >= bytes.length || bytes[j] >= 0 && ch[j] != ' ')) {
                --lastIndex;
                --j;
                continue;
            }
            if (!Features.NBSP_SUPPORT_IN_TRIM || j - nbsp.length() + 1 <= lspaces || !str.startsWith(nbsp, j - nbsp.length() + 1)) break;
            lastIndex -= nbsp.length();
            j -= nbsp.length();
        }
        String result = str.substring(lspaces, lastIndex + 1);
        return result;
    }

    public static String allTrim2(String str) {
        boolean atLeastOne;
        boolean atLeastOne2;
        if (null == str || str.length() < 1) {
            return "";
        }
        String[] spaces = new String[]{" ", "&nbsp;", "\u00a0"};
        int slen = spaces.length;
        int len = str.length();
        int startIndex = 0;
        do {
            atLeastOne2 = false;
            for (int i = 0; i < slen; ++i) {
                String space = spaces[i];
                int splen = space.length();
                while (startIndex < len + splen && str.startsWith(space, startIndex)) {
                    atLeastOne2 = true;
                    startIndex += splen;
                }
            }
        } while (atLeastOne2);
        if (startIndex >= len) {
            return "";
        }
        str = str.substring(startIndex);
        int endIndex = len = str.length();
        do {
            atLeastOne = false;
            for (int i = 0; i < slen; ++i) {
                String space = spaces[i];
                int splen = space.length();
                while (endIndex - splen >= 0 && str.startsWith(space, endIndex - splen)) {
                    atLeastOne = true;
                    endIndex -= splen;
                }
            }
        } while (atLeastOne);
        if (endIndex < 0) {
            return "";
        }
        str = str.substring(0, endIndex);
        return str;
    }

    public static boolean objectToBoolean(Object objParam, char decimalSymbol, String digitGroupingSymbol) {
        if (null == objParam) {
            return false;
        }
        objParam = Conversion.sanitizeFromVariableValue(objParam);
        boolean result = false;
        if (objParam instanceof Boolean) {
            result = (Boolean)objParam;
        } else if (objParam instanceof Long) {
            result = (Long)objParam != 0L;
        } else if (0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("true") || 0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("1")) {
            result = true;
        } else if (0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("false") || 0 == Conversion.trimIfTrimmingIsEnabled(objParam).compareToIgnoreCase("0")) {
            result = false;
        } else {
            try {
                result = Math.abs(Conversion.parseDouble(Conversion.trimIfTrimmingIsEnabled(objParam), decimalSymbol, digitGroupingSymbol)) > Calculator.eps;
            }
            catch (NumberFormatException nfe) {
                result = Math.abs(MacroHelper.findNumber(Conversion.trimIfTrimmingIsEnabled(objParam), true, 0.0, decimalSymbol, digitGroupingSymbol)) > Calculator.eps;
            }
        }
        return result;
    }

    public static boolean objectsAreEqual(Object obj1, Object obj2, char decimalSymbol, String digitGroupingSymbol) {
        if (null == obj1 || null == obj2) {
            return false;
        }
        Object param1 = Conversion.sanitizeFromVariableValue(obj1);
        Object param2 = Conversion.sanitizeFromVariableValue(obj2);
        if (Conversion.isLong(param1, decimalSymbol, digitGroupingSymbol) && Conversion.isLong(param2, decimalSymbol, digitGroupingSymbol)) {
            return Conversion.objectToLong(param1, decimalSymbol, digitGroupingSymbol) == Conversion.objectToLong(param2, decimalSymbol, digitGroupingSymbol);
        }
        if (Conversion.isBoolean(param1) && Conversion.isBoolean(param2)) {
            return Conversion.objectToBoolean(param1, decimalSymbol, digitGroupingSymbol) == Conversion.objectToBoolean(param2, decimalSymbol, digitGroupingSymbol);
        }
        if (Conversion.isDoubleOrLong(param1, decimalSymbol, digitGroupingSymbol) && Conversion.isDoubleOrLong(param2, decimalSymbol, digitGroupingSymbol)) {
            return Math.abs(Conversion.objectToDouble(param1, decimalSymbol, digitGroupingSymbol) - Conversion.objectToDouble(param2, decimalSymbol, digitGroupingSymbol)) < Calculator.eps;
        }
        return param1.toString().compareTo(param2.toString()) == 0;
    }

    public static void checkToBeDouble(Object param, String paramName, char decimalSymbol, String digitGroupingSymbol) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, decimalSymbol, digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    public static void checkToBeLong(Object param, String paramName, char decimalSymbol, String digitGroupingSymbol) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isLong(param, decimalSymbol, digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Long.");
        }
    }
}

