/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.Operation;
import com.celestecs.expression.OperationKind;
import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.PriorityAssociation;
import com.celestecs.expression.exceptions.BracesSyntaxException;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import com.celestecs.expression.exceptions.OperandsDisbalanceException;
import com.celestecs.expression.exceptions.TypeMismatchException;
import com.celestecs.expression.exceptions.UnexpectedItemException;
import com.celestecs.expression.expressions.CompiledExpression;
import com.celestecs.expression.expressions.CompiledExpressionItem;
import com.celestecs.expression.expressions.CompiledExpressionItemKind;
import com.celestecs.expression.expressions.DelimiterKind;
import com.celestecs.expression.expressions.PreparedExpression;
import com.celestecs.expression.expressions.PreparedExpressionItem;
import com.celestecs.expression.expressions.PreparedExpressionItemKind;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class Compiler {
    private OperationsRegistry operationsRegistry;

    public OperationsRegistry getOperationsRegistry() {
        return this.operationsRegistry;
    }

    public Compiler(OperationsRegistry operationsRegistry) {
        if (operationsRegistry == null) {
            throw new IllegalArgumentException("operationsRegistry");
        }
        this.operationsRegistry = operationsRegistry;
    }

    public CompiledExpression Compile(PreparedExpression preparedExpression) {
        if (preparedExpression == null) {
            throw new IllegalArgumentException("preparedExpression");
        }
        OperationsStack operationsStack = new OperationsStack(this.operationsRegistry);
        block0: for (int itemIndex = 0; itemIndex < preparedExpression.getPreparedExpressionItems().size(); ++itemIndex) {
            PreparedExpressionItem item = preparedExpression.getPreparedExpressionItems().get(itemIndex);
            if (item.getKind() == PreparedExpressionItemKind.Constant) {
                operationsStack.PushConstant(item.getConstant());
            }
            if (item.getKind() == PreparedExpressionItemKind.Variable) {
                String varName = item.getVariableName();
                operationsStack.PushVariable(varName);
            }
            if (item.getKind() == PreparedExpressionItemKind.Delimiter) {
                operationsStack.PushDelimiter(item.getDelimiterKind());
            }
            if (item.getKind() != PreparedExpressionItemKind.Signature) continue;
            ArrayList<Operation> operations = new ArrayList<Operation>(this.operationsRegistry.GetOperationsUsingSignature(item.getSignature()));
            Collections.sort(operations, new OpComparator());
            for (int i = 0; i < operations.size(); ++i) {
                Operation operation = operations.get(i);
                if (operation.getKind() == OperationKind.Operator) {
                    OperationsStackItem stackItem = null;
                    if (operation.getOperandsCount() == 1 && (itemIndex == 0 || itemIndex > 0 && preparedExpression.getPreparedExpressionItems().get(itemIndex - 1).getKind() == PreparedExpressionItemKind.Delimiter && (preparedExpression.getPreparedExpressionItems().get(itemIndex - 1).getDelimiterKind() == DelimiterKind.OpeningBrace || Features.NAGATIVE_NUMBER_SECOND_PARAMETER_FIX && preparedExpression.getPreparedExpressionItems().get(itemIndex - 1).getDelimiterKind() == DelimiterKind.Comma) || preparedExpression.getPreparedExpressionItems().get(itemIndex - 1).getKind() == PreparedExpressionItemKind.Signature)) {
                        stackItem = operationsStack.PushUnaryOperator(operation);
                        stackItem.setOperationParamCount(operation.getOperandsCount());
                        continue block0;
                    }
                    if (operation.getOperandsCount() == 2) {
                        stackItem = operationsStack.PushBinaryOperator(operation);
                        stackItem.setOperationParamCount(operation.getOperandsCount());
                        continue block0;
                    }
                    if (operation.getOperandsCount() > 2) {
                        int partNumber = 0;
                        for (int k = 0; k < operation.getSignature().length; ++k) {
                            if (operation.getSignature()[k].compareTo(item.getSignature()) != 0) continue;
                            partNumber = k + 1;
                            break;
                        }
                        if (partNumber == 1) {
                            stackItem = operationsStack.PushComplexOperatorFirstSignature(operation);
                            stackItem.setOperationParamCount(operation.getOperandsCount());
                            continue block0;
                        }
                        operationsStack.PushComplexOperatorNonFirstSignature(operation, partNumber);
                        continue block0;
                    }
                }
                if (operation.getKind() != OperationKind.Function) continue;
                int numOfOperands = this.getNumOfOperands(preparedExpression, itemIndex);
                OperationsStackItem op = null;
                op = operationsStack.PushFunction(operation);
                op.setOperationParamCount(numOfOperands);
                MacroHelper.Log("Function '" + op.getOperationName() + "' has " + numOfOperands + " operands");
                continue block0;
            }
        }
        operationsStack.DoFinalFlush();
        CompiledExpression res = operationsStack.GetResult();
        if (!this.isCompiledExpressionStackBalanced(res)) {
            throw new OperandsDisbalanceException();
        }
        return res;
    }

    /*
     * Enabled aggressive block sorting
     */
    private int getNumOfOperands(PreparedExpression preparedExpression, int itemStartIndex) {
        if (null == preparedExpression || null == preparedExpression.getPreparedExpressionItems() || itemStartIndex >= preparedExpression.getPreparedExpressionItems().size() - 1) {
            return -1;
        }
        PreparedExpressionItem item = null;
        item = preparedExpression.getPreparedExpressionItems().get(itemStartIndex + 1);
        if (null == item) return 0;
        if (item.getKind() != PreparedExpressionItemKind.Delimiter) {
            return 0;
        }
        int itemIndex = itemStartIndex + 2;
        int operationCount = preparedExpression.getPreparedExpressionItems().size();
        int bracketsLevel = 0;
        int count = 0;
        boolean isFirstAfterDelimeter = true;
        while (itemIndex < operationCount) {
            item = preparedExpression.getPreparedExpressionItems().get(itemIndex);
            if (null == item) {
                return 0;
            }
            switch (item.getKind()) {
                case Constant: {
                    if (bracketsLevel != 0 || !isFirstAfterDelimeter) break;
                    isFirstAfterDelimeter = false;
                    ++count;
                    break;
                }
                case Variable: {
                    if (bracketsLevel != 0 || !isFirstAfterDelimeter) break;
                    isFirstAfterDelimeter = false;
                    ++count;
                    break;
                }
                case Delimiter: {
                    switch (item.getDelimiterKind()) {
                        case OpeningBrace: {
                            if (bracketsLevel == 0 && isFirstAfterDelimeter) {
                                isFirstAfterDelimeter = false;
                                ++count;
                            }
                            ++bracketsLevel;
                            break;
                        }
                        case ClosingBrace: {
                            if (--bracketsLevel >= 0) break;
                            return count;
                        }
                        case Comma: {
                            if (bracketsLevel != 0) break;
                            isFirstAfterDelimeter = true;
                            break;
                        }
                    }
                    break;
                }
                case Signature: {
                    Collection<Operation> operations = this.operationsRegistry.GetOperationsUsingSignature(item.getSignature());
                    if (operations.size() <= 0 || null == operations.toArray()[0]) break;
                    switch (((Operation)operations.toArray()[0]).getKind()) {
                        case Operator: {
                            break;
                        }
                        case Function: {
                            if (bracketsLevel != 0 || !isFirstAfterDelimeter) break;
                            isFirstAfterDelimeter = false;
                            ++count;
                        }
                    }
                    break;
                }
            }
            ++itemIndex;
        }
        return count;
    }

    public static List<String> rangeToVarNames(String varName) {
        int found;
        ArrayList<String> result = new ArrayList<String>();
        int startIndex = 0;
        if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && (found = varName.toLowerCase().indexOf("]Table".toLowerCase())) > -1) {
            startIndex = found + 1;
        }
        if (varName.indexOf(":", startIndex) < 0) {
            result.add(varName);
        } else {
            String elemName = "";
            int index1 = varName.indexOf("!", startIndex);
            if (index1 < 0) {
                index1 = varName.indexOf(".", startIndex);
            }
            if (index1 > -1) {
                elemName = varName.substring(0, index1 + 1);
            }
            int index2 = varName.indexOf(":", startIndex);
            String rangeStart = varName.substring(++index1, index2);
            String rangeFinish = varName.substring(index2 + 1, varName.length());
            int[] indices1 = Compiler.getIndexes(rangeStart);
            int[] indices2 = Compiler.getIndexes(rangeFinish);
            if (null != indices1 && indices1[0] >= 0 && indices1[1] >= 0 || null != indices2 && indices2[0] >= 0 && indices2[1] >= 0) {
                int intRowIndex2;
                int intColumnIndex1 = Math.min(indices1[0], indices2[0]);
                int intRowIndex1 = Math.min(indices1[1], indices2[1]);
                int intColumnIndex2 = Math.max(indices1[0], indices2[0]);
                for (int i = intRowIndex2 = Math.max(indices1[1], indices2[1]); i >= intRowIndex1; --i) {
                    for (int j = intColumnIndex2; j >= intColumnIndex1; --j) {
                        String curVarName = elemName + MacroHelper.GenerateSequence(j).toLowerCase() + i;
                        result.add(curVarName);
                    }
                }
            }
        }
        return result;
    }

    protected static int getFirstTdRowIndex(MacroHelper.TableElementType[][] getTableElementTypes, int colIndex) {
        if (null == getTableElementTypes || getTableElementTypes.length < 1 || getTableElementTypes[0].length < colIndex) {
            return -1;
        }
        for (int i = 0; i < getTableElementTypes.length; ++i) {
            if (MacroHelper.TableElementType.Td != getTableElementTypes[i][colIndex]) continue;
            return i;
        }
        return -1;
    }

    protected static int getFirstTdColIndex(MacroHelper.TableElementType[][] getTableElementTypes, int rowIndex) {
        if (null == getTableElementTypes || getTableElementTypes.length < rowIndex) {
            return -1;
        }
        for (int j = 0; j < getTableElementTypes[rowIndex].length; ++j) {
            if (MacroHelper.TableElementType.Td != getTableElementTypes[rowIndex][j]) continue;
            return j;
        }
        return -1;
    }

    public static String[][] rangeToVarNamesAsArray(String varName, PageContentProvider pageContentProvider, MathTextResolver i18n) throws ExpressionCalculationException {
        int found;
        String[][] result = null;
        int startIndex = 0;
        if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && (found = varName.toLowerCase().indexOf("]Table".toLowerCase())) > -1) {
            startIndex = found + 1;
        }
        if (varName.indexOf(":", startIndex) < 0) {
            result = new String[1][1];
            result[0][0] = varName;
        } else {
            boolean hasDollars = false;
            if (Features.FORMULA_SUPPORT_IN_CONDITIONS && varName.contains("$")) {
                hasDollars = true;
            }
            boolean isWholeColumnRange = false;
            boolean isWholeRowRange = false;
            if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && null != pageContentProvider) {
                String s;
                Matcher m;
                Pattern p;
                int i;
                ArrayList<String> patterns = null;
                patterns = new ArrayList<String>();
                patterns.add("Table[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+");
                patterns.add("CurrentTable[.!][a-zA-Z]+:[a-zA-Z]+");
                patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+");
                for (i = 0; i < patterns.size(); ++i) {
                    p = Pattern.compile((String)patterns.get(i), 2);
                    m = p.matcher(varName);
                    if (!m.find() || null == (s = m.group()) || 0 != s.compareTo(varName)) continue;
                    isWholeColumnRange = true;
                    break;
                }
                patterns = new ArrayList();
                patterns.add("Table[0-9]+[.!][0-9]+:[0-9]+");
                patterns.add("CurrentTable[.!][0-9]+:[0-9]+");
                patterns.add("\\x5B[0-9]+\\x5DTable[0-9]+[.!][0-9]+:[0-9]+");
                for (i = 0; i < patterns.size(); ++i) {
                    p = Pattern.compile((String)patterns.get(i), 2);
                    m = p.matcher(varName);
                    if (!m.find() || null == (s = m.group()) || 0 != s.compareTo(varName)) continue;
                    isWholeRowRange = true;
                    break;
                }
            }
            if (!isWholeColumnRange && !isWholeRowRange) {
                String elemName = "";
                int index1 = varName.indexOf("!", startIndex);
                if (index1 < 0) {
                    index1 = varName.indexOf(".", startIndex);
                }
                if (index1 > -1) {
                    elemName = varName.substring(0, index1 + 1);
                }
                int index2 = varName.indexOf(":", startIndex);
                String rangeStart = varName.substring(++index1, index2);
                String rangeFinish = varName.substring(index2 + 1, varName.length());
                int[] indices1 = Compiler.getIndexes(rangeStart);
                int[] indices2 = Compiler.getIndexes(rangeFinish);
                if (!(null == indices1 || indices1[0] < 0 && indices1[1] < 0 || null == indices2 || indices2[0] < 0 && indices2[1] < 0)) {
                    int intColumnIndex1 = Math.min(indices1[0], indices2[0]);
                    int intRowIndex1 = Math.min(indices1[1], indices2[1]);
                    int intColumnIndex2 = Math.max(indices1[0], indices2[0]);
                    int intRowIndex2 = Math.max(indices1[1], indices2[1]);
                    boolean onlyRowsAreSpecified = false;
                    boolean onlyColumnsAreSpecified = false;
                    boolean bothRowsAndColumnsAreSpecified = false;
                    if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT) {
                        if (intColumnIndex1 < 0 && intColumnIndex2 < 0 && intRowIndex1 >= 0 && intRowIndex2 >= 0) {
                            onlyRowsAreSpecified = true;
                        }
                        if (intColumnIndex1 >= 0 && intColumnIndex2 >= 0 && intRowIndex1 < 0 && intRowIndex2 < 0) {
                            onlyColumnsAreSpecified = true;
                        }
                    }
                    if (intColumnIndex1 >= 0 && intColumnIndex2 >= 0 && intRowIndex1 >= 0 && intRowIndex2 >= 0) {
                        bothRowsAndColumnsAreSpecified = true;
                    }
                    if (onlyRowsAreSpecified) {
                        result = new String[intRowIndex2 - intRowIndex1 + 1][1];
                        for (int i = intRowIndex2; i >= intRowIndex1; --i) {
                            for (int j = 0; j >= 0; --j) {
                                String curVarName;
                                result[i - intRowIndex1][0] = curVarName = elemName + "*" + i;
                            }
                        }
                    } else if (onlyColumnsAreSpecified) {
                        result = new String[1][intColumnIndex2 - intColumnIndex1 + 1];
                        for (int i = 0; i >= 0; --i) {
                            for (int j = intColumnIndex2; j >= intColumnIndex1; --j) {
                                String curVarName;
                                result[0][j - intColumnIndex1] = curVarName = elemName + MacroHelper.GenerateSequence(j).toLowerCase() + "*";
                            }
                        }
                    } else if (bothRowsAndColumnsAreSpecified) {
                        result = new String[intRowIndex2 - intRowIndex1 + 1][intColumnIndex2 - intColumnIndex1 + 1];
                        for (int i = intRowIndex2; i >= intRowIndex1; --i) {
                            for (int j = intColumnIndex2; j >= intColumnIndex1; --j) {
                                String curVarName;
                                result[i - intRowIndex1][j - intColumnIndex1] = curVarName = elemName + (hasDollars ? "$" : "") + MacroHelper.GenerateSequence(j).toLowerCase() + (hasDollars ? "$" : "") + i;
                            }
                        }
                    }
                }
            } else {
                int index1;
                String name = varName;
                String elemName = "";
                String pageId = "";
                if (Features.ANY_PAGE_AS_A_SOURCE) {
                    pageId = MacroHelper.getPageIdFromVarName(name);
                }
                int elemIndex = -1;
                if (Features.CURRENT_TABLE_SUPPORT && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                    elemIndex = 0;
                }
                if (elemIndex < 0) {
                    elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                }
                if ((index1 = varName.indexOf("!", startIndex)) < 0) {
                    index1 = varName.indexOf(".", startIndex);
                }
                if (index1 > -1) {
                    elemName = varName.substring(0, index1 + 1);
                }
                int index2 = varName.indexOf(":", startIndex);
                String rangeStart = varName.substring(++index1, index2);
                String rangeFinish = varName.substring(index2 + 1, varName.length());
                int[] indices1 = Compiler.getIndexes(rangeStart);
                int[] indices2 = Compiler.getIndexes(rangeFinish);
                MacroHelper.TableElementType[][] tableElementTypes = MacroHelper.getTableElementTypes(pageId, elemIndex, pageContentProvider, i18n);
                if (null != tableElementTypes && tableElementTypes.length > 0 && tableElementTypes[0].length > 0) {
                    int intColumnIndexZeroBased1 = -1;
                    int intRowIndexZeroBased1 = -1;
                    int intColumnIndexZeroBased2 = -1;
                    int intRowIndexZeroBased2 = -1;
                    if (isWholeColumnRange && isWholeRowRange) {
                        intColumnIndexZeroBased1 = 0;
                        intRowIndexZeroBased1 = 0;
                        intColumnIndexZeroBased2 = tableElementTypes[0].length - 1;
                        intRowIndexZeroBased2 = tableElementTypes.length - 1;
                    } else if (isWholeColumnRange) {
                        intColumnIndexZeroBased1 = Math.min(indices1[0] - 1, indices2[0] - 1);
                        intRowIndexZeroBased1 = 0;
                        intColumnIndexZeroBased2 = Math.max(indices1[0] - 1, indices2[0] - 1);
                        intRowIndexZeroBased2 = tableElementTypes.length - 1;
                    } else if (isWholeRowRange) {
                        intColumnIndexZeroBased1 = 0;
                        intRowIndexZeroBased1 = Math.min(indices1[1] - 1, indices2[1] - 1);
                        intColumnIndexZeroBased2 = tableElementTypes[0].length - 1;
                        intRowIndexZeroBased2 = Math.max(indices1[1] - 1, indices2[1] - 1);
                    }
                    result = new String[intRowIndexZeroBased2 - intRowIndexZeroBased1 + 1][intColumnIndexZeroBased2 - intColumnIndexZeroBased1 + 1];
                    for (int i = intRowIndexZeroBased1; i <= intRowIndexZeroBased2; ++i) {
                        for (int j = intColumnIndexZeroBased1; j <= intColumnIndexZeroBased2; ++j) {
                            String curVarName;
                            result[i - intRowIndexZeroBased1][j - intColumnIndexZeroBased1] = MacroHelper.TableElementType.Td != tableElementTypes[i][j] ? "" : (curVarName = elemName + MacroHelper.GenerateSequence(j + 1).toLowerCase() + (i + 1));
                        }
                    }
                } else {
                    result = new String[0][0];
                }
            }
        }
        return result;
    }

    public static int[] getIndexes(String varName) {
        int intColumnIndex;
        int intRowIndex;
        int[] result;
        block11: {
            int startIndex;
            result = new int[]{-1, -1};
            intRowIndex = -1;
            intColumnIndex = -1;
            boolean res = false;
            String str = "";
            int len = varName.length();
            if (Features.FORMULA_SUPPORT_IN_CONDITIONS) {
                for (startIndex = 0; startIndex < varName.length() && '$' == varName.charAt(startIndex); ++startIndex) {
                }
            }
            while (startIndex < len && Character.isLetter(varName.charAt(startIndex))) {
                str = str + varName.charAt(startIndex);
                res = true;
                ++startIndex;
            }
            if (!res && !Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT) {
                result[0] = -1;
                result[1] = -1;
                return result;
            }
            int n = intColumnIndex = res ? MacroHelper.getExcelColumnNumber(str) : -1;
            if (intColumnIndex < 0 && !Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT) {
                result[0] = -1;
                result[1] = -1;
                return result;
            }
            res = false;
            str = "";
            if (Features.FORMULA_SUPPORT_IN_CONDITIONS) {
                while (startIndex < varName.length() && '$' == varName.charAt(startIndex)) {
                    ++startIndex;
                }
            }
            while (startIndex < len && Character.isDigit(varName.charAt(startIndex))) {
                str = str + varName.charAt(startIndex);
                res = true;
                ++startIndex;
            }
            if (!res && !Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT) {
                result[0] = -1;
                result[1] = -1;
                return result;
            }
            try {
                intRowIndex = Integer.parseInt(str);
            }
            catch (Exception e) {
                if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT) break block11;
                result[0] = -1;
                result[1] = -1;
                return result;
            }
        }
        result[0] = intColumnIndex;
        result[1] = intRowIndex;
        return result;
    }

    private boolean isCompiledExpressionStackBalanced(CompiledExpression compiledExpression) {
        if (compiledExpression == null) {
            throw new IllegalArgumentException("compiledExpression");
        }
        int stackPointer = 0;
        boolean hasVariableParamFunction = false;
        block5: for (int i = 0; i < compiledExpression.getCompiledExpressionItems().size(); ++i) {
            CompiledExpressionItem item = compiledExpression.getCompiledExpressionItems().get(i);
            switch (item.getKind()) {
                case CONSTANT: {
                    ++stackPointer;
                    continue block5;
                }
                case VARIABLE: {
                    ++stackPointer;
                    continue block5;
                }
                case OPERATION: {
                    int paramCount = item.getOperationParamCount();
                    stackPointer -= paramCount - 1;
                    continue block5;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown item kind.");
                }
            }
        }
        return stackPointer == true || hasVariableParamFunction;
    }

    private static final class OperationsStack {
        private final ArrayList<CompiledExpressionItem> res = new ArrayList();
        private final ArrayList<OperationsStackItem> stack = new ArrayList();
        private OperationsRegistry operationsRegistry;

        public OperationsStack(OperationsRegistry operationsRegistry) {
            if (operationsRegistry == null) {
                throw new IllegalArgumentException("operationsRegistry");
            }
            this.operationsRegistry = operationsRegistry;
        }

        public void PushConstant(Object constant) {
            this.res.add(new CompiledExpressionItem(CompiledExpressionItemKind.CONSTANT, constant, -1));
        }

        public void PushVariable(String variableName) {
            this.res.add(new CompiledExpressionItem(CompiledExpressionItemKind.VARIABLE, variableName, -1));
        }

        public void PushDelimiter(DelimiterKind delimiterKind) {
            CompiledExpressionItem expressionItem;
            OperationsStackItem stackItem;
            int j;
            if (delimiterKind == DelimiterKind.OpeningBrace) {
                this.stack.add(new OperationsStackItem(OperationStackItemKind.Delimiter, (Object)DelimiterKind.OpeningBrace));
            }
            if (delimiterKind == DelimiterKind.ClosingBrace) {
                block6: for (j = this.stack.size() - 1; j >= 0; --j) {
                    if (this.stack.get(j).getKind() == OperationStackItemKind.Delimiter && this.stack.get(j).getDelimiter() == DelimiterKind.OpeningBrace) {
                        this.stack.remove(j);
                        break;
                    }
                    switch (this.stack.get(j).getKind()) {
                        case Operation: {
                            stackItem = this.stack.get(j);
                            expressionItem = new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                            expressionItem.setOperationParamCount(stackItem.getOperationParamCount());
                            this.res.add(expressionItem);
                            this.stack.remove(j);
                            continue block6;
                        }
                        default: {
                            throw new UnexpectedItemException();
                        }
                    }
                }
                if (j < 0) {
                    throw new BracesSyntaxException();
                }
                if (this.stack.size() > 0 && (stackItem = this.stack.get(this.stack.size() - 1)).getKind() == OperationStackItemKind.Operation) {
                    Operation operation = this.operationsRegistry.GetOperationByName(stackItem.getOperationName());
                    if (stackItem.getKind() == OperationStackItemKind.Operation && operation.getKind() == OperationKind.Function) {
                        CompiledExpressionItem expressionItem2 = new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                        this.res.add(expressionItem2);
                        this.stack.remove(this.stack.size() - 1);
                    }
                }
            }
            if (delimiterKind == DelimiterKind.Comma) {
                block7: for (j = this.stack.size() - 1; j >= 0 && (this.stack.get(j).getKind() != OperationStackItemKind.Delimiter || this.stack.get(j).getDelimiter() != DelimiterKind.OpeningBrace); --j) {
                    switch (this.stack.get(j).getKind()) {
                        case Operation: {
                            stackItem = this.stack.get(j);
                            expressionItem = new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                            this.res.add(expressionItem);
                            this.stack.remove(j);
                            continue block7;
                        }
                        default: {
                            throw new UnexpectedItemException();
                        }
                    }
                }
                if (j < 0) {
                    throw new BracesSyntaxException();
                }
            }
        }

        private void pushOperationAccordingToAssociationAndPriority(Operation operation, OperationsStackItem itemToPush) {
            if (this.stack.size() > 0) {
                boolean priorityExit = false;
                block4: for (int j = this.stack.size() - 1; j >= 0 && !priorityExit && this.stack.get(j).getKind() != OperationStackItemKind.Delimiter; --j) {
                    switch (this.stack.get(j).getKind()) {
                        case Operation: {
                            if (this.operationsRegistry.GetAssociationByPriority(operation.getPriority()) == PriorityAssociation.LeftAssociated) {
                                if (this.operationsRegistry.GetOperationByName(this.stack.get(j).getOperationName()).getPriority() > operation.getPriority()) {
                                    priorityExit = true;
                                }
                            } else if (this.operationsRegistry.GetOperationByName(this.stack.get(j).getOperationName()).getPriority() >= operation.getPriority()) {
                                priorityExit = true;
                            }
                            if (priorityExit) continue block4;
                            OperationsStackItem stackItem = this.stack.get(j);
                            CompiledExpressionItem expressionItem = new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                            expressionItem.setOperationParamCount(operation.getOperandsCount());
                            this.res.add(expressionItem);
                            this.stack.remove(j);
                            continue block4;
                        }
                        case PartialSignature: {
                            priorityExit = true;
                            continue block4;
                        }
                        default: {
                            throw new UnexpectedItemException();
                        }
                    }
                }
            }
            this.stack.add(itemToPush);
        }

        public OperationsStackItem PushUnaryOperator(Operation operation) {
            OperationsStackItem stackItem = new OperationsStackItem(OperationStackItemKind.Operation, operation.getName());
            this.pushOperationAccordingToAssociationAndPriority(operation, stackItem);
            return stackItem;
        }

        public OperationsStackItem PushBinaryOperator(Operation operation) {
            OperationsStackItem stackItem = new OperationsStackItem(OperationStackItemKind.Operation, operation.getName());
            this.pushOperationAccordingToAssociationAndPriority(operation, stackItem);
            return stackItem;
        }

        public OperationsStackItem PushFunction(Operation operation) {
            OperationsStackItem stackItem = new OperationsStackItem(OperationStackItemKind.Operation, operation.getName());
            this.stack.add(stackItem);
            return stackItem;
        }

        public OperationsStackItem PushComplexOperatorFirstSignature(Operation operation) {
            PartialSignature signature = new PartialSignature();
            signature.setOperationName(operation.getName());
            signature.setSignaturePartNumber(1);
            OperationsStackItem item = new OperationsStackItem(OperationStackItemKind.PartialSignature, signature.clone());
            item.setOperationParamCount(operation.getOperandsCount());
            this.pushOperationAccordingToAssociationAndPriority(operation, item);
            return item;
        }

        public void PushComplexOperatorNonFirstSignature(Operation operation, int partNumber) {
            int j;
            block3: for (j = this.stack.size() - 1; !(j < 0 || this.stack.get(j).getKind() == OperationStackItemKind.PartialSignature && this.stack.get(j).getPartialSignature().getOperationName().equals(operation.getName()) && this.stack.get(j).getPartialSignature().getSignaturePartNumber() == partNumber - 1); --j) {
                switch (this.stack.get(j).getKind()) {
                    case Operation: {
                        OperationsStackItem stackItem = this.stack.get(j);
                        new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                        this.stack.remove(j);
                        continue block3;
                    }
                    default: {
                        throw new UnexpectedItemException();
                    }
                }
            }
            if (j < 0) {
                throw new BracesSyntaxException();
            }
            PartialSignature signature = new PartialSignature();
            signature.setOperationName(operation.getName());
            signature.setSignaturePartNumber(partNumber);
            this.stack.add(new OperationsStackItem(OperationStackItemKind.PartialSignature, signature.clone()));
            if (partNumber == operation.getSignature().length) {
                for (int ii = 0; ii < partNumber; ++ii) {
                    this.stack.remove(this.stack.size() - 1);
                }
                this.stack.add(new OperationsStackItem(OperationStackItemKind.Operation, operation.getName()));
            }
        }

        public void DoFinalFlush() {
            block3: for (int j = this.stack.size() - 1; j >= 0; --j) {
                switch (this.stack.get(j).getKind()) {
                    case Operation: {
                        OperationsStackItem stackItem = this.stack.get(j);
                        CompiledExpressionItem expressionItem = new CompiledExpressionItem(CompiledExpressionItemKind.OPERATION, stackItem.getOperationName(), stackItem.getOperationParamCount());
                        expressionItem.setOperationParamCount(stackItem.getOperationParamCount());
                        this.res.add(expressionItem);
                        continue block3;
                    }
                    default: {
                        throw new UnexpectedItemException();
                    }
                }
            }
        }

        public CompiledExpression GetResult() {
            return new CompiledExpression(this.res);
        }
    }

    class OpComparator
    implements Comparator<Operation> {
        OpComparator() {
        }

        @Override
        public int compare(Operation x, Operation y) {
            if (x == null) {
                if (y == null) {
                    return 0;
                }
                return -1;
            }
            if (y == null) {
                return 1;
            }
            if (x.getOperandsCount() > y.getOperandsCount()) {
                return 1;
            }
            if (x.getOperandsCount() < y.getOperandsCount()) {
                return -1;
            }
            return 0;
        }
    }

    private static final class OperationsStackItem {
        private OperationStackItemKind kind = OperationStackItemKind.values()[0];
        private DelimiterKind delimiter;
        private String operationName;
        private int operationParamCount = 0;
        private PartialSignature partialSignature = new PartialSignature();

        public OperationStackItemKind getKind() {
            return this.kind;
        }

        public DelimiterKind getDelimiter() {
            if (this.kind != OperationStackItemKind.Delimiter) {
                throw new TypeMismatchException();
            }
            return this.delimiter;
        }

        public String getOperationName() {
            if (this.kind != OperationStackItemKind.Operation) {
                throw new TypeMismatchException();
            }
            return this.operationName;
        }

        public void setOperationParamCount(int operationParamCount) {
            if (this.kind != OperationStackItemKind.Operation) {
                throw new TypeMismatchException();
            }
            this.operationParamCount = operationParamCount;
        }

        public int getOperationParamCount() {
            if (this.kind != OperationStackItemKind.Operation) {
                throw new TypeMismatchException();
            }
            return this.operationParamCount;
        }

        public PartialSignature getPartialSignature() {
            if (this.kind != OperationStackItemKind.PartialSignature) {
                throw new TypeMismatchException();
            }
            return this.partialSignature;
        }

        public OperationsStackItem(OperationStackItemKind kind, Object value) {
            if (value == null) {
                throw new IllegalArgumentException("value");
            }
            this.kind = kind;
            switch (kind) {
                case Delimiter: {
                    this.delimiter = (DelimiterKind)((Object)value);
                    break;
                }
                case Operation: {
                    this.operationName = (String)value;
                    break;
                }
                case PartialSignature: {
                    this.partialSignature = (PartialSignature)value;
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unexpected item kind.");
                }
            }
        }
    }

    public static enum OperationStackItemKind {
        Delimiter(1),
        Operation(2),
        PartialSignature(3);

        private int intValue;
        private static HashMap<Integer, OperationStackItemKind> mappings;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static HashMap<Integer, OperationStackItemKind> getMappings() {
            Class<OperationStackItemKind> clazz = OperationStackItemKind.class;
            synchronized (OperationStackItemKind.class) {
                if (mappings == null) {
                    mappings = new HashMap();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return mappings;
            }
        }

        private OperationStackItemKind(int value) {
            this.intValue = value;
            OperationStackItemKind.getMappings().put(value, this);
        }

        public int getValue() {
            return this.intValue;
        }

        public static OperationStackItemKind forValue(int value) {
            return OperationStackItemKind.getMappings().get(value);
        }
    }

    private static final class PartialSignature
    implements Cloneable {
        private String _OperationName;
        private int _SignaturePartNumber;

        private PartialSignature() {
        }

        public String getOperationName() {
            return this._OperationName;
        }

        public void setOperationName(String value) {
            this._OperationName = value;
        }

        public int getSignaturePartNumber() {
            return this._SignaturePartNumber;
        }

        public void setSignaturePartNumber(int value) {
            this._SignaturePartNumber = value;
        }

        public PartialSignature clone() {
            PartialSignature varCopy = new PartialSignature();
            varCopy._OperationName = this._OperationName;
            varCopy._SignaturePartNumber = this._SignaturePartNumber;
            return varCopy;
        }
    }
}

