/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.server;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.user.User;
import com.celestecs.expression.QueryExecutor;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.HashMap;

public class ConfluenceServerCachedQueryExecutor
implements QueryExecutor {
    protected static long CACHING_TIMEOUT_IN_SECONDS = 10L;
    protected QueryExecutor sourceQueryExecutor = null;
    protected HashMap<String, CachedData> cacheForNumberOfResults = new HashMap();
    protected HashMap<String, CachedData> cacheForResultFieldValues = new HashMap();
    protected HashMap<String, CachedData> cacheForResultsByQuery = new HashMap();

    public ConfluenceServerCachedQueryExecutor(QueryExecutor sourceQueryExecutor) {
        this.sourceQueryExecutor = sourceQueryExecutor;
    }

    protected String getCurrentUserName() {
        String userName = "";
        User user = AuthenticatedUserThreadLocal.getUser();
        if (null != user) {
            userName = user.getName();
        }
        return userName;
    }

    protected static Object getCachedValue(HashMap<String, CachedData> cache, String key) {
        if (null == cache || null == key) {
            return null;
        }
        CachedData cachedData = cache.get(key);
        if (null == cachedData || null == cachedData.date || null == cachedData.value) {
            return null;
        }
        LocalDateTime currentTime = LocalDateTime.now();
        Duration duration = Duration.between(cachedData.date, currentTime);
        if (duration.getSeconds() > CACHING_TIMEOUT_IN_SECONDS) {
            return null;
        }
        return cachedData.value;
    }

    protected static void putCachedValue(HashMap<String, CachedData> cache, String key, Object value) {
        if (null == cache || null == key || null == value) {
            return;
        }
        cache.remove(key);
        CachedData cachedData = new CachedData(key, value);
        cache.put(key, cachedData);
    }

    @Override
    public long getNumberOfResults(String jqlRequest, String appLinkName) throws Exception {
        String id = this.getCurrentUserName() + jqlRequest + appLinkName;
        Object value = ConfluenceServerCachedQueryExecutor.getCachedValue(this.cacheForNumberOfResults, id);
        if (null == value || !(value instanceof Long)) {
            long lResult = this.sourceQueryExecutor.getNumberOfResults(jqlRequest, appLinkName);
            value = lResult;
            ConfluenceServerCachedQueryExecutor.putCachedValue(this.cacheForNumberOfResults, id, value);
        }
        return (Long)value;
    }

    @Override
    public Object[] getResultFieldValues(String jqlRequest, String fieldName, Object valueIfNull, String appLinkName, boolean byFieldId) throws Exception {
        String id = this.getCurrentUserName() + jqlRequest + fieldName + valueIfNull + appLinkName + byFieldId;
        Object[] value = ConfluenceServerCachedQueryExecutor.getCachedValue(this.cacheForResultFieldValues, id);
        if (null == value || !(value instanceof Object[])) {
            Object[] objResult;
            value = objResult = this.sourceQueryExecutor.getResultFieldValues(jqlRequest, fieldName, valueIfNull, appLinkName, byFieldId);
            ConfluenceServerCachedQueryExecutor.putCachedValue(this.cacheForResultFieldValues, id, value);
        }
        return value;
    }

    @Override
    public Object[] getResultsByQuery(String query, String appLinkName, long startAt, long maxResults) throws Exception {
        String id = this.getCurrentUserName() + query + appLinkName + startAt + maxResults;
        Object[] value = ConfluenceServerCachedQueryExecutor.getCachedValue(this.cacheForResultsByQuery, id);
        if (null == value || !(value instanceof Object[])) {
            Object[] objResult;
            value = objResult = this.sourceQueryExecutor.getResultsByQuery(query, appLinkName, startAt, maxResults);
            ConfluenceServerCachedQueryExecutor.putCachedValue(this.cacheForResultsByQuery, id, value);
        }
        return value;
    }

    public static class CachedData {
        public String key;
        public Object value;
        public LocalDateTime date;

        public CachedData(String key, Object value) {
            this.key = key;
            this.value = value;
            this.date = LocalDateTime.now();
        }
    }
}

