/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.mathandtrigonometry;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorSum
extends CalculatorBase {
    public CalculatorSum(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams);
        if (Features.IGNORE_TEXT_IN_SUM_FUNCTION) {
            if (null == (objParams = Conversion.objectArrayToSpecificTypeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol)) || 0 == objParams.length) {
                return 0.0;
            }
            int paramCount = objParams.length;
            boolean hasLong = false;
            boolean hasDouble = false;
            boolean hasDateTime = false;
            for (int i = 0; i < paramCount; ++i) {
                if (Conversion.isLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                    hasLong = true;
                    continue;
                }
                if (Conversion.isDoubleOrLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                    hasDouble = true;
                    continue;
                }
                if (!Conversion.isDateTime(objParams[i])) continue;
                hasDateTime = true;
            }
            if (hasDateTime) {
                DateTime res = null;
                boolean bFirstTime = true;
                for (int i = 0; i < paramCount; ++i) {
                    if (!Conversion.isDateTime(objParams[i]) && !Conversion.isDoubleOrLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) continue;
                    if (bFirstTime) {
                        if (Conversion.isLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                            long lDateTome = Conversion.objectToLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                            res = new DateTime(lDateTome);
                        } else if (Conversion.isDoubleOrLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                            double dDateTime = Conversion.objectToDouble(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                            res = new DateTime(dDateTime);
                        } else {
                            res = Conversion.objectToDateTime(objParams[i]);
                        }
                        bFirstTime = false;
                        continue;
                    }
                    DateTime date2 = null;
                    if (Conversion.isLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                        long lDateTome = Conversion.objectToLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                        date2 = new DateTime(lDateTome);
                    } else if (Conversion.isDoubleOrLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) {
                        double dDateTime = Conversion.objectToDouble(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                        date2 = new DateTime(dDateTime);
                    } else {
                        date2 = Conversion.objectToDateTime(objParams[i]);
                    }
                    if (null == res || null == date2) continue;
                    res = DateTime.sum(res, date2);
                }
                return res;
            }
            if (hasLong && !hasDouble) {
                long res = 0L;
                for (int i = 0; i < paramCount; ++i) {
                    if (!Conversion.isLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) continue;
                    res += Conversion.objectToLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                }
                return res;
            }
            if (hasDouble) {
                double res = 0.0;
                for (int i = 0; i < paramCount; ++i) {
                    if (!Conversion.isDoubleOrLong(objParams[i], this.decimalSymbol, this.digitGroupingSymbol)) continue;
                    res += Conversion.objectToDouble(objParams[i], this.decimalSymbol, this.digitGroupingSymbol);
                }
                return res;
            }
            return 0.0;
        }
        double[] parameters = Conversion.objectArrayToDoubleArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        double res = 0.0;
        int paramCount = parameters.length;
        for (int i = 0; i < paramCount; ++i) {
            res += parameters[i];
        }
        return res;
    }
}

