/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import java.util.ArrayList;

public final class CalculatorJsonArrayToArray
extends CalculatorBase {
    public CalculatorJsonArrayToArray(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 1 || objParams.length > 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be 1 or 2.");
        }
        String resultIfNan = "NaN";
        if (objParams.length > 1 && null != objParams[1]) {
            resultIfNan = objParams[1].toString();
        }
        ArrayList<String> result = new ArrayList<String>();
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return new Object[0];
        }
        Object objJson = objParams[0];
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonParsed = jsonParser.parse(objJson.toString());
            if (null == jsonParsed) {
                return new Object[0];
            }
            if (jsonParsed instanceof JsonArray) {
                JsonArray jsonArray = (JsonArray)jsonParsed;
                int size = jsonArray.size();
                for (int i = 0; i < size; ++i) {
                    String value;
                    JsonElement jsonElement = jsonArray.get(i);
                    String string = value = null == jsonElement || jsonElement.isJsonNull() ? resultIfNan : jsonElement.toString();
                    if (null != value && value.length() > 0 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"') {
                        value = value.substring(1, value.length() - 1);
                    }
                    result.add(value);
                }
            } else {
                result.add(null == jsonParsed || jsonParsed.isJsonNull() ? resultIfNan : jsonParsed.toString());
            }
            return result.toArray();
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

