/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public final class CalculatorJsonArrayLength
extends CalculatorBase {
    public CalculatorJsonArrayLength(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length > 1) {
            throw new IllegalArgumentException("Wrong parameter count, which should be no more than 1.");
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return 0L;
        }
        Object objJson = null;
        if (null != objParams[0]) {
            objJson = objParams[0];
        }
        if (null == objJson) {
            return 0;
        }
        try {
            JsonArray jsonArray = null;
            if (!(objJson instanceof JsonArray)) {
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonParsed = jsonParser.parse(objJson.toString());
                if (null != jsonParsed && jsonParsed instanceof JsonArray) {
                    jsonArray = (JsonArray)jsonParsed;
                }
            } else {
                jsonArray = (JsonArray)objJson;
            }
            if (null == jsonArray) {
                throw new IllegalArgumentException("The parameter '" + objJson.toString() + "' is not a valid JsonArray object.");
            }
            long lResult = jsonArray.size();
            return lResult;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

