/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.financial.FinanceFunctions;

public final class CalculatorPpmt
extends CalculatorBase {
    public CalculatorPpmt(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected void checkToBeDouble(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    protected void checkToBeLong(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Long.");
        }
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 4 || objParams.length > 6) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 3 and no more than 5.");
        }
        this.checkToBeDouble(objParams[0], "Rate");
        double Rate = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        this.checkToBeLong(objParams[1], "Per");
        int Per = Long.valueOf(Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        this.checkToBeLong(objParams[2], "Nper");
        int Nper = Long.valueOf(Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        this.checkToBeDouble(objParams[3], "Pv");
        double Pv = Conversion.objectToDouble(objParams[3], this.decimalSymbol, this.digitGroupingSymbol);
        double Fv = 0.0;
        if (objParams.length > 4) {
            this.checkToBeDouble(objParams[4], "Fv");
            Fv = Conversion.objectToDouble(objParams[4], this.decimalSymbol, this.digitGroupingSymbol);
        }
        int Type2 = 0;
        if (objParams.length > 5) {
            this.checkToBeLong(objParams[5], "Type");
            Type2 = Long.valueOf(Conversion.objectToLong(objParams[5], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        return FinanceFunctions.ppmt(Rate, Per, Nper, Pv, Fv, Type2);
    }
}

