/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.JiraIssueFieldDescriptor;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayExtractPath;
import com.celestecs.expression.exceptions.NoDataException;
import com.celestecs.expression.exceptions.NotAuthorizedException;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.binary.StringUtils;
import org.apache.poi.ss.usermodel.DateUtil;
import org.jsoup.nodes.Element;

public class ServletTools {
    public static String sendRequest(String method, String url, String data, String authToken) throws IOException, NotAuthorizedException {
        DataOutputStream wr = null;
        int responseCode = 200;
        BufferedReader in = null;
        try {
            String inputLine;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod(method);
            if (Features.CLOUD_RUN_UNDER_USER_ACCOUNT && null != authToken && !authToken.isEmpty()) {
                con.setRequestProperty("Authorization", "Bearer " + authToken);
                con.setRequestProperty("Accept", "application/json");
            }
            if (null != data && data.length() > 0) {
                con.setDoOutput(true);
                byte[] bytes = data.getBytes("UTF-8");
                con.setRequestProperty("Content-Length", Integer.toString(bytes.length));
                con.setRequestProperty("Content-Type", "application/json");
                con.setRequestProperty("charset", "utf-8");
                if (Features.CLOUD_RUN_UNDER_USER_ACCOUNT) {
                    con.setRequestProperty("Accept-Charset", "utf-8");
                }
                con.setUseCaches(false);
                wr = new DataOutputStream(con.getOutputStream());
                wr.write(bytes);
            }
            responseCode = con.getResponseCode();
            if (Features.PROCESS_400_CODE_AS_NO_DATA_EXCEPTION && 400 == responseCode) {
                throw new NoDataException("No data returned with 400 error code");
            }
            in = Features.SPECIFY_UTF8_FOR_READER ? new BufferedReader(new InputStreamReader(con.getInputStream(), "UTF-8")) : new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            if (401 == responseCode) {
                throw new NotAuthorizedException("Current user is not authorized to access the specified resource. " + response.toString());
            }
            if (200 != responseCode) {
                throw new IOException("Error response code " + responseCode + " received with the following error text: " + response.toString());
            }
            String string = response.toString();
            return string;
        }
        catch (NotAuthorizedException e) {
            throw e;
        }
        catch (IOException e) {
            throw e;
        }
        finally {
            if (null != in) {
                in.close();
                in = null;
            }
        }
    }

    public static String mapToStr(Map<String, String> strMap) {
        String result = "";
        for (Map.Entry<String, String> entry : strMap.entrySet()) {
            result = result + entry.getKey() + "=" + entry.getValue() + ",";
        }
        return result;
    }

    protected static String makeParamString(Map<String, String[]> params) {
        if (params.size() < 1) {
            return "";
        }
        ArrayList<String> sortedKeys = new ArrayList<String>(params.keySet());
        String result = "";
        int count = sortedKeys.size();
        for (int i = 0; i < count; ++i) {
            String key = (String)sortedKeys.get(i);
            result = result + key + "=";
            String[] values = params.get(key);
            int valCount = values.length;
            for (int j = 0; j < valCount; ++j) {
                result = result + ServletTools.URLEncode(values[j]);
                if (j >= valCount - 1) continue;
                result = result + ",";
            }
            if (i >= count - 1) continue;
            result = result + "&";
        }
        return result;
    }

    public static String URLEncode(String str) {
        try {
            return URLEncoder.encode(str, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return str;
        }
    }

    public static String getStringValue(Map strMap, String key) {
        Object mapVal = strMap.get(key);
        if (null == mapVal) {
            return "";
        }
        return mapVal.toString();
    }

    public static String extractValueFromJsonString(String jsonString, String varName) throws ParseException, JsonParseException {
        JsonParser jsonParser = new JsonParser();
        JsonElement objElem = jsonParser.parse(jsonString);
        return ServletTools.extractValueFromJsonElement(objElem, varName);
    }

    public static String extractValueFromJsonElement(JsonElement objRoot, String varName) throws ParseException, JsonParseException {
        if (Features.REPLACE_MINIDEV_WITH_GSON) {
            if (objRoot.isJsonObject()) {
                JsonObject rootObj = objRoot.getAsJsonObject();
                JsonElement objResult = rootObj.get(varName);
                if (null == objResult) {
                    return "";
                }
                String result = "";
                if (Features.CLOUD_FIX_GETASSTRING) {
                    result = objResult.toString();
                    if (result.length() > 1 && result.charAt(0) == '\"' && result.charAt(result.length() - 1) == '\"') {
                        result = result.substring(1, result.length() - 1);
                    }
                } else {
                    result = objResult.getAsString();
                }
                return result;
            }
            if (objRoot.isJsonArray()) {
                JsonArray rootArray = objRoot.getAsJsonArray();
                int count = rootArray.size();
                for (int i = 0; i < count; ++i) {
                    JsonObject rootObj;
                    JsonElement objItem = rootArray.get(i);
                    if (null == objItem || !objItem.isJsonObject() || !objItem.isJsonObject() || !(rootObj = objItem.getAsJsonObject()).has(varName)) continue;
                    JsonElement objResult = rootObj.get(varName);
                    if (null != objResult && objResult.isJsonObject()) {
                        JsonObject jsResult = objResult.getAsJsonObject();
                        return jsResult.toString();
                    }
                    if (null == objResult || !objResult.isJsonPrimitive()) continue;
                    String jsResult = objResult.getAsString();
                    return jsResult.toString();
                }
            }
        }
        return "";
    }

    public static JsonElement extractValueFromJsonStringAsJsonElement(String jsonString, String varName) throws ParseException, JsonParseException {
        JsonParser jsonParser = new JsonParser();
        JsonElement objRoot = jsonParser.parse(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objResult = rootObj.get(varName);
            return objResult;
        }
        if (objRoot.isJsonArray()) {
            JsonArray rootArray = objRoot.getAsJsonArray();
            int count = rootArray.size();
            for (int i = 0; i < count; ++i) {
                JsonObject rootObj;
                JsonElement objItem = rootArray.get(i);
                if (null == objItem || !objItem.isJsonObject() || !objItem.isJsonObject() || !(rootObj = objItem.getAsJsonObject()).has(varName)) continue;
                JsonElement objResult = rootObj.get(varName);
                return objResult;
            }
        }
        return null;
    }

    public static Object[] extractJsonObjectArrayFromJsonString(String jsonString) throws ParseException, JsonParseException {
        return ServletTools.extractJsonObjectArrayFromJsonString(jsonString, "");
    }

    public static Object[] extractJsonObjectArrayFromJsonString(String jsonString, String rootPath) throws ParseException, JsonParseException {
        if (null == jsonString || 0 == jsonString.length()) {
            Object[] objResult = new Object[]{};
            return objResult;
        }
        JsonParser jsonParser = new JsonParser();
        JsonElement objRoot = jsonParser.parse(jsonString);
        if (null != rootPath && rootPath.length() > 0) {
            try {
                objRoot = CalculatorJsonArrayExtractPath.getJsonArray(objRoot, rootPath, '.', "");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (objRoot.isJsonObject()) {
            Object[] objResult = new Object[]{objRoot};
            return objResult;
        }
        if (objRoot.isJsonArray()) {
            JsonArray rootArray = objRoot.getAsJsonArray();
            int count = rootArray.size();
            Object[] objResult = new Object[count];
            for (int i = 0; i < count; ++i) {
                JsonElement objItem = rootArray.get(i);
                objResult[i] = null != objItem ? objItem : new JsonObject();
            }
            return objResult;
        }
        return null;
    }

    protected static boolean isOneOf(String field, String[] fields) {
        if (null == field || field.trim().isEmpty()) {
            return false;
        }
        for (String fieldName : fields) {
            if (0 != field.compareToIgnoreCase(fieldName)) continue;
            return true;
        }
        return false;
    }

    public static Long getLongFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        Long lResult = null;
        if (jsonElement.isJsonObject()) {
            lResult = jsonElement.getAsJsonObject().getAsLong();
        }
        if (jsonElement.isJsonPrimitive()) {
            lResult = jsonElement.getAsJsonPrimitive().getAsLong();
        }
        return lResult;
    }

    public static Double getDoubleFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        Double dResult = null;
        if (jsonElement.isJsonObject()) {
            dResult = jsonElement.getAsJsonObject().getAsDouble();
        }
        if (jsonElement.isJsonPrimitive()) {
            dResult = jsonElement.getAsJsonPrimitive().getAsDouble();
        }
        return dResult;
    }

    public static String getStringFromJsonElement(JsonElement jsonElement) {
        if (null == jsonElement) {
            return null;
        }
        String strResult = null;
        if (jsonElement.isJsonObject()) {
            strResult = jsonElement.getAsJsonObject().getAsString();
        }
        if (jsonElement.isJsonPrimitive()) {
            strResult = jsonElement.getAsJsonPrimitive().getAsString();
        }
        return strResult;
    }

    public static Object getFieldValueAsSimpleType(JsonObject jsonItem, JiraIssueFieldDescriptor fieldDescriptor) {
        String strDateTime;
        if (null == jsonItem || null == fieldDescriptor) {
            return null;
        }
        JsonElement objItem = null;
        if (fieldDescriptor.id.equalsIgnoreCase("issuekey")) {
            objItem = jsonItem.get("key");
            return ServletTools.getStringFromJsonElement(objItem);
        }
        objItem = jsonItem.get("fields");
        if (null == objItem || !objItem.isJsonObject()) {
            return null;
        }
        jsonItem = objItem.getAsJsonObject();
        if (null == (objItem = jsonItem.get(fieldDescriptor.id)) || objItem.isJsonNull()) {
            return null;
        }
        if (objItem.isJsonObject()) {
            jsonItem = objItem.getAsJsonObject();
        }
        if (objItem.isJsonPrimitive() && fieldDescriptor.type.equalsIgnoreCase("number")) {
            if (fieldDescriptor.custom.toLowerCase().contains("float")) {
                return ServletTools.getDoubleFromJsonElement(objItem);
            }
            return ServletTools.getLongFromJsonElement(objItem);
        }
        if (objItem.isJsonPrimitive() && fieldDescriptor.type.equalsIgnoreCase("string")) {
            return ServletTools.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("issuetype") || fieldDescriptor.type.equalsIgnoreCase("project") || fieldDescriptor.type.equalsIgnoreCase("resolution") || fieldDescriptor.type.equalsIgnoreCase("priority") || fieldDescriptor.type.equalsIgnoreCase("status")) {
            objItem = jsonItem.get("name");
            return ServletTools.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("user")) {
            objItem = jsonItem.get("key");
            return ServletTools.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("any")) {
            return ServletTools.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("issuelinks")) {
            JsonElement element2 = objItem.getAsJsonObject().get("outwardIssue");
            if (null != element2 && element2.isJsonObject()) {
                element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                return ServletTools.getStringFromJsonElement(element2);
            }
            element2 = objItem.getAsJsonObject().get("inwardIssue");
            if (null != element2 && element2.isJsonObject()) {
                element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                return ServletTools.getStringFromJsonElement(element2);
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("progress")) {
            objItem = jsonItem.get("total");
            Long total = ServletTools.getLongFromJsonElement(objItem);
            if (0L == total) {
                return 0L;
            }
            objItem = jsonItem.get("percent");
            return ServletTools.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("datetime")) {
            strDateTime = ServletTools.getStringFromJsonElement(objItem);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
            try {
                Date dateTime = df.parse(strDateTime);
                double excelDate = DateUtil.getExcelDate(dateTime);
                DateTime dtResult = new DateTime(excelDate);
                return dtResult;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("date")) {
            strDateTime = ServletTools.getStringFromJsonElement(objItem);
            SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
            try {
                Date dateTime = df.parse(strDateTime);
                double excelDate = DateUtil.getExcelDate(dateTime);
                DateTime dtResult = new DateTime(excelDate);
                return dtResult;
            }
            catch (ParseException e) {
                return null;
            }
        }
        if (fieldDescriptor.type.equalsIgnoreCase("watches")) {
            objItem = objItem.getAsJsonObject().get("watchCount");
            return ServletTools.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("votes")) {
            objItem = objItem.getAsJsonObject().get("votes");
            return ServletTools.getLongFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("option")) {
            objItem = jsonItem.get("value");
            return ServletTools.getStringFromJsonElement(objItem);
        }
        if (fieldDescriptor.type.equalsIgnoreCase("array") || objItem.isJsonArray()) {
            JsonArray jsonArray = objItem.getAsJsonArray();
            String strResult = "";
            int count = jsonArray.size();
            if (count < 1) {
                return null;
            }
            for (int i = 0; i < count; ++i) {
                JsonElement element2;
                JsonElement element = jsonArray.get(i);
                if (null == element || element.isJsonNull()) continue;
                if (fieldDescriptor.items.equalsIgnoreCase("version") || fieldDescriptor.items.equalsIgnoreCase("component")) {
                    element2 = element.getAsJsonObject().get("name");
                    strResult = strResult + ServletTools.getStringFromJsonElement(element2);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("string")) {
                    strResult = strResult + ServletTools.getStringFromJsonElement(element);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("issuelinks") && fieldDescriptor.system.equalsIgnoreCase("subtasks")) {
                    element2 = element.getAsJsonObject().get("key");
                    strResult = strResult + ServletTools.getStringFromJsonElement(element2);
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (fieldDescriptor.items.equalsIgnoreCase("issuelinks") && fieldDescriptor.system.equalsIgnoreCase("issuelinks")) {
                    JsonElement element3;
                    element2 = element.getAsJsonObject().get("outwardIssue");
                    if (null != element2 && element2.isJsonObject()) {
                        element3 = element.getAsJsonObject().get("type");
                        if (null != element3 && element3.isJsonObject()) {
                            element3 = element3.getAsJsonObject().getAsJsonObject().get("outward");
                            strResult = strResult + "(" + ServletTools.getStringFromJsonElement(element3) + ") ";
                        }
                        element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                        strResult = strResult + ServletTools.getStringFromJsonElement(element2);
                        strResult = strResult + (i < count - 1 ? ", " : "");
                        continue;
                    }
                    element3 = element.getAsJsonObject().get("type");
                    if (null != element3 && element3.isJsonObject()) {
                        element3 = element3.getAsJsonObject().getAsJsonObject().get("inward");
                        strResult = strResult + "(" + ServletTools.getStringFromJsonElement(element3) + ") ";
                    }
                    if (null != (element2 = element.getAsJsonObject().get("inwardIssue")) && element2.isJsonObject()) {
                        element2 = element2.getAsJsonObject().getAsJsonObject().get("key");
                        strResult = strResult + ServletTools.getStringFromJsonElement(element2);
                        strResult = strResult + (i < count - 1 ? ", " : "");
                        continue;
                    }
                }
                if (fieldDescriptor.items.equalsIgnoreCase("attachment")) {
                    strResult = strResult + element.toString();
                    strResult = strResult + (i < count - 1 ? ", " : "");
                    continue;
                }
                if (!fieldDescriptor.items.equalsIgnoreCase("option")) continue;
                JsonObject jsonObject2 = element.getAsJsonObject();
                JsonElement element22 = jsonObject2.get("value");
                strResult = strResult + ServletTools.getStringFromJsonElement(element22);
                strResult = strResult + (i < count - 1 ? ", " : "");
            }
            return strResult;
        }
        return null;
    }

    public static JiraIssueFieldDescriptor getJiraIssueFieldDescriptorFromJsonObject(JsonObject jsonDescriptor) throws Exception {
        JsonObject jsonObject;
        String name = "";
        String id = "";
        boolean isCustom = false;
        String type = "";
        String custom = "";
        String items = "";
        String system = "";
        JsonElement jsonElem = jsonDescriptor.get("name");
        if (null != jsonElem) {
            name = jsonElem.getAsString();
        }
        if (null != (jsonElem = jsonDescriptor.get("id"))) {
            id = jsonElem.getAsString();
        }
        if (null != (jsonElem = jsonDescriptor.get("custom"))) {
            String strCustom = jsonElem.getAsString();
            boolean bl = isCustom = null != strCustom && strCustom.equalsIgnoreCase("true");
        }
        if (null != (jsonElem = jsonDescriptor.get("schema")) && jsonElem.isJsonObject() && null != (jsonObject = jsonElem.getAsJsonObject()) && jsonObject.isJsonObject()) {
            jsonElem = jsonObject.get("type");
            if (null != jsonElem) {
                type = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("custom"))) {
                custom = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("items"))) {
                items = jsonElem.getAsString();
            }
            if (null != (jsonElem = jsonObject.get("system"))) {
                system = jsonElem.getAsString();
            }
        }
        if (null == name || name.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'name' parameter shoud not be emoty.");
        }
        if (null == id || id.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'id' parameter shoud not be emoty.");
        }
        if (id.equalsIgnoreCase("issuekey")) {
            type = "string";
        }
        if (null == type || type.isEmpty()) {
            throw new Exception("Error in issue field descriptor: 'type' parameter shoud not be emoty.");
        }
        JiraIssueFieldDescriptor jiraIssueFieldDescriptor = new JiraIssueFieldDescriptor(name, id, isCustom, type, custom, items, system);
        return jiraIssueFieldDescriptor;
    }

    public static Object[] extractValuesFromJsonString(String jsonString, JiraIssueFieldDescriptor fieldDescriptor, Object valueIfNull) throws ParseException, JsonParseException {
        ArrayList<Object> result = new ArrayList<Object>();
        JsonParser jsonParser = new JsonParser();
        JsonElement objRoot = jsonParser.parse(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objIssues = rootObj.get("issues");
            if (null == objIssues || !objIssues.isJsonArray()) {
                return new Object[0];
            }
            JsonArray issueArray = objIssues.getAsJsonArray();
            if (null == issueArray || issueArray.size() < 1) {
                return new Object[0];
            }
            int count = issueArray.size();
            for (int i = 0; i < count; ++i) {
                JsonElement objItem = issueArray.get(i);
                if (null == objItem || !objItem.isJsonObject()) {
                    result.add(valueIfNull);
                    continue;
                }
                JsonObject jsonItem = objItem.getAsJsonObject();
                Object fieldValue = ServletTools.getFieldValueAsSimpleType(jsonItem, fieldDescriptor);
                result.add(null == fieldValue ? valueIfNull : fieldValue);
            }
            return result.toArray();
        }
        return new Object[0];
    }

    public static Map<String, String> extractMapFromJsonString(String jsonString, String keyName, String valueName) throws ParseException, JsonParseException {
        JsonParser jsonParser = new JsonParser();
        JsonElement objRoot = jsonParser.parse(jsonString);
        HashMap<String, String> result = new HashMap<String, String>();
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objKey = rootObj.get(keyName);
            JsonElement objValue = rootObj.get(valueName);
            if (null == objKey || objKey.toString().isEmpty() || null == objValue || objValue.toString().isEmpty()) {
                return result;
            }
            String key = objKey.toString().toLowerCase();
            String value = objValue.toString().toLowerCase();
            result.put(key, value);
            return result;
        }
        if (objRoot.isJsonArray()) {
            JsonArray jsonArray = objRoot.getAsJsonArray();
            if (null == jsonArray || jsonArray.size() < 1) {
                return result;
            }
            for (JsonElement jsonElem : jsonArray) {
                if (null == jsonElem || !jsonElem.isJsonObject()) continue;
                JsonObject jsonObj = jsonElem.getAsJsonObject();
                JsonElement objKey = jsonObj.get(keyName);
                JsonElement objValue = jsonObj.get(valueName);
                if (null == objKey || objKey.getAsString().isEmpty() || null == objValue || objValue.getAsString().isEmpty()) {
                    return result;
                }
                String key = objKey.getAsString().toLowerCase();
                String value = objValue.getAsString().toLowerCase();
                result.put(key, value);
            }
            return result;
        }
        return result;
    }

    public static JsonObject extractJsonObjectFromJsonString(String jsonString, String key, String value) throws ParseException, JsonParseException, Exception {
        JsonParser jsonParser = new JsonParser();
        JsonElement objRoot = jsonParser.parse(jsonString);
        if (objRoot.isJsonObject()) {
            JsonObject rootObj = objRoot.getAsJsonObject();
            JsonElement objKey = rootObj.get(key);
            if (null == objKey || objKey.toString().isEmpty()) {
                throw new Exception("Unable to find the descriptor for the field with " + key + " '" + value + "'.");
            }
            String stringValue = objKey.getAsString();
            if (null == stringValue || !stringValue.equalsIgnoreCase(value)) {
                throw new Exception("Cannot to find the descriptor for the field with " + key + " '" + value + "'.");
            }
            return rootObj;
        }
        if (objRoot.isJsonArray()) {
            JsonArray jsonArray = objRoot.getAsJsonArray();
            if (null == jsonArray || jsonArray.size() < 1) {
                throw new Exception("Unable to find the descriptor for the field " + key + " '" + value + "': the descriptions array is empty.");
            }
            for (JsonElement jsonElem : jsonArray) {
                String stringValue;
                JsonObject jsonObj;
                JsonElement objKey;
                if (null == jsonElem || !jsonElem.isJsonObject() || null == (objKey = (jsonObj = jsonElem.getAsJsonObject()).get(key)) || objKey.getAsString().isEmpty() || null == (stringValue = objKey.getAsString()) || !stringValue.equalsIgnoreCase(value)) continue;
                return jsonObj;
            }
            throw new Exception("Unable to find the descriptor for the field with " + key + " '" + value + "': the descriptor with such parameter was not found.");
        }
        throw new Exception("Unsupported JSON object type: '" + objRoot.getClass() + "'");
    }

    protected static void setCommonResponseParams(HttpServletResponse resp) {
        if (null == resp) {
            return;
        }
        resp.setCharacterEncoding("UTF-8");
        resp.setHeader("Strict-Transport-Security", "max-age=31536000; includeSubDomains");
        resp.setHeader("Cache-Control", "no-cache, no-store");
    }

    public static void setError(HttpServletResponse resp, int httpErrorCode, String errMsg) {
        try {
            ServletTools.setCommonResponseParams(resp);
            resp.setStatus(200);
            resp.getWriter().print("Error: " + errMsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setError(HttpServletResponse resp, String errMsg) {
        try {
            ServletTools.setCommonResponseParams(resp);
            resp.setStatus(200);
            resp.getWriter().print("Error in macro: " + errMsg);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setOk(HttpServletResponse resp, String text) {
        try {
            ServletTools.setCommonResponseParams(resp);
            resp.setStatus(200);
            resp.getWriter().print(text);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void prepareResponseForUnshowableMacro(HttpServletRequest req, HttpServletResponse resp, String previewModeText, String displayModeText) {
        Map<String, String> parameters = null;
        try {
            parameters = MacroHelper.getParamMap(req.getParameterMap());
            boolean previewMode = false;
            if (null != parameters && parameters.containsKey("output_type") && null != parameters.get("output_type") && 0 == parameters.get("output_type").toString().compareToIgnoreCase("preview")) {
                previewMode = true;
            }
            if (previewMode) {
                ServletTools.setOk(resp, previewModeText);
                return;
            }
            ServletTools.setOk(resp, displayModeText);
            return;
        }
        catch (Exception exception) {
            String errMsg = exception.getMessage();
            ServletTools.setError(resp, errMsg);
            return;
        }
    }

    public static boolean isInPreviewMode(HttpServletRequest req) {
        Map<String, String> parameters = null;
        try {
            parameters = MacroHelper.getParamMap(req.getParameterMap());
            boolean previewMode = false;
            if (null != parameters && parameters.containsKey("output_type") && null != parameters.get("output_type") && 0 == parameters.get("output_type").toString().compareToIgnoreCase("preview")) {
                previewMode = true;
            }
            return previewMode;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public static String createUriWithoutJwt(String method, String baseUrl, String contextPath, String apiPath, Map<String, String[]> params, String sub, String context) throws UnsupportedEncodingException, NoSuchAlgorithmException {
        String strParams = ServletTools.makeParamString(params);
        String apiUrl = baseUrl + contextPath + apiPath + (strParams.length() == 0 ? "" : "?" + strParams);
        return apiUrl;
    }

    public static String decode(String s) {
        return StringUtils.newStringUtf8((byte[])Base64.decodeBase64((String)s));
    }

    public static String encode(String s) {
        return Base64.encodeBase64String((byte[])StringUtils.getBytesUtf8((String)s));
    }

    public static String readDataFromRequest(HttpServletRequest request) throws IOException {
        ServletInputStream is = null;
        BufferedReader in = null;
        try {
            String inputLine;
            is = request.getInputStream();
            in = Features.SPECIFY_UTF8_FOR_READER ? new BufferedReader(new InputStreamReader((InputStream)is, "utf-8")) : new BufferedReader(new InputStreamReader((InputStream)is));
            StringBuffer response = new StringBuffer();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            String string = response.toString();
            return string;
        }
        catch (IOException ex) {
            throw ex;
        }
        finally {
            if (null != is) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                is = null;
            }
            if (null != in) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                in = null;
            }
        }
    }

    public static String decodeText(String value) {
        value = null == value ? "" : value;
        int len = value.length();
        int index = 0;
        int found = -1;
        String resValue = "";
        while (index < len) {
            found = value.indexOf("&apos;", index);
            if (index == found) {
                resValue = resValue + "'";
                index += "&apos;".length() + 1;
                continue;
            }
            found = value.indexOf("&amp;", index);
            if (index == found) {
                resValue = resValue + "&";
                index += "&amp;".length() + 1;
                continue;
            }
            found = value.indexOf("&quot;", index);
            if (index == found) {
                resValue = resValue + "\"";
                index += "&quot;".length() + 1;
                continue;
            }
            found = value.indexOf("&lt;", index);
            if (index == found) {
                resValue = resValue + "<";
                index += "&lt;".length() + 1;
                continue;
            }
            found = value.indexOf("&gt;", index);
            if (index == found) {
                resValue = resValue + ">";
                index += "&gt;".length() + 1;
                continue;
            }
            resValue = resValue + value.charAt(index);
            ++index;
        }
        if (0 == resValue.indexOf("\n")) {
            resValue = resValue.substring(1);
        }
        if (0 == resValue.indexOf("\"\n")) {
            resValue = "\"" + resValue.substring(2);
        }
        if (resValue.length() - 1 == resValue.lastIndexOf("\n")) {
            resValue = resValue.substring(0, resValue.length());
        }
        return resValue;
    }

    public static void checkForParam(Element elem, String paramName, HashMap<String, String> macroParams) {
        if (null == elem || !elem.hasAttr("ac:name")) {
            return;
        }
        String name = elem.attr("ac:name");
        if (name.equalsIgnoreCase(paramName) || name.equalsIgnoreCase("\\\"" + paramName + "\\\"")) {
            if (Features.READ_PARAMS_WITH_HTML_CORRECTLY) {
                String value = null == elem ? "" : elem.html();
                if (null != (value = ServletTools.decodeText(value)) && !value.isEmpty()) {
                    macroParams.put(paramName, value);
                }
            } else {
                String value = elem.text();
                if (null != value && !value.isEmpty()) {
                    macroParams.put(paramName, value);
                }
            }
        }
    }
}

