/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import java.util.Map;

public class NumericalExpressionMacroParams {
    private static ExpressionPlacementKind DEF_PLACEMENT = ExpressionPlacementKind.SINGLE_EXPRESSION;
    private static OuterValuesSource DEF_SOURCE = OuterValuesSource.MACRO_BODY;
    private static char DEF_DECIMAL_SYMBOL = (char)46;
    private static String DEF_DIGIT_GROUPING_SYMBOL = "";
    private static int DEF_DECIMAL_PLACES = 340;
    private static boolean DEF_SHOW_RESULT_ONLY = true;
    private static boolean DEF_LOAD_MACRO_DYNAMICALLY = false;
    private static boolean DEF_BACKWARD_COMPATIBILITY_MODE = false;
    public ExpressionPlacementKind placement;
    public char decimalSymbol;
    public String digitGroupingSymbol = "";
    public OuterValuesSource outerValuesSource;
    public int decimalPlaces;
    public boolean showResultOnly;
    public boolean loadMacroDynamically;
    public String otherConfluencePage;
    public boolean backwardCompatibilityMode = false;

    public NumericalExpressionMacroParams(Map<String, String> parameters) {
        String s = parameters.get("expression-placement");
        this.placement = s != null && s.trim().equals("Single expression") ? ExpressionPlacementKind.SINGLE_EXPRESSION : (s != null && s.trim().equals("Text and expressions in curly braces") ? ExpressionPlacementKind.IN_CURLY_BRACES : (s != null && s.trim().equals("Text and expressions in square braces") ? ExpressionPlacementKind.IN_SQUARE_BRACES : DEF_PLACEMENT));
        s = parameters.get("outer-values-source");
        if (s != null && s.trim().equals("Macro body")) {
            this.outerValuesSource = OuterValuesSource.MACRO_BODY;
        } else if (s != null && (s.trim().equals("Page content") || s.trim().equalsIgnoreCase("Current page"))) {
            this.outerValuesSource = OuterValuesSource.CURRENT_CONFLUENCE_PAGE;
        } else if (s != null && s.trim().equalsIgnoreCase("Other page")) {
            this.outerValuesSource = OuterValuesSource.OTHER_CONFLUENCE_PAGE;
            s = parameters.get("other-confluence-page");
            if (null != s && s.length() > 0) {
                this.otherConfluencePage = s;
                this.outerValuesSource = OuterValuesSource.OTHER_CONFLUENCE_PAGE;
            } else {
                this.outerValuesSource = OuterValuesSource.CURRENT_CONFLUENCE_PAGE;
            }
        } else {
            this.outerValuesSource = DEF_SOURCE;
        }
        s = parameters.get("decimal-symbol");
        this.decimalSymbol = s != null && (s.trim().equals(".") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(".(dot)")) ? (char)46 : (s != null && (s.trim().equals(",") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(",(comma)")) ? (char)44 : DEF_DECIMAL_SYMBOL);
        s = parameters.get("digit-grouping-symbol");
        this.digitGroupingSymbol = null != s && (s.equals(" ") || Features.BETTER_READ_PARAM_VALUES && s.equalsIgnoreCase(" (space)")) ? " " : (null != s && (s.equals(".") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(".(dot)")) ? "." : (null != s && (s.equals(",") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase(",(comma)")) ? "," : (null != s && (s.equals("'") || Features.BETTER_READ_PARAM_VALUES && s.trim().equalsIgnoreCase("'(apostrophe)")) ? "'" : DEF_DIGIT_GROUPING_SYMBOL)));
        s = parameters.get("decimal-places");
        try {
            this.decimalPlaces = null == s ? DEF_DECIMAL_PLACES : Integer.parseInt(s.trim());
        }
        catch (Exception e) {
            this.decimalPlaces = DEF_DECIMAL_PLACES;
        }
        s = parameters.get("show-result-only");
        this.showResultOnly = s != null && s.trim().equalsIgnoreCase("true") ? true : (s != null && s.trim().equalsIgnoreCase("false") ? false : DEF_SHOW_RESULT_ONLY);
        s = parameters.get("load-macro-dynamically");
        this.loadMacroDynamically = s != null && s.trim().equalsIgnoreCase("true") ? true : (s != null && s.trim().equalsIgnoreCase("false") ? false : DEF_LOAD_MACRO_DYNAMICALLY);
        s = parameters.get("backward-compatibility-mode");
        this.backwardCompatibilityMode = s != null && s.trim().equalsIgnoreCase("true") ? true : (s != null && s.trim().equalsIgnoreCase("false") ? false : DEF_BACKWARD_COMPATIBILITY_MODE);
    }

    public char getOpenBrace() {
        switch (this.placement) {
            case IN_CURLY_BRACES: {
                return '{';
            }
            case IN_SQUARE_BRACES: {
                return '[';
            }
        }
        return ' ';
    }

    public char getCloseBrace() {
        switch (this.placement) {
            case IN_CURLY_BRACES: {
                return '}';
            }
            case IN_SQUARE_BRACES: {
                return ']';
            }
        }
        return ' ';
    }

    public static enum ExpressionPlacementKind {
        SINGLE_EXPRESSION,
        IN_CURLY_BRACES,
        IN_SQUARE_BRACES;

    }

    public static enum OuterValuesSource {
        MACRO_BODY,
        CURRENT_CONFLUENCE_PAGE,
        OTHER_CONFLUENCE_PAGE;

    }
}

