/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.operators;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public class CalculatorAddition
extends CalculatorBase {
    public CalculatorAddition(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        Object[] parameters = Conversion.objectArrayToSpecificTypeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        super.CheckParams(parameters, 2);
        Object param1 = parameters[0];
        Object param2 = parameters[1];
        if (param1 instanceof Long && param2 instanceof Long) {
            return (Long)param1 + (Long)param2;
        }
        if (param1 instanceof Long && param2 instanceof Double || param1 instanceof Double && param2 instanceof Long || param1 instanceof Double && param2 instanceof Double) {
            return Conversion.objectToDouble(param1, this.decimalSymbol, this.digitGroupingSymbol) + Conversion.objectToDouble(param2, this.decimalSymbol, this.digitGroupingSymbol);
        }
        if (Features.DATETIME_SUPPORT_IN_PLUS_AND_MINUS_OPERATORS && (param2 instanceof Long || param2 instanceof Double) && Conversion.isDateTime(param1)) {
            DateTime result = DateTime.sum((DateTime)param1, param2 instanceof Long ? (double)((Long)param2).longValue() : (Double)param2);
            return result;
        }
        return "NaN";
    }
}

