/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.engineering;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.ErrorEval;

public final class CalculatorDec2Bin
extends CalculatorBase {
    private static final long MIN_VALUE = -512L;
    private static final long MAX_VALUE = 511L;
    private static final int DEFAULT_PLACES_VALUE = 10;

    public CalculatorDec2Bin(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected static String getZeroes(int count) {
        String result = "";
        for (int i = 0; i < count; ++i) {
            result = result + "0";
        }
        return result;
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 1 || objParams.length > 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 1 and no more than 2.");
        }
        Conversion.checkToBeDouble(objParams[0], "Number", this.decimalSymbol, this.digitGroupingSymbol);
        Double srcNumber = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        int placesNumber = 0;
        if (objParams.length > 1) {
            Conversion.checkToBeLong(objParams[1], "Places", this.decimalSymbol, this.digitGroupingSymbol);
            placesNumber = Long.valueOf(Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        if (srcNumber.longValue() < -512L || srcNumber.longValue() > 511L) {
            return ErrorEval.NUM_ERROR;
        }
        if (srcNumber < 0.0) {
            placesNumber = 10;
        }
        int intValue = srcNumber.intValue();
        String binary = Integer.toBinaryString(intValue);
        if (placesNumber != 0) {
            if (binary.length() > 10) {
                binary = binary.substring(binary.length() - 10, binary.length());
            }
            if (placesNumber > 0 && binary.length() > placesNumber) {
                return ErrorEval.NUM_ERROR;
            }
            if (placesNumber > binary.length()) {
                binary = CalculatorDec2Bin.getZeroes(placesNumber - binary.length()) + binary;
            }
        }
        return binary;
    }
}

