/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorWeekDay
extends CalculatorBase {
    public CalculatorWeekDay(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        long result;
        super.CheckForNotHavingRanges(objParams);
        if (objParams == null) {
            throw new IllegalArgumentException("parameters");
        }
        if (objParams.length != 1 && objParams.length != 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be be equal to 1 or 2.");
        }
        if (objParams.length == 2 && !Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong parameter type. It should be integer value.");
        }
        if (objParams.length == 2 && (Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol) < 0L || Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol) > 17L)) {
            throw new IllegalArgumentException("Wrong parameter value.");
        }
        DateTime date = Conversion.objectToDateTime(objParams[0]);
        if (null == date) {
            return -1L;
        }
        long weekday = date.get(7);
        long returnOption = 1L;
        if (objParams.length == 2 && (returnOption = Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)) == 2L) {
            returnOption = 11L;
        }
        if (returnOption == 1L) {
            result = weekday;
        } else if (returnOption == 3L) {
            result = (weekday + 6L - 1L) % 7L;
        } else if (returnOption >= 11L && returnOption <= 17L) {
            result = (weekday + 6L - (returnOption - 10L)) % 7L + 1L;
        } else {
            return -1;
        }
        return result;
    }
}

