/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public class CalculatorException
extends Exception {
    private static final long serialVersionUID = 1L;
    private String calculatorName = "Unknown";
    private String msg = "Unknown";
    private Object[] params = null;
    protected char decimalSymbol = (char)46;
    protected String digitGroupingSymbol = "";

    public CalculatorException(String message, CalculatorBase calculator, Object[] params) {
        this.initialize(message, calculator, params);
    }

    public CalculatorException(String message, CalculatorBase calculator, Object[] params, char decimalSymbol, String digitGroupingSymbol) {
        this.initialize(message, calculator, params);
        this.decimalSymbol = decimalSymbol;
        this.digitGroupingSymbol = digitGroupingSymbol;
    }

    protected void initialize(String message, CalculatorBase calculator, Object[] params) {
        this.msg = message;
        this.params = params;
        String calculatorClassName = "Unknown";
        if (null != calculator && null != calculator.getClass()) {
            calculatorClassName = calculator.getClass().getSimpleName();
        }
        if (null != calculatorClassName && calculatorClassName.lastIndexOf(".") > -1) {
            int index = calculatorClassName.lastIndexOf(".");
            calculatorClassName = calculatorClassName.substring(index);
            this.calculatorName = calculatorClassName.substring("CALCULATOR".length());
        } else if (null != calculatorClassName) {
            this.calculatorName = calculatorClassName.substring("CALCULATOR".length());
        }
    }

    public String getCalculatorName() {
        return this.calculatorName;
    }

    @Override
    public String getMessage() {
        return this.toString();
    }

    @Override
    public String toString() {
        return "An error occurred in " + this.calculatorName.toUpperCase() + "(" + this.paramsToStr(this.params) + ") function. " + this.msg;
    }

    protected String paramsToStr(Object[] params) {
        if (null == params || params.length < 1) {
            return "";
        }
        params = Conversion.objectArrayWithRangesToFlatObjectArray(params);
        String result = "";
        int count = params.length;
        Object param = null;
        for (int i = 0; i < count; ++i) {
            param = params[i];
            result = Conversion.isLong(param, this.decimalSymbol, this.digitGroupingSymbol) ? result + Conversion.objectToLong(param, this.decimalSymbol, this.digitGroupingSymbol) : (Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol) ? result + Conversion.objectToDouble(param, this.decimalSymbol, this.digitGroupingSymbol) : (Conversion.isBoolean(param) ? result + Conversion.objectToBoolean(param, this.decimalSymbol, this.digitGroupingSymbol) : (Conversion.isDateTime(param) ? result + Conversion.objectToDateTime(param).toString() : result + "'" + param.toString() + "'")));
            if (i >= count - 1) continue;
            result = result + ", ";
        }
        return result;
    }
}

