/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators;

import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.IOperationCalculator;

public abstract class CalculatorBase
implements IOperationCalculator {
    protected char decimalSymbol = (char)46;
    protected String digitGroupingSymbol = "";

    public CalculatorBase(char decimalSymbol, String digitGroupingSymbol) {
        this.decimalSymbol = decimalSymbol;
        this.digitGroupingSymbol = digitGroupingSymbol;
    }

    @Override
    public char getDecimalSymbol() {
        return this.decimalSymbol;
    }

    @Override
    public String getDigitGroupingSymbol() {
        return this.digitGroupingSymbol;
    }

    public void CheckParams(double[] parameters, int paramCount) throws IllegalArgumentException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters");
        }
        if (parameters.length != paramCount) {
            throw new IllegalArgumentException("Wrong parameter count, which should be be equal to " + paramCount + ".");
        }
    }

    public void CheckParams(Object[] parameters, int paramCount) throws IllegalArgumentException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters");
        }
        if (parameters.length != paramCount) {
            throw new IllegalArgumentException("Wrong parameter count, which should be equal to " + paramCount + ".");
        }
    }

    public void CheckForNotHavingRanges(Object[] parameters) throws IllegalArgumentException {
        if (Conversion.hasRanges(parameters)) {
            throw new IllegalArgumentException("Range parameter type is not supported by the function.");
        }
    }

    public void CheckForNotHavingRanges(Object[] parameters, CalculatorBase calculator) throws CalculatorException {
        if (Conversion.hasRanges(parameters)) {
            throw new CalculatorException("Range parameter type is not supported by the function.", calculator, parameters);
        }
    }

    public void CheckParamsForMinimalNumberOfParams(Object[] parameters, int minParamCount) throws IllegalArgumentException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters");
        }
        if (parameters.length < minParamCount) {
            throw new IllegalArgumentException("Too few parameters count, which should be be not less than " + minParamCount + ".");
        }
    }

    public void CheckParamsForMaximumNumberOfParams(Object[] parameters, int maxParamCount) throws IllegalArgumentException {
        if (parameters == null) {
            throw new IllegalArgumentException("parameters");
        }
        if (parameters.length > maxParamCount) {
            throw new IllegalArgumentException("Too much parameters count, which should be be not more than " + maxParamCount + ".");
        }
    }
}

