/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.MacroHelper;
import java.util.HashMap;
import java.util.Map;

public class MacroResultCache {
    protected static int MAX_STACK = 10;
    public static MacroResultCache macroResultCache = new MacroResultCache();
    private Map<String, String> values = new HashMap<String, String>();
    private Map<String, Integer> counts = new HashMap<String, Integer>();

    public void incStack(String key) {
        if (!this.counts.containsKey(key)) {
            this.counts.put(key, 1);
        } else {
            Integer oldCount = this.counts.remove(key);
            Integer newCount = oldCount + 1;
            this.counts.put(key, newCount);
        }
    }

    public boolean isStackOverflow(String key) {
        if (!this.counts.containsKey(key)) {
            return false;
        }
        Integer count = this.counts.get(key);
        return null != count && MAX_STACK < count;
    }

    public void put(String key, String value) {
        if (!this.values.containsKey(key)) {
            MacroHelper.Log("put(" + key + "");
            this.values.put(key, value);
        }
    }

    public String get(String key) {
        if (!this.values.containsKey(key)) {
            MacroHelper.Log("no ney for (" + key + "");
            return null;
        }
        MacroHelper.Log("get(" + key + "");
        return this.values.get(key);
    }

    public void remove(String key) {
        if (this.values.containsKey(key)) {
            MacroHelper.Log("remove(" + key + "");
            this.values.remove(key);
        }
    }

    public boolean contains(String key) {
        return this.values.containsKey(key);
    }

    public void clear() {
        MacroHelper.Log("clear()");
        this.values.clear();
    }
}

