/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import java.util.Calendar;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public class DateTime {
    protected double value = 0.0;

    public static Date getClearDate(Date jd) {
        if (null == jd) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(jd);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    public static Date getClearDateTimeTillHours(Date jd) {
        if (null == jd) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(jd);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    public static Date getClearDateTimeTillMinutes(Date jd) {
        if (null == jd) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(jd);
        cal.set(13, 0);
        cal.set(14, 0);
        Date d = cal.getTime();
        return d;
    }

    public static DateTime sum(DateTime d1, double dSum) {
        double dRes = d1.getValue() + dSum;
        DateTime res = new DateTime(dRes);
        return res;
    }

    public static DateTime sum(DateTime d1, long lSum) {
        double dRes = d1.getValue() + Double.valueOf(lSum);
        DateTime res = new DateTime(dRes);
        return res;
    }

    public static DateTime minus(DateTime d1, double dSum) {
        double dRes = d1.getValue() - dSum;
        DateTime res = new DateTime(dRes);
        return res;
    }

    public static DateTime minus(DateTime d1, long lSum) {
        double dRes = d1.getValue() - Double.valueOf(lSum);
        DateTime res = new DateTime(dRes);
        return res;
    }

    public static DateTime sum(DateTime d1, DateTime d2) {
        double dRes = d1.getValue() + d2.getValue();
        DateTime res = new DateTime(dRes);
        return res;
    }

    public DateTime(double value) {
        this.value = value;
    }

    public double getValue() {
        return this.value;
    }

    public String toString() {
        return Double.valueOf(this.value).toString();
    }

    public long get(int field) {
        if ((int)this.value == 0) {
            switch (field) {
                case 1: {
                    return 1900L;
                }
                case 2: {
                    return 1L;
                }
                case 5: {
                    return 0L;
                }
            }
        }
        Calendar c = DateUtil.getJavaCalendarUTC(this.value + 5.78125E-6, false);
        int result = c.get(field);
        if (field == 2) {
            ++result;
        }
        return result;
    }
}

