/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.math;

import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.LicenseType;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.celestecs.confluence.math.CelestecsMathRestService;
import com.celestecs.confluence.math.MathJqlQueryExecutor;
import com.celestecs.confluence.server.ConfluenceServerMacroPageContentProvider;
import com.celestecs.confluence.server.ConfluenceServerMacroTextResolver;
import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MacroResultCache;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.NumericalExpressionMacroParams;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.QueryExecutor;
import com.celestecs.expression.ToolsHelper;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Map;

public class NumericalExpressionMacro
implements Macro {
    private final XhtmlContent xhtmlUtils;
    private final I18nResolver i18n;
    protected final PluginLicenseManager licenseManager;
    protected final UserAccessor userAccessor;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected final QueryExecutor jqlQueryExecutor;
    ConfluenceServerMacroTextResolver mathTextResolver;
    private static String DEF_RETURN_ON_ERROR = "";

    public NumericalExpressionMacro(XhtmlContent xhtmlUtils, I18nResolver i18nResolver, PluginLicenseManager licenseMgr, UserAccessor userAccessor, PageManager pageManager, PermissionManager permissionManager, ApplicationLinkService _applicationLinkService) {
        this.xhtmlUtils = xhtmlUtils;
        this.i18n = i18nResolver;
        this.licenseManager = licenseMgr;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
        this.mathTextResolver = new ConfluenceServerMacroTextResolver(this.i18n);
        this.jqlQueryExecutor = new MathJqlQueryExecutor(_applicationLinkService);
        ToolsHelper.setJqlQueryExecutor(this.jqlQueryExecutor);
    }

    protected void addParam(StringBuilder builder, String paramName, String paramValue, boolean isPastParam) {
        String encodedParamValue = URLEncoder.encode(paramValue);
        builder.append("\"" + paramName + "\" : \"" + encodedParamValue + "\"");
        if (!isPastParam) {
            builder.append(", ");
        }
    }

    public String getAsynchMacroInitialContent(Map<String, String> parameters, boolean previewMode, String bodyContent, String currentPageId, String macroId, int currentTableIndexOneBased, boolean addTrialText) throws ExpressionCalculationException {
        StringBuilder builder = new StringBuilder();
        long rand = Math.round(Math.random() * 1.0E8);
        String divId = "math-macro-asynch-" + rand;
        builder.append("<span id=\"" + divId + "\"");
        builder.append("<span class=\"aui-icon aui-icon-wait\">Fetching...</span>");
        builder.append("<script>");
        builder.append("AJS.toInit( function(evt) {");
        builder.append("var url = AJS.params.contextPath + '/plugins/servlet/celestecsmath'; ");
        builder.append("AJS.safe.get(url, { ");
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.addParam(builder, entry.getKey(), entry.getValue(), false);
        }
        this.addParam(builder, "tr", addTrialText ? "true" : "false", false);
        this.addParam(builder, "preview", previewMode ? "true" : "false", false);
        this.addParam(builder, "pageId", currentPageId, false);
        this.addParam(builder, "macroId", macroId, false);
        this.addParam(builder, "curTblIdx", Integer.valueOf(currentTableIndexOneBased).toString(), false);
        this.addParam(builder, "body", bodyContent, true);
        builder.append(" }) ");
        builder.append(".done(function(response, status, header) { ");
        builder.append("AJS.$(\"#" + divId + "\").html(response);");
        builder.append("\t\t\t}) ");
        builder.append("\t\t\t.fail(function(header, status, error) { ");
        builder.append("AJS.$(\"#" + divId + "\").html(\"" + String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.error.ErrorInServlet"), new Object[0]) + "\" + response );");
        builder.append("\t\t\t}); ");
        builder.append("}); ");
        builder.append("</script>");
        builder.append("</span>");
        return builder.toString();
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        try {
            MacroDefinition macroDefinition;
            String macroId;
            ContentEntityObject contentEntityObject;
            if (Features.CHECK_SERVER_LICENSE) {
                this.validateLicense();
            }
            String pageUrl = "";
            if (Features.BREAK_RENDER_LOOP_2 && null != conversionContext && null != (contentEntityObject = conversionContext.getEntity()) && null == (pageUrl = contentEntityObject.getUrlPath())) {
                pageUrl = "";
            }
            boolean previewMode = false;
            if (Features.REMOVE_EXTRA_TABLE_IN_PREVIEW_MODE && "preview".equals(conversionContext.getOutputType())) {
                previewMode = true;
            }
            NumericalExpressionMacroParams param = new NumericalExpressionMacroParams(parameters);
            ConfluenceServerMacroPageContentProvider pageContentProvider = new ConfluenceServerMacroPageContentProvider(this.pageManager, this.permissionManager, this.xhtmlUtils);
            pageContentProvider.setChangableParams(bodyContent, conversionContext, param.otherConfluencePage, param.decimalSymbol, param.digitGroupingSymbol, param.backwardCompatibilityMode, this.mathTextResolver, pageUrl);
            int currentTableIndexOneBased = -1;
            if (Features.CURRENT_TABLE_SUPPORT && bodyContent.toLowerCase().contains("currenttable") && null != (macroId = ConfluenceServerMacroPageContentProvider.readMacroId(macroDefinition = (MacroDefinition)conversionContext.getProperty("macroDefinition"))) && !macroId.isEmpty()) {
                pageContentProvider.setMacroId(macroId);
                currentTableIndexOneBased = MacroHelper.findCurrentTableIndex(pageContentProvider.getOwnPageInStorageFormat(previewMode), macroId);
                pageContentProvider.setCurrentTableIndexOneBased(currentTableIndexOneBased);
            }
            if (Features.ASYNC_MACRO_LOAD && param.loadMacroDynamically) {
                ContentEntityObject contentEntityObject2;
                String strPageId = "";
                if (null != conversionContext && null != (contentEntityObject2 = conversionContext.getEntity())) {
                    strPageId = contentEntityObject2.getIdAsString();
                }
                String asyncMacroContent = this.getAsynchMacroInitialContent(parameters, previewMode, bodyContent, strPageId, pageContentProvider.getMacroId(), pageContentProvider.getCurrentTableIndexOneBased(), this.isTrialLicense() || this.isDeveloperLicense());
                return asyncMacroContent;
            }
            boolean isTrialLicense = !Features.CHECK_SERVER_LICENSE || this.isTrialLicense() || this.isDeveloperLicense();
            return NumericalExpressionMacro.doCalc(parameters, previewMode, bodyContent, conversionContext, pageContentProvider, this.xhtmlUtils, this.mathTextResolver, param, pageUrl, isTrialLicense);
        }
        catch (ExpressionCalculationException exception) {
            String oldMessage = exception.getMessage();
            String newMessage = oldMessage.replace(MacroHelper.UNIQUE_BRACES, "");
            throw new MacroExecutionException(newMessage);
        }
        catch (MacroExecutionException exception) {
            String oldMessage = exception.getMessage();
            String newMessage = oldMessage.replace(MacroHelper.UNIQUE_BRACES, "");
            throw new MacroExecutionException(newMessage);
        }
        catch (Exception exception) {
            throw new MacroExecutionException(String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.error.UnknowException"), exception.toString().replace(MacroHelper.UNIQUE_BRACES, "")));
        }
    }

    public Macro.BodyType getBodyType() {
        boolean mayEditMacro;
        if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache) {
            MacroResultCache.macroResultCache.clear();
        }
        if (mayEditMacro = CelestecsMathRestService.mayEditMacro(this.userAccessor)) {
            return Macro.BodyType.RICH_TEXT;
        }
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    protected boolean exemptDeveloperLicense() {
        return true;
    }

    protected boolean exemptOnDemand() {
        return false;
    }

    protected boolean isDeveloperLicense() throws MacroExecutionException {
        PluginLicense pluginLicense;
        boolean licenseOk;
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                }
            }
            catch (Exception exception) {
                licenseOk = false;
            }
        }
        if (!licenseOk && this.exemptDeveloperLicense() && Features.NEW_DEVELOPER_LICENSE_CHECK) {
            pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            LicenseType type = pluginLicense.getLicenseType();
            boolean bl2 = licenseOk = type == LicenseType.DEVELOPER;
            if (licenseOk) {
                MacroHelper.Log("Developer license applied");
            }
        }
        return false;
    }

    protected boolean isTrialLicense() throws MacroExecutionException {
        boolean licenseOk;
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    return pluginLicense.isEvaluation();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void validateLicense() throws MacroExecutionException {
        PluginLicense pluginLicense;
        boolean licenseOk;
        String reason = String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.licensing.unknown-error"), new Object[0]);
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                    if (!licenseOk) {
                        String errorName = ((LicenseError)pluginLicense.getError().get()).name();
                        reason = String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.licensing." + errorName), new Object[0]);
                    }
                } else {
                    reason = String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.licensing.no-license"), new Object[0]);
                }
            }
            catch (Exception exception) {
                licenseOk = false;
            }
        }
        if (!licenseOk && this.exemptDeveloperLicense() && Features.NEW_DEVELOPER_LICENSE_CHECK) {
            pluginLicense = null;
            try {
                pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
            }
            catch (Exception e) {
                pluginLicense = null;
            }
            if (null != pluginLicense) {
                LicenseType type = pluginLicense.getLicenseType();
                boolean bl2 = licenseOk = type == LicenseType.DEVELOPER;
            }
        }
        if (!licenseOk && this.exemptOnDemand()) {
            String onDemand = System.getProperty("atlassian.upm.on.demand");
            boolean bl3 = licenseOk = onDemand != null && onDemand.equals("true");
        }
        if (!licenseOk) {
            throw new MacroExecutionException(String.format(this.i18n.getText("com.celestecs.confluence.math.numerical-expression.licensing.invalid-license"), reason));
        }
    }

    public static String doCalc(Map<String, String> parameters, boolean previewMode, String bodyContent, ConversionContext conversionContext, PageContentProvider pageContentProvider, final XhtmlContent xhtmlUtils, MathTextResolver mathTextResolver, NumericalExpressionMacroParams param, String currentPageUrl, boolean isTrialLicense) throws MacroExecutionException {
        try {
            String strMacroDef;
            if (bodyContent == null || bodyContent.trim().isEmpty()) {
                return "";
            }
            final String pageUrl = currentPageUrl;
            if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache && MacroResultCache.macroResultCache.contains(strMacroDef = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef("numerical-expression", bodyContent, parameters, pageUrl))) {
                return MacroResultCache.macroResultCache.get(strMacroDef);
            }
            if (Features.LIMIT_SIMILAR_MACRO_COUNT && null != MacroResultCache.macroResultCache) {
                String strKey = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef("numerical-expression", bodyContent, parameters, pageUrl);
                MacroResultCache.macroResultCache.incStack(strKey);
                if (MacroResultCache.macroResultCache.isStackOverflow(strKey)) {
                    return "";
                }
            }
            String bodyWithNumbers = "";
            final ConversionContext cc = conversionContext;
            try {
                final boolean backwardCompatibilityMode = param.backwardCompatibilityMode;
                bodyWithNumbers = xhtmlUtils.replaceMacroDefinitionsWithString(bodyContent, conversionContext, new MacroDefinitionReplacer(){

                    public String replace(MacroDefinition macro) throws XhtmlException {
                        String strKey;
                        if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache && macro.getName().equalsIgnoreCase("numerical-expression") && MacroResultCache.macroResultCache.contains(strKey = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef(macro, pageUrl))) {
                            return MacroResultCache.macroResultCache.get(strKey);
                        }
                        String html = xhtmlUtils.convertMacroDefinitionToView(macro, cc);
                        String plainText = MacroHelper.html2text(html);
                        String result = "";
                        result = !backwardCompatibilityMode ? MacroHelper.getStringParametersBraces() + plainText + MacroHelper.getStringParametersBraces() : html;
                        if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache && macro.getName().equalsIgnoreCase("numerical-expression")) {
                            String strKey2 = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef(macro, pageUrl);
                            MacroResultCache.macroResultCache.put(strKey2, result);
                        }
                        return result;
                    }
                });
            }
            catch (Exception backwardCompatibilityMode) {
                // empty catch block
            }
            if (bodyWithNumbers == null || bodyWithNumbers.trim().isEmpty()) {
                return "";
            }
            if (Features.FIX_EXTRA_UNIQUE_BRACES_ISSUE) {
                bodyWithNumbers = bodyWithNumbers.replace(MacroHelper.UNIQUE_BRACES, "");
            }
            if (Features.RENDER_REFERENCED_CELLS_ONLY) {
                VariableValue[] varNames = MacroHelper.readAllVariablesFromMacroBody(bodyWithNumbers, param, previewMode, pageContentProvider, mathTextResolver);
                pageContentProvider.setVarNames(varNames);
            }
            String strTextToSearchVariablesFor = bodyWithNumbers;
            if (NumericalExpressionMacroParams.OuterValuesSource.CURRENT_CONFLUENCE_PAGE == param.outerValuesSource) {
                strTextToSearchVariablesFor = pageContentProvider.getOwnPage(previewMode);
            }
            if (NumericalExpressionMacroParams.OuterValuesSource.OTHER_CONFLUENCE_PAGE == param.outerValuesSource) {
                strTextToSearchVariablesFor = pageContentProvider.getOuterPage();
            }
            String result = DEF_RETURN_ON_ERROR;
            if (param.placement == NumericalExpressionMacroParams.ExpressionPlacementKind.SINGLE_EXPRESSION) {
                String formula = MacroHelper.html2text(bodyWithNumbers);
                if (formula != null && formula.trim().length() > 0) {
                    String formattedStr = "";
                    ArrayList<VariableValue> variables = new ArrayList<VariableValue>();
                    MacroHelper.findVariables(formula, previewMode, strTextToSearchVariablesFor, pageContentProvider, param, variables, mathTextResolver, true);
                    Object calcResult = MacroHelper.calculate(formula, variables, param, pageContentProvider, mathTextResolver, false, false, param.decimalSymbol, param.digitGroupingSymbol);
                    MacroHelper.Log("Result: " + calcResult);
                    if (!(calcResult instanceof DateTime) && MacroHelper.isNumeric(calcResult, param.decimalSymbol, param.digitGroupingSymbol)) {
                        formattedStr = MacroHelper.format(Conversion.parseDouble(calcResult, param.decimalSymbol, param.digitGroupingSymbol), param.decimalSymbol, param.digitGroupingSymbol, param.decimalPlaces, false);
                    } else if (MacroHelper.isArray(calcResult)) {
                        boolean bIsFirst = true;
                        for (Object o : (Object[])calcResult) {
                            if (bIsFirst) {
                                bIsFirst = false;
                                formattedStr = formattedStr + o.toString();
                                continue;
                            }
                            formattedStr = formattedStr + ", " + o.toString();
                        }
                        formattedStr = formattedStr.replace(MacroHelper.UNIQUE_BRACES, "");
                    } else {
                        formattedStr = calcResult.toString();
                        formattedStr = formattedStr.replace(MacroHelper.UNIQUE_BRACES, "");
                    }
                    result = param.showResultOnly ? MacroHelper.applyFormattingFromHtml(formattedStr, bodyWithNumbers) : MacroHelper.applyFormattingFromHtml(formula + " = " + formattedStr, bodyWithNumbers);
                }
            } else {
                int countClose;
                int formulaCounter = 0;
                char braceOpen = param.getOpenBrace();
                char braceClose = param.getCloseBrace();
                int countOpen = MacroHelper.countSymbol(bodyWithNumbers, braceOpen);
                if (countOpen != (countClose = MacroHelper.countSymbol(bodyWithNumbers, braceClose))) {
                    String errMsg = countOpen > countClose ? "com.celestecs.confluence.math.numerical-expression.error.NotAllOpeningBracesHaveAppropriateClosingBrace" : "com.celestecs.confluence.math.numerical-expression.error.NotAllClosingBracesHaveAppropriateOpeningBrace";
                    throw new MacroExecutionException(String.format(mathTextResolver.getText(errMsg), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                }
                int index = 0;
                result = "";
                while (index < bodyWithNumbers.length()) {
                    int foundClose;
                    int foundOpen = bodyWithNumbers.indexOf(braceOpen, index);
                    if (foundOpen < 0) {
                        result = result + bodyWithNumbers.substring(index);
                        break;
                    }
                    int currentSearchStart = foundOpen;
                    if (Features.ANY_PAGE_AS_A_SOURCE) {
                        int foundClosePageBrace;
                        int foundOpenPageBrace;
                        int index2 = currentSearchStart + 1;
                        while (index2 < bodyWithNumbers.length() && (foundOpenPageBrace = bodyWithNumbers.indexOf("[", index2)) >= 0 && (foundClosePageBrace = bodyWithNumbers.indexOf("]Table", index2 + 1)) >= 1) {
                            if (foundOpenPageBrace < foundClosePageBrace) {
                                currentSearchStart = index2 = foundClosePageBrace + "]Table".length();
                                continue;
                            }
                            throw new MacroExecutionException(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NextOpeningBraceBeforePreviousClosing"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                        }
                    }
                    if ((foundClose = bodyWithNumbers.indexOf(braceClose, currentSearchStart + 1)) < 1) {
                        result = result + bodyWithNumbers.substring(index);
                        break;
                    }
                    int nextFindOpen = bodyWithNumbers.indexOf(braceOpen, currentSearchStart + 1);
                    if (nextFindOpen > -1 && nextFindOpen < foundClose) {
                        throw new MacroExecutionException(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NextOpeningBraceBeforePreviousClosing"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                    }
                    result = result + bodyWithNumbers.substring(index, foundOpen);
                    String formula = MacroHelper.html2text(bodyWithNumbers.substring(foundOpen + 1, foundClose));
                    if (formula != null && formula.trim().length() > 0) {
                        ArrayList<VariableValue> variables = new ArrayList<VariableValue>();
                        MacroHelper.findVariables(formula, previewMode, strTextToSearchVariablesFor, pageContentProvider, param, variables, mathTextResolver, true);
                        Object calcResult = MacroHelper.calculate(formula, variables, param, pageContentProvider, mathTextResolver, false, false, param.decimalSymbol, param.digitGroupingSymbol);
                        MacroHelper.Log("Result: " + calcResult);
                        ++formulaCounter;
                        String formattedStr = "";
                        if (MacroHelper.isNumeric(calcResult, param.decimalSymbol, param.digitGroupingSymbol)) {
                            formattedStr = MacroHelper.format(Conversion.parseDouble(calcResult, param.decimalSymbol, param.digitGroupingSymbol), param.decimalSymbol, param.digitGroupingSymbol, param.decimalPlaces, false);
                        } else if (MacroHelper.isArray(calcResult)) {
                            boolean bIsFirst = true;
                            for (Object o : (Object[])calcResult) {
                                if (bIsFirst) {
                                    bIsFirst = false;
                                    formattedStr = formattedStr + o.toString();
                                    continue;
                                }
                                formattedStr = formattedStr + ", " + o.toString();
                            }
                        } else {
                            formattedStr = calcResult.toString();
                        }
                        result = param.showResultOnly ? result + formattedStr : result + formula + " = " + formattedStr;
                    }
                    index = foundClose + 1;
                }
                if (formulaCounter == 0) {
                    throw new MacroExecutionException(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NoExpressionWasFound"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                }
            }
            result = result.replace(MacroHelper.UNIQUE_BRACES, "");
            if (isTrialLicense) {
                result = result + MacroHelper.MATH_TRIAL_STRING;
            }
            String convertedResult = xhtmlUtils.convertStorageToView(result, conversionContext);
            if (Features.BREAK_RENDER_LOOP_2 && null != MacroResultCache.macroResultCache) {
                String strKey = ConfluenceServerMacroPageContentProvider.makeKeyFromMacroDef("numerical-expression", bodyContent, parameters, pageUrl);
                MacroResultCache.macroResultCache.put(strKey, convertedResult);
            }
            return convertedResult;
        }
        catch (ExpressionCalculationException exception) {
            String oldMessage = exception.getMessage();
            String newMessage = oldMessage.replace(MacroHelper.UNIQUE_BRACES, "");
            throw new MacroExecutionException(newMessage);
        }
        catch (MacroExecutionException exception) {
            String oldMessage = exception.getMessage();
            String newMessage = oldMessage.replace(MacroHelper.UNIQUE_BRACES, "");
            throw new MacroExecutionException(newMessage);
        }
        catch (Exception exception) {
            throw new MacroExecutionException(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.UnknowException"), exception.toString().replace(MacroHelper.UNIQUE_BRACES, "")));
        }
    }
}

