/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.usermodel;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.RoundingMode;
import java.text.DateFormatSymbols;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.ExcelStyleDateFormatter;

public class DataFormatter {
    private static final Pattern numPattern = Pattern.compile("[0#]+");
    private static final Pattern daysAsText = Pattern.compile("([d]{3,})", 2);
    private static final Pattern amPmPattern = Pattern.compile("((A|P)[M/P]*)", 2);
    private static final Pattern localePatternGroup = Pattern.compile("(\\[\\$[^-\\]]*-[0-9A-Z]+\\])");
    private static final Pattern colorPattern = Pattern.compile("(\\[BLACK\\])|(\\[BLUE\\])|(\\[CYAN\\])|(\\[GREEN\\])|(\\[MAGENTA\\])|(\\[RED\\])|(\\[WHITE\\])|(\\[YELLOW\\])|(\\[COLOR\\s*\\d\\])|(\\[COLOR\\s*[0-5]\\d\\])", 2);
    private static final String invalidDateTimeString;
    private final DecimalFormatSymbols decimalSymbols;
    private final DateFormatSymbols dateSymbols;
    private final Format generalWholeNumFormat;
    private final Format generalDecimalNumFormat;
    private Format defaultNumFormat;
    private final Map<String, Format> formats;
    private boolean emulateCsv = false;

    public DataFormatter() {
        this(false);
    }

    public DataFormatter(boolean emulateCsv) {
        this(Locale.getDefault());
        this.emulateCsv = emulateCsv;
    }

    public DataFormatter(Locale locale, boolean emulateCsv) {
        this(locale);
        this.emulateCsv = emulateCsv;
    }

    public DataFormatter(Locale locale) {
        this.dateSymbols = new DateFormatSymbols(locale);
        this.decimalSymbols = new DecimalFormatSymbols(locale);
        this.generalWholeNumFormat = new DecimalFormat("#", this.decimalSymbols);
        this.generalDecimalNumFormat = new DecimalFormat("#.##########", this.decimalSymbols);
        this.formats = new HashMap<String, Format>();
        Format zipFormat = ZipPlusFourFormat.instance;
        this.addFormat("00000\\-0000", zipFormat);
        this.addFormat("00000-0000", zipFormat);
        Format phoneFormat = PhoneFormat.instance;
        this.addFormat("[<=9999999]###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("[<=9999999]###-####;(###) ###-####", phoneFormat);
        this.addFormat("###\\-####;\\(###\\)\\ ###\\-####", phoneFormat);
        this.addFormat("###-####;(###) ###-####", phoneFormat);
        Format ssnFormat = SSNFormat.instance;
        this.addFormat("000\\-00\\-0000", ssnFormat);
        this.addFormat("000-00-0000", ssnFormat);
    }

    private Format getFormat(double cellValue, int formatIndex, String formatStrIn) {
        Format format;
        String formatStr = formatStrIn;
        int firstAt = formatStr.indexOf(59);
        int lastAt = formatStr.lastIndexOf(59);
        if (firstAt != -1 && firstAt != lastAt) {
            int secondAt = formatStr.indexOf(59, firstAt + 1);
            formatStr = secondAt == lastAt ? (cellValue == 0.0 ? formatStr.substring(lastAt + 1) : formatStr.substring(0, lastAt)) : (cellValue == 0.0 ? formatStr.substring(secondAt + 1, lastAt) : formatStr.substring(0, secondAt));
        }
        if (this.emulateCsv && cellValue == 0.0 && formatStr.contains("#") && !formatStr.contains("0")) {
            formatStr = formatStr.replaceAll("#", "");
        }
        if ((format = this.formats.get(formatStr)) != null) {
            return format;
        }
        if ("General".equalsIgnoreCase(formatStr) || "@".equals(formatStr)) {
            if (DataFormatter.isWholeNumber(cellValue)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        format = this.createFormat(cellValue, formatIndex, formatStr);
        this.formats.put(formatStr, format);
        return format;
    }

    private Format createFormat(double cellValue, int formatIndex, String sFormat) {
        String nFormatStr;
        String colour;
        int at;
        String formatStr = sFormat;
        Matcher colourM = colorPattern.matcher(formatStr);
        while (colourM.find() && (at = formatStr.indexOf(colour = colourM.group())) != -1 && !(nFormatStr = formatStr.substring(0, at) + formatStr.substring(at + colour.length())).equals(formatStr)) {
            formatStr = nFormatStr;
            colourM = colorPattern.matcher(formatStr);
        }
        Matcher m = localePatternGroup.matcher(formatStr);
        while (m.find()) {
            String match = m.group();
            String symbol = match.substring(match.indexOf(36) + 1, match.indexOf(45));
            if (symbol.indexOf(36) > -1) {
                StringBuffer sb = new StringBuffer();
                sb.append(symbol.substring(0, symbol.indexOf(36)));
                sb.append('\\');
                sb.append(symbol.substring(symbol.indexOf(36), symbol.length()));
                symbol = sb.toString();
            }
            formatStr = m.replaceAll(symbol);
            m = localePatternGroup.matcher(formatStr);
        }
        if (formatStr == null || formatStr.trim().length() == 0) {
            return this.getDefaultFormat(cellValue);
        }
        if ("General".equalsIgnoreCase(formatStr) || "@".equals(formatStr)) {
            if (DataFormatter.isWholeNumber(cellValue)) {
                return this.generalWholeNumFormat;
            }
            return this.generalDecimalNumFormat;
        }
        if (DateUtil.isADateFormat(formatIndex, formatStr) && DateUtil.isValidExcelDate(cellValue)) {
            return this.createDateFormat(formatStr, cellValue);
        }
        if (formatStr.indexOf("#/#") >= 0 || formatStr.indexOf("?/?") >= 0) {
            String strippedFormatStr = formatStr.replaceAll("\\\\ ", " ").replaceAll("\\\\.", "").replaceAll("\"[^\"]*\"", " ");
            boolean ok = true;
            for (String part : strippedFormatStr.split(";")) {
                int indexOfFraction = this.indexOfFraction(part);
                if (indexOfFraction != -1 && indexOfFraction == this.lastIndexOfFraction(part)) continue;
                ok = false;
                break;
            }
            if (ok) {
                return new FractionFormat(strippedFormatStr);
            }
        }
        if (numPattern.matcher(formatStr).find()) {
            return this.createNumberFormat(formatStr, cellValue);
        }
        if (this.emulateCsv) {
            return new ConstantStringFormat(this.cleanFormatForNumber(formatStr));
        }
        return null;
    }

    private int indexOfFraction(String format) {
        int i = format.indexOf("#/#");
        int j = format.indexOf("?/?");
        return i == -1 ? j : (j == -1 ? i : Math.min(i, j));
    }

    private int lastIndexOfFraction(String format) {
        int i = format.lastIndexOf("#/#");
        int j = format.lastIndexOf("?/?");
        return i == -1 ? j : (j == -1 ? i : Math.max(i, j));
    }

    private Format createDateFormat(String pFormatStr, double cellValue) {
        String formatStr = pFormatStr;
        formatStr = formatStr.replaceAll("\\\\-", "-");
        formatStr = formatStr.replaceAll("\\\\,", ",");
        formatStr = formatStr.replaceAll("\\\\\\.", ".");
        formatStr = formatStr.replaceAll("\\\\ ", " ");
        formatStr = formatStr.replaceAll("\\\\/", "/");
        formatStr = formatStr.replaceAll(";@", "");
        formatStr = formatStr.replaceAll("\"/\"", "/");
        boolean hasAmPm = false;
        Matcher amPmMatcher = amPmPattern.matcher(formatStr);
        while (amPmMatcher.find()) {
            formatStr = amPmMatcher.replaceAll("@");
            hasAmPm = true;
            amPmMatcher = amPmPattern.matcher(formatStr);
        }
        Matcher dateMatcher = daysAsText.matcher(formatStr = formatStr.replaceAll("@", "a"));
        if (dateMatcher.find()) {
            String match = dateMatcher.group(0);
            formatStr = dateMatcher.replaceAll(match.toUpperCase().replaceAll("D", "E"));
        }
        StringBuffer sb = new StringBuffer();
        char[] chars = formatStr.toCharArray();
        boolean mIsMonth = true;
        ArrayList<Integer> ms = new ArrayList<Integer>();
        boolean isElapsed = false;
        for (int j = 0; j < chars.length; ++j) {
            char c = chars[j];
            if (c == '[' && !isElapsed) {
                isElapsed = true;
                mIsMonth = false;
                sb.append(c);
                continue;
            }
            if (c == ']' && isElapsed) {
                isElapsed = false;
                sb.append(c);
                continue;
            }
            if (isElapsed) {
                if (c == 'h' || c == 'H') {
                    sb.append('H');
                    continue;
                }
                if (c == 'm' || c == 'M') {
                    sb.append('m');
                    continue;
                }
                if (c == 's' || c == 'S') {
                    sb.append('s');
                    continue;
                }
                sb.append(c);
                continue;
            }
            if (c == 'h' || c == 'H') {
                mIsMonth = false;
                if (hasAmPm) {
                    sb.append('h');
                    continue;
                }
                sb.append('H');
                continue;
            }
            if (c == 'm' || c == 'M') {
                if (mIsMonth) {
                    sb.append('M');
                    ms.add(sb.length() - 1);
                    continue;
                }
                sb.append('m');
                continue;
            }
            if (c == 's' || c == 'S') {
                sb.append('s');
                for (int i = 0; i < ms.size(); ++i) {
                    int index = (Integer)ms.get(i);
                    if (sb.charAt(index) != 'M') continue;
                    sb.replace(index, index + 1, "m");
                }
                mIsMonth = true;
                ms.clear();
                continue;
            }
            if (Character.isLetter(c)) {
                mIsMonth = true;
                ms.clear();
                if (c == 'y' || c == 'Y') {
                    sb.append('y');
                    continue;
                }
                if (c == 'd' || c == 'D') {
                    sb.append('d');
                    continue;
                }
                sb.append(c);
                continue;
            }
            sb.append(c);
        }
        formatStr = sb.toString();
        try {
            return new ExcelStyleDateFormatter(formatStr, this.dateSymbols);
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private String cleanFormatForNumber(String formatStr) {
        char c;
        int i;
        StringBuffer sb = new StringBuffer(formatStr);
        if (this.emulateCsv) {
            for (i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (c != '_' && c != '*' && c != '?' || i > 0 && sb.charAt(i - 1) == '\\') continue;
                if (c == '?') {
                    sb.setCharAt(i, ' ');
                    continue;
                }
                if (i >= sb.length() - 1) continue;
                if (c == '_') {
                    sb.setCharAt(i + 1, ' ');
                } else {
                    sb.deleteCharAt(i + 1);
                }
                sb.deleteCharAt(i);
            }
        } else {
            for (i = 0; i < sb.length(); ++i) {
                c = sb.charAt(i);
                if (c != '_' && c != '*' || i > 0 && sb.charAt(i - 1) == '\\') continue;
                if (i < sb.length() - 1) {
                    sb.deleteCharAt(i + 1);
                }
                sb.deleteCharAt(i);
            }
        }
        for (i = 0; i < sb.length(); ++i) {
            c = sb.charAt(i);
            if (c == '\\' || c == '\"') {
                sb.deleteCharAt(i);
                --i;
                continue;
            }
            if (c != '+' || i <= 0 || sb.charAt(i - 1) != 'E') continue;
            sb.deleteCharAt(i);
            --i;
        }
        return sb.toString();
    }

    private Format createNumberFormat(String formatStr, double cellValue) {
        String format = this.cleanFormatForNumber(formatStr);
        try {
            DecimalFormat df = new DecimalFormat(format, this.decimalSymbols);
            DataFormatter.setExcelStyleRoundingMode(df);
            return df;
        }
        catch (IllegalArgumentException iae) {
            return this.getDefaultFormat(cellValue);
        }
    }

    private static boolean isWholeNumber(double d) {
        return d == Math.floor(d);
    }

    private Format getDefaultFormat(double cellValue) {
        if (this.defaultNumFormat != null) {
            return this.defaultNumFormat;
        }
        if (DataFormatter.isWholeNumber(cellValue)) {
            return this.generalWholeNumFormat;
        }
        return this.generalDecimalNumFormat;
    }

    private String performDateFormatting(Date d, Format dateFormat) {
        if (dateFormat != null) {
            return dateFormat.format(d);
        }
        return d.toString();
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString) {
        return this.formatRawCellContents(value, formatIndex, formatString, false);
    }

    public String formatRawCellContents(double value, int formatIndex, String formatString, boolean use1904Windowing) {
        Format numberFormat;
        if (DateUtil.isADateFormat(formatIndex, formatString)) {
            if (DateUtil.isValidExcelDate(value)) {
                Format dateFormat = this.getFormat(value, formatIndex, formatString);
                if (dateFormat instanceof ExcelStyleDateFormatter) {
                    ((ExcelStyleDateFormatter)dateFormat).setDateToBeFormatted(value);
                }
                Date d = DateUtil.getJavaDate(value, use1904Windowing);
                return this.performDateFormatting(d, dateFormat);
            }
            if (this.emulateCsv) {
                return invalidDateTimeString;
            }
        }
        if ((numberFormat = this.getFormat(value, formatIndex, formatString)) == null) {
            return String.valueOf(value);
        }
        String result = numberFormat.format(new Double(value));
        if (result.contains("E") && !result.contains("E-")) {
            result = result.replaceFirst("E", "E+");
        }
        return result;
    }

    public void setDefaultNumberFormat(Format format) {
        for (Map.Entry<String, Format> entry : this.formats.entrySet()) {
            if (entry.getValue() != this.generalDecimalNumFormat && entry.getValue() != this.generalWholeNumFormat) continue;
            entry.setValue(format);
        }
        this.defaultNumFormat = format;
    }

    public void addFormat(String excelFormatStr, Format format) {
        this.formats.put(excelFormatStr, format);
    }

    static DecimalFormat createIntegerOnlyFormat(String fmt) {
        DecimalFormat result = new DecimalFormat(fmt);
        result.setParseIntegerOnly(true);
        return result;
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format) {
        DataFormatter.setExcelStyleRoundingMode(format, RoundingMode.HALF_UP);
    }

    public static void setExcelStyleRoundingMode(DecimalFormat format, RoundingMode roundingMode) {
        try {
            Method srm = format.getClass().getMethod("setRoundingMode", RoundingMode.class);
            srm.invoke((Object)format, new Object[]{roundingMode});
        }
        catch (NoSuchMethodException srm) {
        }
        catch (IllegalAccessException iae) {
            throw new RuntimeException("Unable to set rounding mode", iae);
        }
        catch (InvocationTargetException ite) {
            throw new RuntimeException("Unable to set rounding mode", ite);
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    static {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < 255; ++i) {
            buf.append('#');
        }
        invalidDateTimeString = buf.toString();
    }

    private static final class ConstantStringFormat
    extends Format {
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("##########");
        private final String str;

        public ConstantStringFormat(String s) {
            this.str = s;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.str);
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class FractionFormat
    extends Format {
        private final String str;

        public FractionFormat(String s) {
            this.str = s;
        }

        public String format(Number num) {
            String[] parts;
            double decPart;
            double doubleValue = num.doubleValue();
            String[] formatBits = this.str.split(";");
            int f = doubleValue > 0.0 ? 0 : (doubleValue < 0.0 ? 1 : 2);
            String str = f < formatBits.length ? formatBits[f] : formatBits[0];
            double wholePart = Math.floor(Math.abs(doubleValue));
            if (wholePart + (decPart = Math.abs(doubleValue) - wholePart) == 0.0) {
                return "0";
            }
            if (doubleValue < 0.0) {
                wholePart *= -1.0;
            }
            String[] fractParts = (parts = str.replaceAll("  *", " ").split(" ")).length == 2 ? parts[1].split("/") : str.split("/");
            for (int i = 0; i < fractParts.length; ++i) {
                fractParts[i] = fractParts[i].replace('?', '#');
            }
            if (fractParts.length == 2) {
                int fractPart1Length = Math.min(this.countHashes(fractParts[1]), 4);
                double minVal = 1.0;
                double currDenom = Math.pow(10.0, fractPart1Length) - 1.0;
                double currNeum = 0.0;
                for (int i = (int)(Math.pow(10.0, fractPart1Length) - 1.0); i > 0; --i) {
                    for (int i2 = (int)(Math.pow(10.0, fractPart1Length) - 1.0); i2 > 0; --i2) {
                        if (!(minVal >= Math.abs((double)i2 / (double)i - decPart))) continue;
                        currDenom = i;
                        currNeum = i2;
                        minVal = Math.abs((double)i2 / (double)i - decPart);
                    }
                }
                DecimalFormat neumFormatter = new DecimalFormat(fractParts[0]);
                DecimalFormat denomFormatter = new DecimalFormat(fractParts[1]);
                if (parts.length == 2) {
                    DecimalFormat wholeFormatter = new DecimalFormat(parts[0]);
                    String result = wholeFormatter.format(wholePart) + " " + neumFormatter.format(currNeum) + "/" + denomFormatter.format(currDenom);
                    return result;
                }
                String result = neumFormatter.format(currNeum + currDenom * wholePart) + "/" + denomFormatter.format(currDenom);
                return result;
            }
            throw new IllegalArgumentException("Fraction must have 2 parts, found " + fractParts.length + " for fraction format " + this.str);
        }

        private int countHashes(String format) {
            int count = 0;
            for (int i = format.length() - 1; i >= 0; --i) {
                if (format.charAt(i) != '#') continue;
                ++count;
            }
            return count;
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(this.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            throw new NotImplementedException("Reverse parsing not supported");
        }
    }

    private static final class PhoneFormat
    extends Format {
        public static final Format instance = new PhoneFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("##########");

        private PhoneFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            int len = result.length();
            if (len <= 4) {
                return result;
            }
            String seg3 = result.substring(len - 4, len);
            String seg2 = result.substring(Math.max(0, len - 7), len - 4);
            String seg1 = result.substring(Math.max(0, len - 10), Math.max(0, len - 7));
            if (seg1 != null && seg1.trim().length() > 0) {
                sb.append('(').append(seg1).append(") ");
            }
            if (seg2 != null && seg2.trim().length() > 0) {
                sb.append(seg2).append('-');
            }
            sb.append(seg3);
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(PhoneFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class ZipPlusFourFormat
    extends Format {
        public static final Format instance = new ZipPlusFourFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private ZipPlusFourFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(ZipPlusFourFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }

    private static final class SSNFormat
    extends Format {
        public static final Format instance = new SSNFormat();
        private static final DecimalFormat df = DataFormatter.createIntegerOnlyFormat("000000000");

        private SSNFormat() {
        }

        public static String format(Number num) {
            String result = df.format(num);
            StringBuffer sb = new StringBuffer();
            sb.append(result.substring(0, 3)).append('-');
            sb.append(result.substring(3, 5)).append('-');
            sb.append(result.substring(5, 9));
            return sb.toString();
        }

        @Override
        public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
            return toAppendTo.append(SSNFormat.format((Number)obj));
        }

        @Override
        public Object parseObject(String source, ParsePosition pos) {
            return df.parseObject(source, pos);
        }
    }
}

