/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.text;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorSubstitute
extends CalculatorBase {
    public CalculatorSubstitute(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        String result;
        super.CheckForNotHavingRanges(objParams);
        if (null == objParams || objParams.length != 3 && objParams.length != 4 || objParams.length == 4 && !Conversion.isLong(objParams[3], this.decimalSymbol, this.digitGroupingSymbol)) {
            return new String("");
        }
        String text = objParams[0].toString();
        String old_text = objParams[1].toString();
        String new_text = objParams[2].toString();
        Long instance_num = null;
        if (4 == objParams.length) {
            instance_num = Conversion.objectToLong(objParams[3], this.decimalSymbol, this.digitGroupingSymbol);
            result = CalculatorSubstitute.replaceOneOccurrence(text, old_text, new_text, instance_num.intValue());
        } else {
            result = CalculatorSubstitute.replaceAllOccurrences(text, old_text, new_text);
        }
        return result;
    }

    public static String replaceAllOccurrences(String text, String old_text, String new_text) {
        StringBuffer sb = new StringBuffer();
        int startIndex = 0;
        int nextMatch = -1;
        while (true) {
            if ((nextMatch = text.indexOf(old_text, startIndex)) < 0) {
                sb.append(text.substring(startIndex));
                return sb.toString();
            }
            sb.append(text.substring(startIndex, nextMatch));
            sb.append(new_text);
            startIndex = nextMatch + old_text.length();
        }
    }

    private static String replaceOneOccurrence(String text, String old_text, String new_text, int instance_num) {
        if (old_text.length() < 1) {
            return text;
        }
        int startIndex = 0;
        int nextMatch = -1;
        int count = 0;
        while ((nextMatch = text.indexOf(old_text, startIndex)) >= 0) {
            if (++count == instance_num) {
                StringBuffer sb = new StringBuffer(text.length() + new_text.length());
                sb.append(text.substring(0, nextMatch));
                sb.append(new_text);
                sb.append(text.substring(nextMatch + old_text.length()));
                return sb.toString();
            }
            startIndex = nextMatch + old_text.length();
        }
        return text;
    }
}

