/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.statistical;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorMin
extends CalculatorBase {
    public CalculatorMin(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        long[] lParameters = Conversion.objectArrayToLongArray(objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams), this.decimalSymbol, this.digitGroupingSymbol);
        if (null != lParameters && lParameters.length > 0) {
            long min = lParameters[0];
            int paramCount = lParameters.length;
            for (int i = 1; i < paramCount; ++i) {
                min = Math.min(min, lParameters[i]);
            }
            return new Long(min);
        }
        DateTime[] dtParameters = Conversion.objectArrayToDateTimeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        if (null != dtParameters && dtParameters.length > 0) {
            DateTime minTd = dtParameters[0];
            double min = minTd.getValue();
            int paramCount = dtParameters.length;
            for (int i = 1; i < paramCount; ++i) {
                double dVal = dtParameters[i].getValue();
                if (!(dVal < min)) continue;
                minTd = dtParameters[i];
                min = dVal;
            }
            return minTd;
        }
        double[] parameters = Conversion.objectArrayToDoubleArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        if (null != parameters && parameters.length > 0) {
            double min = parameters[0];
            int paramCount = parameters.length;
            for (int i = 1; i < paramCount; ++i) {
                min = Math.min(min, parameters[i]);
            }
            return new Double(min);
        }
        return "NaN";
    }
}

