/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorRate
extends CalculatorBase {
    public CalculatorRate(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected void checkToBeDouble(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    protected void checkToBeLong(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Long.");
        }
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 3 || objParams.length > 6) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 3 and no more than 5.");
        }
        this.checkToBeDouble(objParams[0], "Nper");
        double Nper = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        this.checkToBeDouble(objParams[1], "Pmt");
        double Pmt = Conversion.objectToDouble(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        this.checkToBeDouble(objParams[2], "Pv");
        double Pv = Conversion.objectToDouble(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        double Fv = 0.0;
        if (objParams.length > 3) {
            this.checkToBeDouble(objParams[3], "Fv");
            Fv = Conversion.objectToDouble(objParams[3], this.decimalSymbol, this.digitGroupingSymbol);
        }
        double Type2 = 0.0;
        if (objParams.length > 4) {
            this.checkToBeDouble(objParams[4], "Type");
            Type2 = Conversion.objectToDouble(objParams[4], this.decimalSymbol, this.digitGroupingSymbol);
        }
        double Guess = 10.0;
        if (objParams.length > 5) {
            this.checkToBeDouble(objParams[5], "Guess");
            Guess = Conversion.objectToDouble(objParams[5], this.decimalSymbol, this.digitGroupingSymbol);
        }
        return new Double(this.calculateRate(Nper, Pmt, Pv, Fv, Type2, Guess));
    }

    private double calculateRate(double nper, double pmt, double pv, double fv, double type, double guess) {
        double y;
        int FINANCIAL_MAX_ITERATIONS = 20;
        double FINANCIAL_PRECISION = 1.0E-7;
        double x1 = 0.0;
        double f = 0.0;
        double i = 0.0;
        double rate = guess;
        if (Math.abs(rate) < FINANCIAL_PRECISION) {
            y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
        } else {
            f = Math.exp(nper * Math.log(1.0 + rate));
            y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        }
        double y0 = pv + pmt * nper + fv;
        double y1 = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
        double x0 = 0.0;
        x1 = rate;
        for (i = 0.0; Math.abs(y0 - y1) > FINANCIAL_PRECISION && i < (double)FINANCIAL_MAX_ITERATIONS; i += 1.0) {
            rate = (y1 * x0 - y0 * x1) / (y1 - y0);
            x0 = x1;
            x1 = rate;
            if (Math.abs(rate) < FINANCIAL_PRECISION) {
                y = pv * (1.0 + nper * rate) + pmt * (1.0 + rate * type) * nper + fv;
            } else {
                f = Math.exp(nper * Math.log(1.0 + rate));
                y = pv * f + pmt * (1.0 / rate + type) * (f - 1.0) + fv;
            }
            y0 = y1;
            y1 = y;
        }
        return rate;
    }
}

