/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.Features;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalculatorDays
extends CalculatorBase {
    public CalculatorDays(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 2);
        super.CheckForNotHavingRanges(objParams);
        DateTime d0 = Conversion.objectToDateTime(objParams[0]);
        DateTime d1 = Conversion.objectToDateTime(objParams[1]);
        if (null == d0 || null == d1) {
            return -1L;
        }
        try {
            Date jd0 = DateTime.getClearDate(DateUtil.getJavaDate(d0.getValue()));
            Date jd1 = DateTime.getClearDate(DateUtil.getJavaDate(d1.getValue()));
            int res = this.daysBetween(jd0, jd1);
            return new Long(res);
        }
        catch (Exception e) {
            return -1L;
        }
    }

    public int daysBetween(Date d0, Date d1) {
        if (Features.FIX_DAYS_FUNC) {
            return (int)((d0.getTime() - d1.getTime()) / 86400000L);
        }
        return (int)(Math.abs(d1.getTime() - d0.getTime()) / 86400000L);
    }
}

