/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Calculator;
import com.celestecs.expression.Compiler;
import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.Parser;
import com.celestecs.expression.QueryExecutor;
import java.util.HashMap;
import java.util.Map;

public final class ToolsHelper {
    private static Map<String, OperationsRegistry> operationsRegistries = new HashMap<String, OperationsRegistry>();
    private static Map<String, Parser> parsers = new HashMap<String, Parser>();
    private static Map<String, Compiler> compilers = new HashMap<String, Compiler>();
    private static Map<String, Calculator> calculators = new HashMap<String, Calculator>();
    private static QueryExecutor jqlQueryExecutor = null;
    private static QueryExecutor cqlQueryExecutor = null;

    public static void setJqlQueryExecutor(QueryExecutor jql) {
        jqlQueryExecutor = jql;
    }

    public static QueryExecutor getJqlQueryExecutor() {
        return jqlQueryExecutor;
    }

    public static void setCqlQueryExecutor(QueryExecutor cql) {
        cqlQueryExecutor = cql;
    }

    public static QueryExecutor getCqlQueryExecutor() {
        return cqlQueryExecutor;
    }

    protected static String generateKey(char decimalSymbol, String digitGroupingSymbol) {
        String key = decimalSymbol + "+" + digitGroupingSymbol;
        return key;
    }

    public static OperationsRegistry getOperationsRegistry(char decimalSymbol, String digitGroupingSymbol) {
        String key = ToolsHelper.generateKey(decimalSymbol, digitGroupingSymbol);
        OperationsRegistry operationsRegistry = operationsRegistries.get(key);
        if (null == operationsRegistry) {
            operationsRegistry = new OperationsRegistry(decimalSymbol, digitGroupingSymbol);
            operationsRegistry.setJqlQueryExecutor(jqlQueryExecutor);
            operationsRegistries.put(key, operationsRegistry);
        }
        return operationsRegistry;
    }

    public static Parser getParser(char decimalSymbol, String digitGroupingSymbol) {
        String key = ToolsHelper.generateKey(decimalSymbol, digitGroupingSymbol);
        Parser parser = parsers.get(key);
        if (null == parser) {
            OperationsRegistry operationsRegistry = ToolsHelper.getOperationsRegistry(decimalSymbol, digitGroupingSymbol);
            parser = new Parser(operationsRegistry);
            parsers.put(key, parser);
        }
        return parser;
    }

    public static Compiler getCompiler(char decimalSymbol, String digitGroupingSymbol) {
        String key = ToolsHelper.generateKey(decimalSymbol, digitGroupingSymbol);
        Compiler compiler = compilers.get(key);
        if (null == compiler) {
            OperationsRegistry operationsRegistry = ToolsHelper.getOperationsRegistry(decimalSymbol, digitGroupingSymbol);
            compiler = new Compiler(operationsRegistry);
            compilers.put(key, compiler);
        }
        return compiler;
    }

    public static Calculator getCalculator(char decimalSymbol, String digitGroupingSymbol) {
        String key = ToolsHelper.generateKey(decimalSymbol, digitGroupingSymbol);
        Calculator calculator = calculators.get(key);
        if (null == calculator) {
            OperationsRegistry operationsRegistry = ToolsHelper.getOperationsRegistry(decimalSymbol, digitGroupingSymbol);
            calculator = new Calculator(operationsRegistry);
            calculators.put(key, calculator);
        }
        return calculator;
    }
}

