/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.workwithjira;

import com.celestecs.expression.OperationsRegistry;
import com.celestecs.expression.QueryExecutor;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;

public final class CalculatorJiraIssueCount
extends CalculatorBase {
    protected OperationsRegistry operationsRegistry = null;

    public CalculatorJiraIssueCount(OperationsRegistry operationsRegistry, char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
        this.operationsRegistry = operationsRegistry;
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length > 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be no more than 2.");
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return -1L;
        }
        String appLinkName = "";
        if (objParams.length == 2 && null != objParams[1]) {
            appLinkName = objParams[1].toString();
        }
        String jqlRequest = objParams[0].toString();
        if (null == this.operationsRegistry) {
            return -1;
        }
        QueryExecutor jqlQueryExecutor = this.operationsRegistry.getJqlQueryExecutor();
        if (null == jqlQueryExecutor) {
            return -1;
        }
        try {
            long lResult = jqlQueryExecutor.getNumberOfResults(jqlRequest, appLinkName);
            return lResult;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

