/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.statistical;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorMax
extends CalculatorBase {
    public CalculatorMax(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        long[] lParameters = Conversion.objectArrayToLongArray(objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams), this.decimalSymbol, this.digitGroupingSymbol);
        if (null != lParameters && lParameters.length > 0) {
            long max = lParameters[0];
            int paramCount = lParameters.length;
            for (int i = 1; i < paramCount; ++i) {
                max = Math.max(max, lParameters[i]);
            }
            return max;
        }
        DateTime[] dtParameters = Conversion.objectArrayToDateTimeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        if (null != dtParameters && dtParameters.length > 0) {
            DateTime maxTd = dtParameters[0];
            double max = maxTd.getValue();
            int paramCount = dtParameters.length;
            for (int i = 1; i < paramCount; ++i) {
                double dVal = dtParameters[i].getValue();
                if (!(dVal > max)) continue;
                maxTd = dtParameters[i];
                max = dVal;
            }
            return maxTd;
        }
        double[] dblParameters = Conversion.objectArrayToDoubleArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        if (null != dblParameters && dblParameters.length > 0) {
            double max = dblParameters[0];
            int paramCount = dblParameters.length;
            for (int i = 1; i < paramCount; ++i) {
                max = Math.max(max, dblParameters[i]);
            }
            return max;
        }
        return "NaN";
    }
}

