/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dataaccess;

import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.safety.Safelist;
import org.jsoup.select.Elements;

public class CalculatorGetConfluencePageElementData
extends CalculatorBase {
    private PageContentProvider pageContentProvider = null;

    public CalculatorGetConfluencePageElementData(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    public PageContentProvider getPageContentProvider() {
        return this.pageContentProvider;
    }

    public void setPageContentProvider(PageContentProvider pageContentProvider) {
        this.pageContentProvider = pageContentProvider;
    }

    @Override
    public Object Calculate(Object[] objParams) {
        if (!Features.FIRST_DATA_ACCESS_FUNCTIONS_SUPPORT) {
            return "";
        }
        super.CheckParamsForMinimalNumberOfParams(objParams, 2);
        super.CheckForNotHavingRanges(objParams);
        String page = objParams[0].toString();
        String selectQuery = objParams[1].toString();
        int index = -1;
        if (objParams.length > 2) {
            if (!Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)) {
                throw new IllegalArgumentException(". Third parameter value should be integer value, but it is '" + objParams[2] + "'.");
            }
            Long lIndex = Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
            if (null != lIndex) {
                index = lIndex.intValue();
            }
        }
        String result = CalculatorGetConfluencePageElementData.getConfluencePageElementData(page, selectQuery, index, true, this.pageContentProvider, this.decimalSymbol, this.digitGroupingSymbol);
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static String getConfluencePageElementData(String page, String selectQuery, int index, boolean asPlainText, PageContentProvider pageContentProvider, char decimalSymbol, String digitGroupingSymbol) throws IllegalArgumentException {
        if (null == pageContentProvider) {
            return "";
        }
        try {
            String unsafe = pageContentProvider.getPage(page);
            String result = Jsoup.clean(unsafe, Safelist.relaxed());
            if (null == selectQuery) return MacroHelper.unescapeHtml3(result);
            if (selectQuery.length() <= 0) return MacroHelper.unescapeHtml3(result);
            Document doc = Jsoup.parseBodyFragment(result);
            Elements elements = doc.select(selectQuery);
            if (null == elements) throw new IllegalArgumentException(". No elements were found for the select query '" + selectQuery + "'.");
            if (null == elements.text()) throw new IllegalArgumentException(". No elements were found for the select query '" + selectQuery + "'.");
            if (elements.text().length() <= 0) throw new IllegalArgumentException(". No elements were found for the select query '" + selectQuery + "'.");
            if (index >= 0) {
                if (index >= elements.size()) {
                    throw new IllegalArgumentException(". The specified index " + index + " is out of range. It should be between 0 and " + (elements.size() - 1) + " inclusively.");
                }
                Element element = (Element)elements.get(index);
                if (null == element) throw new IllegalArgumentException(". The element with index " + index + " was not found. Check the select query expression.");
                result = asPlainText ? element.text() : element.html();
                return MacroHelper.unescapeHtml3(result);
            } else {
                result = asPlainText ? elements.text() : elements.html();
            }
            return MacroHelper.unescapeHtml3(result);
        }
        catch (ExpressionCalculationException e) {
            throw new IllegalArgumentException("parameters");
        }
    }
}

