/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Features;
import com.celestecs.expression.Operation;
import com.celestecs.expression.OperationKind;
import com.celestecs.expression.PriorityAssociation;
import com.celestecs.expression.QueryExecutor;
import com.celestecs.expression.calculators.IOperationCalculator;
import com.celestecs.expression.calculators.arrays.CalculatorIn;
import com.celestecs.expression.calculators.arrays.CalculatorMakeArray;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageData;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageDataAsHtml;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementCount;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementData;
import com.celestecs.expression.calculators.dataaccess.CalculatorGetConfluencePageElementDataAsHtml;
import com.celestecs.expression.calculators.dateandtime.CalculatorDate;
import com.celestecs.expression.calculators.dateandtime.CalculatorDateDif;
import com.celestecs.expression.calculators.dateandtime.CalculatorDateValue;
import com.celestecs.expression.calculators.dateandtime.CalculatorDay;
import com.celestecs.expression.calculators.dateandtime.CalculatorDays;
import com.celestecs.expression.calculators.dateandtime.CalculatorHour;
import com.celestecs.expression.calculators.dateandtime.CalculatorHours;
import com.celestecs.expression.calculators.dateandtime.CalculatorMinute;
import com.celestecs.expression.calculators.dateandtime.CalculatorMinutes;
import com.celestecs.expression.calculators.dateandtime.CalculatorMonth;
import com.celestecs.expression.calculators.dateandtime.CalculatorNetWorkdays;
import com.celestecs.expression.calculators.dateandtime.CalculatorNow;
import com.celestecs.expression.calculators.dateandtime.CalculatorSecond;
import com.celestecs.expression.calculators.dateandtime.CalculatorTime;
import com.celestecs.expression.calculators.dateandtime.CalculatorToday;
import com.celestecs.expression.calculators.dateandtime.CalculatorWeekDay;
import com.celestecs.expression.calculators.dateandtime.CalculatorWorkday;
import com.celestecs.expression.calculators.dateandtime.CalculatorYear;
import com.celestecs.expression.calculators.engineering.CalculatorBin2Dec;
import com.celestecs.expression.calculators.engineering.CalculatorDec2Bin;
import com.celestecs.expression.calculators.engineering.CalculatorDec2Hex;
import com.celestecs.expression.calculators.engineering.CalculatorDelta;
import com.celestecs.expression.calculators.engineering.CalculatorHex2Dec;
import com.celestecs.expression.calculators.engineering.CalculatorImReal;
import com.celestecs.expression.calculators.engineering.CalculatorImaginary;
import com.celestecs.expression.calculators.engineering.CalculatorOct2Dec;
import com.celestecs.expression.calculators.financial.CalculatorFv;
import com.celestecs.expression.calculators.financial.CalculatorIrr;
import com.celestecs.expression.calculators.financial.CalculatorMirr;
import com.celestecs.expression.calculators.financial.CalculatorNper;
import com.celestecs.expression.calculators.financial.CalculatorNpv;
import com.celestecs.expression.calculators.financial.CalculatorPmt;
import com.celestecs.expression.calculators.financial.CalculatorPpmt;
import com.celestecs.expression.calculators.financial.CalculatorPv;
import com.celestecs.expression.calculators.financial.CalculatorRate;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayExtractPath;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayGet;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayGetFirst;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayGetLast;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayLength;
import com.celestecs.expression.calculators.json.CalculatorJsonArrayToArray;
import com.celestecs.expression.calculators.json.CalculatorJsonExtractPath;
import com.celestecs.expression.calculators.logical.CalculatorAnd;
import com.celestecs.expression.calculators.logical.CalculatorFalse;
import com.celestecs.expression.calculators.logical.CalculatorIf;
import com.celestecs.expression.calculators.logical.CalculatorNot;
import com.celestecs.expression.calculators.logical.CalculatorOr;
import com.celestecs.expression.calculators.logical.CalculatorSwitch;
import com.celestecs.expression.calculators.logical.CalculatorTrue;
import com.celestecs.expression.calculators.logical.CalculatorXor;
import com.celestecs.expression.calculators.lookupandreference.CalculatorHlookup;
import com.celestecs.expression.calculators.lookupandreference.CalculatorVlookup;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorAbs;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorAcos;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorAsin;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorAtan;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorAtan2;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorCbrt;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorCeil;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorCopySign;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorCos;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorCosh;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorExp;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorExpm1;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorFloor;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorGetExponent;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorHypot;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorIEEEremainder;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorLog;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorLog10;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorLog1p;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorNextAfter;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorNextUp;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorPi;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorPow;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorRandom;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorRint;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorRound;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorScalb;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSignum;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSin;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSinh;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSqrt;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSum;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSumIf;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorSumIfs;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorTan;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorTanh;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorToDegrees;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorToRadians;
import com.celestecs.expression.calculators.mathandtrigonometry.CalculatorUlp;
import com.celestecs.expression.calculators.operators.CalculatorAddition;
import com.celestecs.expression.calculators.operators.CalculatorAmpersand;
import com.celestecs.expression.calculators.operators.CalculatorDivision;
import com.celestecs.expression.calculators.operators.CalculatorEqual;
import com.celestecs.expression.calculators.operators.CalculatorGreater;
import com.celestecs.expression.calculators.operators.CalculatorGreaterOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorLess;
import com.celestecs.expression.calculators.operators.CalculatorLessOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorMultiplication;
import com.celestecs.expression.calculators.operators.CalculatorNegation;
import com.celestecs.expression.calculators.operators.CalculatorNotEqual;
import com.celestecs.expression.calculators.operators.CalculatorPositivation;
import com.celestecs.expression.calculators.operators.CalculatorPowering;
import com.celestecs.expression.calculators.operators.CalculatorSubtraction;
import com.celestecs.expression.calculators.statistical.CalculatorAverage;
import com.celestecs.expression.calculators.statistical.CalculatorAverageIf;
import com.celestecs.expression.calculators.statistical.CalculatorAverageIfs;
import com.celestecs.expression.calculators.statistical.CalculatorCount;
import com.celestecs.expression.calculators.statistical.CalculatorCountA;
import com.celestecs.expression.calculators.statistical.CalculatorCountIf;
import com.celestecs.expression.calculators.statistical.CalculatorCountIfs;
import com.celestecs.expression.calculators.statistical.CalculatorMax;
import com.celestecs.expression.calculators.statistical.CalculatorMin;
import com.celestecs.expression.calculators.text.CalculatorChar;
import com.celestecs.expression.calculators.text.CalculatorConcat;
import com.celestecs.expression.calculators.text.CalculatorFind;
import com.celestecs.expression.calculators.text.CalculatorJoin;
import com.celestecs.expression.calculators.text.CalculatorLeft;
import com.celestecs.expression.calculators.text.CalculatorLen;
import com.celestecs.expression.calculators.text.CalculatorLower;
import com.celestecs.expression.calculators.text.CalculatorMid;
import com.celestecs.expression.calculators.text.CalculatorReplace;
import com.celestecs.expression.calculators.text.CalculatorRight;
import com.celestecs.expression.calculators.text.CalculatorSubstitute;
import com.celestecs.expression.calculators.text.CalculatorText;
import com.celestecs.expression.calculators.text.CalculatorUpper;
import com.celestecs.expression.calculators.text.CalculatorValue;
import com.celestecs.expression.calculators.workwithjira.CalculatorJiraIssueCount;
import com.celestecs.expression.calculators.workwithjira.CalculatorJiraIssueFieldValues;
import com.celestecs.expression.calculators.workwithjira.CalculatorJiraIssueFieldValuesByFieldId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;

public final class OperationsRegistry {
    private final ArrayList<Operation> operationsList = new ArrayList();
    private final HashMap<Integer, PriorityAssociation> priorityAssociationsDictionary = new HashMap();
    private final HashMap<String, Operation> operationNamesDictionary = new HashMap();
    private final HashMap<String, Collection<Operation>> operationSignaturesDictionary = new HashMap();
    private QueryExecutor jqlQueryExecutor = null;
    private char decimalSymbol;
    private String digitGroupingSymbol;
    private int[] signaturesLens;

    public boolean IsPriorityDefined(int priority) {
        return this.priorityAssociationsDictionary.containsKey(priority);
    }

    public PriorityAssociation GetAssociationByPriority(int priority) {
        if (!this.IsPriorityDefined(priority)) {
            throw new IllegalArgumentException("Specified priority is not defined.");
        }
        return this.priorityAssociationsDictionary.get(priority);
    }

    public boolean IsOperationDefined(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name");
        }
        if (name.length() == 0) {
            throw new IllegalArgumentException("String is empty in name parameter.");
        }
        return this.operationNamesDictionary.containsKey(name.toLowerCase());
    }

    public Operation GetOperationByName(String name) {
        if (!this.IsOperationDefined(name)) {
            throw new IllegalArgumentException("No operation defined with name specified.");
        }
        return this.operationNamesDictionary.get(name.toLowerCase());
    }

    public boolean IsSignatureDefined(String signature) {
        if (signature == null) {
            throw new IllegalArgumentException("signature");
        }
        if (signature.length() == 0) {
            throw new IllegalArgumentException("String is empty in signature.");
        }
        return this.operationSignaturesDictionary.containsKey(signature.toLowerCase());
    }

    public boolean IsOperatorDefined(String signature) {
        Operation operation;
        if (signature == null) {
            throw new IllegalArgumentException("signature");
        }
        if (signature.length() == 0) {
            throw new IllegalArgumentException("String is empty in signature.");
        }
        Collection<Operation> list = this.operationSignaturesDictionary.get(signature.toLowerCase());
        return null != list && !list.isEmpty() && list.iterator().hasNext() && null != (operation = list.iterator().next()) && operation.getKind() == OperationKind.Operator;
    }

    public boolean IsFunctionDefined(String signature) {
        Operation operation;
        if (signature == null) {
            throw new IllegalArgumentException("signature");
        }
        if (signature.length() == 0) {
            throw new IllegalArgumentException("String is empty in signature.");
        }
        Collection<Operation> list = this.operationSignaturesDictionary.get(signature.toLowerCase());
        return null != list && !list.isEmpty() && list.iterator().hasNext() && null != (operation = list.iterator().next()) && operation.getKind() == OperationKind.Function;
    }

    public Collection<Operation> GetOperationsUsingSignature(String signature) {
        if (!this.IsSignatureDefined(signature)) {
            throw new IllegalArgumentException("No operation uses signature specified.");
        }
        return this.operationSignaturesDictionary.get(signature.toLowerCase());
    }

    public int[] getSignaturesLens() {
        return this.signaturesLens;
    }

    private static void addOperation(ArrayList<Operation> operationsList, String operationName, int operationOperandsCount, OperationKind operationKind, int operationPriority, SerializedSignature[] signaturesList, IOperationCalculator calculator) {
        ArrayList<SerializedSignature> signaturesOrderedList = new ArrayList<SerializedSignature>();
        if (signaturesList == null) {
            throw new UnsupportedOperationException("No signatures found during parsing operation.");
        }
        for (int i = 0; i < signaturesList.length; ++i) {
            signaturesOrderedList.add(signaturesList[i]);
        }
        Collections.sort(signaturesOrderedList, new SignatureComparator());
        String[] operationSignatures = new String[signaturesOrderedList.size()];
        for (int i = 0; i < signaturesOrderedList.size(); ++i) {
            operationSignatures[i] = ((SerializedSignature)signaturesOrderedList.get(i)).getSignature();
        }
        IOperationCalculator operationCalculator = calculator;
        if (operationKind == OperationKind.Operator) {
            operationsList.add(new Operation(operationName.toLowerCase(), OperationKind.Operator, operationSignatures, operationOperandsCount, operationCalculator, operationPriority));
        } else {
            operationsList.add(new Operation(operationName.toLowerCase(), OperationKind.Function, operationSignatures, operationOperandsCount, operationCalculator));
        }
    }

    private void initializeFromConfigurationXml() {
        this.priorityAssociationsDictionary.put(1, PriorityAssociation.LeftAssociated);
        this.priorityAssociationsDictionary.put(2, PriorityAssociation.RightAssociated);
        this.priorityAssociationsDictionary.put(3, PriorityAssociation.LeftAssociated);
        this.priorityAssociationsDictionary.put(4, PriorityAssociation.LeftAssociated);
        this.priorityAssociationsDictionary.put(5, PriorityAssociation.RightAssociated);
        OperationsRegistry.addOperation(this.operationsList, "powering", 2, OperationKind.Operator, 1, new SerializedSignature[]{new SerializedSignature("^", 1)}, new CalculatorPowering(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "negation", 1, OperationKind.Operator, 2, new SerializedSignature[]{new SerializedSignature("-", 1)}, new CalculatorNegation(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "positivation", 1, OperationKind.Operator, 2, new SerializedSignature[]{new SerializedSignature("+", 1)}, new CalculatorPositivation(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "multiplication", 2, OperationKind.Operator, 3, new SerializedSignature[]{new SerializedSignature("*", 1)}, new CalculatorMultiplication(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "division", 2, OperationKind.Operator, 3, new SerializedSignature[]{new SerializedSignature("/", 1)}, new CalculatorDivision(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "addition", 2, OperationKind.Operator, 4, new SerializedSignature[]{new SerializedSignature("+", 1)}, new CalculatorAddition(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "subtraction", 2, OperationKind.Operator, 4, new SerializedSignature[]{new SerializedSignature("-", 1)}, new CalculatorSubtraction(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "sin", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("sin", 1)}, new CalculatorSin(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "cos", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("cos", 1)}, new CalculatorCos(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "abs", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("abs", 1)}, new CalculatorAbs(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "acos", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("acos", 1)}, new CalculatorAcos(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "asin", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("asin", 1)}, new CalculatorAsin(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "atan", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("atan", 1)}, new CalculatorAtan(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "atan2", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("atan2", 1)}, new CalculatorAtan2(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "cbrt", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("cbrt", 1)}, new CalculatorCbrt(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "ceil", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("ceil", 1)}, new CalculatorCeil(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "copySign", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("copySign", 1)}, new CalculatorCopySign(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "cosh", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("cosh", 1)}, new CalculatorCosh(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "exp", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("exp", 1)}, new CalculatorExp(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "expm1", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("expm1", 1)}, new CalculatorExpm1(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "floor", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("floor", 1)}, new CalculatorFloor(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "getExponent", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("getExponent", 1)}, new CalculatorGetExponent(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "hypot", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("hypot", 1)}, new CalculatorHypot(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "IEEEremainder", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("IEEEremainder", 1)}, new CalculatorIEEEremainder(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "log", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("log", 1)}, new CalculatorLog(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "log10", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("log10", 1)}, new CalculatorLog10(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "log1p", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("log1p", 1)}, new CalculatorLog1p(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "nextAfter", 2, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("nextAfter", 1)}, new CalculatorNextAfter(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "nextUp", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("nextUp", 1)}, new CalculatorNextUp(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "pow", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("pow", 1)}, new CalculatorPow(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "random", 0, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("random", 1)}, new CalculatorRandom(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "rint", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("rint", 1)}, new CalculatorRint(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "round", -1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("round", 1)}, new CalculatorRound(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "scalb", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("scalb", 1)}, new CalculatorScalb(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "signum", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("signum", 1)}, new CalculatorSignum(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "sinh", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("sinh", 1)}, new CalculatorSinh(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "sqrt", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("sqrt", 1)}, new CalculatorSqrt(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "tan", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("tan", 1)}, new CalculatorTan(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "tan", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("tan", 1)}, new CalculatorTan(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "tanh", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("tanh", 1)}, new CalculatorTanh(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "toDegrees", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("toDegrees", 1)}, new CalculatorToDegrees(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "toRadians", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("toRadians", 1)}, new CalculatorToRadians(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "ulp", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("ulp", 1)}, new CalculatorUlp(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "and", 2, OperationKind.Operator, 2, new SerializedSignature[]{new SerializedSignature("&&", 1)}, new CalculatorAnd(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "or", 2, OperationKind.Operator, 3, new SerializedSignature[]{new SerializedSignature("||", 1)}, new CalculatorOr(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "not", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("not", 1)}, new CalculatorNot(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "if", 3, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("if", 1)}, new CalculatorIf(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "sum", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("sum", 1)}, new CalculatorSum(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "average", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("average", 1)}, new CalculatorAverage(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "max", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("max", 1)}, new CalculatorMax(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "min", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("min", 1)}, new CalculatorMin(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "and", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("and", 1)}, new CalculatorAnd(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "or", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("or", 1)}, new CalculatorOr(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "xor", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("xor", 1)}, new CalculatorXor(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "CEILING", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("CEILING", 1)}, new CalculatorCeil(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "less", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature("<", 1)}, new CalculatorLess(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "greater", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature(">", 1)}, new CalculatorGreater(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "lessOrEqual", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature("<=", 1)}, new CalculatorLessOrEqual(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "greaterOrEqual", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature(">=", 1)}, new CalculatorGreaterOrEqual(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "false", 0, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("false", 1)}, new CalculatorFalse(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "true", 0, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("true", 1)}, new CalculatorTrue(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "switch", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("switch", 1)}, new CalculatorSwitch(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "len", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("len", 1)}, new CalculatorLen(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "char", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("char", 1)}, new CalculatorChar(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "concat", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("concat", 1)}, new CalculatorConcat(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "find", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("find", 1)}, new CalculatorFind(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "lower", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("lower", 1)}, new CalculatorLower(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "upper", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("upper", 1)}, new CalculatorUpper(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "value", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("value", 1)}, new CalculatorValue(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "ampersand", 2, OperationKind.Operator, 5, new SerializedSignature[]{new SerializedSignature("&", 1)}, new CalculatorAmpersand(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "NotEqual", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature("<>", 1)}, new CalculatorNotEqual(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "replace", 4, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("replace", 1)}, new CalculatorReplace(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "substitute", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("substitute", 1)}, new CalculatorSubstitute(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "text", 2, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("text", 1)}, new CalculatorText(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "now", 0, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("now", 1)}, new CalculatorNow(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "days", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("days", 1)}, new CalculatorDays(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "date", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("date", 1)}, new CalculatorDate(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "today", 0, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("today", 1)}, new CalculatorToday(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "year", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("year", 1)}, new CalculatorYear(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "month", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("month", 1)}, new CalculatorMonth(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "day", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("day", 1)}, new CalculatorDay(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "hour", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("hour", 1)}, new CalculatorHour(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "minute", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("minute", 1)}, new CalculatorMinute(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "second", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("second", 1)}, new CalculatorSecond(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "weekday", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("weekday", 1)}, new CalculatorWeekDay(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "time", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("time", 1)}, new CalculatorTime(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "vlookup", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("vlookup", 1)}, new CalculatorVlookup(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "hlookup", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("hlookup", 1)}, new CalculatorHlookup(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "datevalue", 1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("datevalue", 1)}, new CalculatorDateValue(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "equal", 2, OperationKind.Operator, 6, new SerializedSignature[]{new SerializedSignature("=", 1)}, new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "left", -1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("left", 1)}, new CalculatorLeft(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "right", -1, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("right", 1)}, new CalculatorRight(this.decimalSymbol, this.digitGroupingSymbol));
        OperationsRegistry.addOperation(this.operationsList, "mid", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("mid", 1)}, new CalculatorMid(this.decimalSymbol, this.digitGroupingSymbol));
        if (Features.FUNC_SUPPORT_FINANCIAL_1) {
            OperationsRegistry.addOperation(this.operationsList, "fv", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("fv", 1)}, new CalculatorFv(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "irr", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("irr", 1)}, new CalculatorIrr(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "mirr", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("mirr", 1)}, new CalculatorMirr(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "nper", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("nper", 1)}, new CalculatorNper(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "npv", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("npv", 1)}, new CalculatorNpv(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "pmt", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("pmt", 1)}, new CalculatorPmt(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "ppmt", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("ppmt", 1)}, new CalculatorPpmt(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "pv", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("pv", 1)}, new CalculatorPv(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "rate", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("rate", 1)}, new CalculatorRate(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_JIRA_ISSUE_COUNT) {
            OperationsRegistry.addOperation(this.operationsList, "jiraissuecount", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jiraissuecount", 1)}, new CalculatorJiraIssueCount(this, this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_ENGINEERING_1) {
            OperationsRegistry.addOperation(this.operationsList, "bin2dec", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("bin2dec", 1)}, new CalculatorBin2Dec(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "dec2bin", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("dec2bin", 1)}, new CalculatorDec2Bin(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "dec2hex", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("dec2hex", 1)}, new CalculatorDec2Hex(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "delta", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("delta", 1)}, new CalculatorDelta(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "hex2dec", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("hex2dec", 1)}, new CalculatorHex2Dec(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "imaginary", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("imaginary", 1)}, new CalculatorImaginary(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "imreal", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("imreal", 1)}, new CalculatorImReal(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "oct2dec", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("oct2dec", 1)}, new CalculatorOct2Dec(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_STATISTICAL_MORE) {
            OperationsRegistry.addOperation(this.operationsList, "count", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("count", 1)}, new CalculatorCount(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "counta", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("counta", 1)}, new CalculatorCountA(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "countif", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("countif", 1)}, new CalculatorCountIf(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "countifs", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("countifs", 1)}, new CalculatorCountIfs(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "sumif", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("sumif", 1)}, new CalculatorSumIf(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "sumifs", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("sumifs", 1)}, new CalculatorSumIfs(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "averageif", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("averageif", 1)}, new CalculatorAverageIf(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "averageifs", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("averageifs", 1)}, new CalculatorAverageIfs(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.CONSTANT_FUNCTIONS) {
            OperationsRegistry.addOperation(this.operationsList, "pi", 0, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("pi", 1)}, new CalculatorPi(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.NETWORKDAYS_FUNCTIONS_SUPPORT) {
            OperationsRegistry.addOperation(this.operationsList, "networkdays", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("networkdays", 1)}, new CalculatorNetWorkdays(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "workday", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("workday", 1)}, new CalculatorWorkday(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FIRST_DATA_ACCESS_FUNCTIONS_SUPPORT) {
            OperationsRegistry.addOperation(this.operationsList, "getconfluencepagedata", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("getconfluencepagedata", 1)}, new CalculatorGetConfluencePageData(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "getconfluencepagedataashtml", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("getconfluencepagedataashtml", 1)}, new CalculatorGetConfluencePageDataAsHtml(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "getconfluencepageelementcount", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("getconfluencepageelementcount", 1)}, new CalculatorGetConfluencePageElementCount(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "getconfluencepageelementdata", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("getconfluencepageelementdata", 1)}, new CalculatorGetConfluencePageElementData(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "getconfluencepageelementdataashtml", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("getconfluencepageelementdataashtml", 1)}, new CalculatorGetConfluencePageElementDataAsHtml(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.DATEDIF_OPERATION_SUPPORT) {
            OperationsRegistry.addOperation(this.operationsList, "datedif", 3, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("datedif", 1)}, new CalculatorDateDif(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.HOURS_AND_MINUTES_FUNC_SUPPORT) {
            OperationsRegistry.addOperation(this.operationsList, "hours", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("hours", 1)}, new CalculatorHours(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "minutes", 2, OperationKind.Function, 0, new SerializedSignature[]{new SerializedSignature("minutes", 1)}, new CalculatorMinutes(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_JIRA_ISSUE_FIELD_VALUES) {
            OperationsRegistry.addOperation(this.operationsList, "jiraissuefieldvaluesbyfieldid", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jiraissuefieldvaluesbyfieldid", 1)}, new CalculatorJiraIssueFieldValuesByFieldId(this, this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jiraissuefieldvalues", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jiraissuefieldvalues", 1)}, new CalculatorJiraIssueFieldValues(this, this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_JSON_FUNCTIONS) {
            OperationsRegistry.addOperation(this.operationsList, "jsonarraylength", 1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarraylength", 1)}, new CalculatorJsonArrayLength(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonarraygetfirst", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarraygetfirst", 1)}, new CalculatorJsonArrayGetFirst(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonarraygetlast", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarraygetlast", 1)}, new CalculatorJsonArrayGetLast(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonarrayget", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarrayget", 1)}, new CalculatorJsonArrayGet(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonextractpath", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonextractpath", 1)}, new CalculatorJsonExtractPath(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonarrayextractpath", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarrayextractpath", 1)}, new CalculatorJsonArrayExtractPath(this.decimalSymbol, this.digitGroupingSymbol));
            OperationsRegistry.addOperation(this.operationsList, "jsonarraytoarray", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("jsonarraytoarray", 1)}, new CalculatorJsonArrayToArray(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_JOIN_FUNCTION) {
            OperationsRegistry.addOperation(this.operationsList, "join", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("join", 1)}, new CalculatorJoin(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_IN_FUNCTION) {
            OperationsRegistry.addOperation(this.operationsList, "in", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("in", 1)}, new CalculatorIn(this.decimalSymbol, this.digitGroupingSymbol));
        }
        if (Features.FUNC_SUPPORT_MAKE_ARRAY_FUNCTION) {
            OperationsRegistry.addOperation(this.operationsList, "makearray", -1, OperationKind.Function, 40, new SerializedSignature[]{new SerializedSignature("makearray", 1)}, new CalculatorMakeArray(this.decimalSymbol, this.digitGroupingSymbol));
        }
    }

    public void setJqlQueryExecutor(QueryExecutor jqlQueryExecutor) {
        this.jqlQueryExecutor = jqlQueryExecutor;
    }

    public QueryExecutor getJqlQueryExecutor() {
        return this.jqlQueryExecutor;
    }

    public OperationsRegistry(char decimalSymbol, String digitGroupingSymbol) {
        this.decimalSymbol = decimalSymbol;
        this.digitGroupingSymbol = digitGroupingSymbol;
        this.initializeFromConfigurationXml();
        ArrayList<Integer> lens = new ArrayList<Integer>();
        for (Operation operation : this.operationsList) {
            this.operationNamesDictionary.put(operation.getName(), operation);
            for (String s : operation.getSignature()) {
                if (!this.operationSignaturesDictionary.containsKey(s.toLowerCase())) {
                    this.operationSignaturesDictionary.put(s.toLowerCase(), new ArrayList());
                }
                this.operationSignaturesDictionary.get(s.toLowerCase()).add(operation);
            }
            for (String s : operation.getSignature()) {
                int len = s.length();
                boolean alreadySaved = false;
                Iterator iterator = lens.iterator();
                while (iterator.hasNext()) {
                    int i = (Integer)iterator.next();
                    if (i != len) continue;
                    alreadySaved = true;
                    break;
                }
                if (alreadySaved) continue;
                lens.add(len);
            }
        }
        Collections.sort(lens);
        int size = lens.size();
        this.signaturesLens = new int[size];
        for (int i = 0; i < size; ++i) {
            this.signaturesLens[i] = (Integer)lens.get(i);
        }
    }

    public static class SignatureComparator
    implements Comparator<SerializedSignature> {
        @Override
        public int compare(SerializedSignature a, SerializedSignature b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.getNumber() > b.getNumber()) {
                return 1;
            }
            if (a.getNumber() < b.getNumber()) {
                return -1;
            }
            return 0;
        }
    }

    public static final class SerializedSignature {
        private String signature;
        private int number;

        public String getSignature() {
            return this.signature;
        }

        public int getNumber() {
            return this.number;
        }

        public static int Compare(SerializedSignature a, SerializedSignature b) {
            if (a == null) {
                if (b == null) {
                    return 0;
                }
                return -1;
            }
            if (b == null) {
                return 1;
            }
            if (a.getNumber() > b.getNumber()) {
                return 1;
            }
            if (a.getNumber() < b.getNumber()) {
                return -1;
            }
            return 0;
        }

        public static int Compare(Object a, Object b) {
            return SerializedSignature.Compare((SerializedSignature)a, (SerializedSignature)b);
        }

        public SerializedSignature(String signature, int number) {
            if (signature == null) {
                throw new IllegalArgumentException("signature");
            }
            this.signature = signature;
            this.number = number;
        }
    }
}

