/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression;

import com.celestecs.expression.Compiler;
import com.celestecs.expression.Features;
import com.celestecs.expression.Logger;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.NumericalExpressionMacroParams;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.Parser;
import com.celestecs.expression.ServletTools;
import com.celestecs.expression.TableBoundsInfo;
import com.celestecs.expression.ToolsHelper;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.BracesSyntaxException;
import com.celestecs.expression.exceptions.CompilerSyntaxException;
import com.celestecs.expression.exceptions.ExpressionCalculationException;
import com.celestecs.expression.exceptions.MathProcessorException;
import com.celestecs.expression.exceptions.NotValidVariableIdentifierException;
import com.celestecs.expression.exceptions.OperandsDisbalanceException;
import com.celestecs.expression.exceptions.TypeMismatchException;
import com.celestecs.expression.exceptions.UnexpectedItemException;
import com.celestecs.expression.exceptions.VariableNotInitializedException;
import com.celestecs.expression.expressions.CompiledExpression;
import com.celestecs.expression.expressions.PreparedExpression;
import com.celestecs.expression.expressions.PreparedExpressionItem;
import com.celestecs.expression.expressions.PreparedExpressionItemKind;
import java.io.StringWriter;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Entities;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class MacroHelper {
    public static String TRIAL_CSS_CLASS = "css-math-trial";
    public static String MATH_TRIAL_STRING = "<span class='" + TRIAL_CSS_CLASS + "' style='vertical-align: super;color: rgb(255, 0, 0)'>*</span>";
    public static String CONDITIONS_TRIAL_STRING = "<span class='" + TRIAL_CSS_CLASS + "' style='vertical-align: super;color: rgb(255, 0, 0)'>*</span>";
    public static String REPORTING_TRIAL_STRING = "<span class='" + TRIAL_CSS_CLASS + "' style='vertical-align: super;color: rgb(255, 0, 0)'>*</span>";
    private static final Logger logger = null;
    public static String UNIQUE_BRACES = ":::@@@:::";
    private static String[] formattingTags = new String[]{"h1", "h2", "h3", "h4", "h5", "h6", "b", "big", "code", "em", "font", "i", "s", "small", "strike", "strong", "tt", "u", "blockquote"};
    private static final String[][] ESCAPES = new String[][]{{"\"", "quot"}, {"&", "amp"}, {"<", "lt"}, {">", "gt"}, {"'", "apos"}, {"\u00a0", "nbsp"}, {"\u00a1", "iexcl"}, {"\u00a2", "cent"}, {"\u00a3", "pound"}, {"\u00a4", "curren"}, {"\u00a5", "yen"}, {"\u00a6", "brvbar"}, {"\u00a7", "sect"}, {"\u00a8", "uml"}, {"\u00a9", "copy"}, {"\u00aa", "ordf"}, {"\u00ab", "laquo"}, {"\u00ac", "not"}, {"\u00ad", "shy"}, {"\u00ae", "reg"}, {"\u00af", "macr"}, {"\u00b0", "deg"}, {"\u00b1", "plusmn"}, {"\u00b2", "sup2"}, {"\u00b3", "sup3"}, {"\u00b4", "acute"}, {"\u00b5", "micro"}, {"\u00b6", "para"}, {"\u00b7", "middot"}, {"\u00b8", "cedil"}, {"\u00b9", "sup1"}, {"\u00ba", "ordm"}, {"\u00bb", "raquo"}, {"\u00bc", "frac14"}, {"\u00bd", "frac12"}, {"\u00be", "frac34"}, {"\u00bf", "iquest"}, {"\u00c0", "Agrave"}, {"\u00c1", "Aacute"}, {"\u00c2", "Acirc"}, {"\u00c3", "Atilde"}, {"\u00c4", "Auml"}, {"\u00c5", "Aring"}, {"\u00c6", "AElig"}, {"\u00c7", "Ccedil"}, {"\u00c8", "Egrave"}, {"\u00c9", "Eacute"}, {"\u00ca", "Ecirc"}, {"\u00cb", "Euml"}, {"\u00cc", "Igrave"}, {"\u00cd", "Iacute"}, {"\u00ce", "Icirc"}, {"\u00cf", "Iuml"}, {"\u00d0", "ETH"}, {"\u00d1", "Ntilde"}, {"\u00d2", "Ograve"}, {"\u00d3", "Oacute"}, {"\u00d4", "Ocirc"}, {"\u00d5", "Otilde"}, {"\u00d6", "Ouml"}, {"\u00d7", "times"}, {"\u00d8", "Oslash"}, {"\u00d9", "Ugrave"}, {"\u00da", "Uacute"}, {"\u00db", "Ucirc"}, {"\u00dc", "Uuml"}, {"\u00dd", "Yacute"}, {"\u00de", "THORN"}, {"\u00df", "szlig"}, {"\u00e0", "agrave"}, {"\u00e1", "aacute"}, {"\u00e2", "acirc"}, {"\u00e3", "atilde"}, {"\u00e4", "auml"}, {"\u00e5", "aring"}, {"\u00e6", "aelig"}, {"\u00e7", "ccedil"}, {"\u00e8", "egrave"}, {"\u00e9", "eacute"}, {"\u00ea", "ecirc"}, {"\u00eb", "euml"}, {"\u00ec", "igrave"}, {"\u00ed", "iacute"}, {"\u00ee", "icirc"}, {"\u00ef", "iuml"}, {"\u00f0", "eth"}, {"\u00f1", "ntilde"}, {"\u00f2", "ograve"}, {"\u00f3", "oacute"}, {"\u00f4", "ocirc"}, {"\u00f5", "otilde"}, {"\u00f6", "ouml"}, {"\u00f7", "divide"}, {"\u00f8", "oslash"}, {"\u00f9", "ugrave"}, {"\u00fa", "uacute"}, {"\u00fb", "ucirc"}, {"\u00fc", "uuml"}, {"\u00fd", "yacute"}, {"\u00fe", "thorn"}, {"\u00ff", "yuml"}};
    private static final String[][] ESCAPES_2 = new String[][]{{"'", "apos"}, {"\"", "quot"}, {"&", "amp"}, {"<", "lt"}, {">", "gt"}, {"\u00a0", "nbsp"}, {"\u00a1", "iexcl"}, {"\u00a2", "cent"}, {"\u00a3", "pound"}, {"\u00a4", "curren"}, {"\u00a5", "yen"}, {"\u00a6", "brvbar"}, {"\u00a7", "sect"}, {"\u00a8", "uml"}, {"\u00a9", "copy"}, {"\u00aa", "ordf"}, {"\u00ab", "laquo"}, {"\u00ac", "not"}, {"\u00ad", "shy"}, {"\u00ae", "reg"}, {"\u00af", "macr"}, {"\u00b0", "deg"}, {"\u00b1", "plusmn"}, {"\u00b2", "sup2"}, {"\u00b3", "sup3"}, {"\u00b4", "acute"}, {"\u00b5", "micro"}, {"\u00b6", "para"}, {"\u00b7", "middot"}, {"\u00b8", "cedil"}, {"\u00b9", "sup1"}, {"\u00ba", "ordm"}, {"\u00bb", "raquo"}, {"\u00bc", "frac14"}, {"\u00bd", "frac12"}, {"\u00be", "frac34"}, {"\u00bf", "iquest"}, {"\u00c0", "Agrave"}, {"\u00c1", "Aacute"}, {"\u00c2", "Acirc"}, {"\u00c3", "Atilde"}, {"\u00c4", "Auml"}, {"\u00c5", "Aring"}, {"\u00c6", "AElig"}, {"\u00c7", "Ccedil"}, {"\u00c8", "Egrave"}, {"\u00c9", "Eacute"}, {"\u00ca", "Ecirc"}, {"\u00cb", "Euml"}, {"\u00cc", "Igrave"}, {"\u00cd", "Iacute"}, {"\u00ce", "Icirc"}, {"\u00cf", "Iuml"}, {"\u00d0", "ETH"}, {"\u00d1", "Ntilde"}, {"\u00d2", "Ograve"}, {"\u00d3", "Oacute"}, {"\u00d4", "Ocirc"}, {"\u00d5", "Otilde"}, {"\u00d6", "Ouml"}, {"\u00d7", "times"}, {"\u00d8", "Oslash"}, {"\u00d9", "Ugrave"}, {"\u00da", "Uacute"}, {"\u00db", "Ucirc"}, {"\u00dc", "Uuml"}, {"\u00dd", "Yacute"}, {"\u00de", "THORN"}, {"\u00df", "szlig"}, {"\u00e0", "agrave"}, {"\u00e1", "aacute"}, {"\u00e2", "acirc"}, {"\u00e3", "atilde"}, {"\u00e4", "auml"}, {"\u00e5", "aring"}, {"\u00e6", "aelig"}, {"\u00e7", "ccedil"}, {"\u00e8", "egrave"}, {"\u00e9", "eacute"}, {"\u00ea", "ecirc"}, {"\u00eb", "euml"}, {"\u00ec", "igrave"}, {"\u00ed", "iacute"}, {"\u00ee", "icirc"}, {"\u00ef", "iuml"}, {"\u00f0", "eth"}, {"\u00f1", "ntilde"}, {"\u00f2", "ograve"}, {"\u00f3", "oacute"}, {"\u00f4", "ocirc"}, {"\u00f5", "otilde"}, {"\u00f6", "ouml"}, {"\u00f7", "divide"}, {"\u00f8", "oslash"}, {"\u00f9", "ugrave"}, {"\u00fa", "uacute"}, {"\u00fb", "ucirc"}, {"\u00fc", "uuml"}, {"\u00fd", "yacute"}, {"\u00fe", "thorn"}, {"\u00ff", "yuml"}, {"\u0152", "OElig"}, {"\u0153", "oelig"}, {"\u0160", "Scaron"}, {"\u0161", "scaron"}, {"\u0178", "Yuml"}, {"\u0192", "fnof"}, {"\u02c6", "circ"}, {"\u02dc", "tilde"}, {"\u0391", "Alpha"}, {"\u0392", "Beta"}, {"\u0393", "Gamma"}, {"\u0394", "Delta"}, {"\u0395", "Epsilon"}, {"\u0396", "Zeta"}, {"\u0397", "Eta"}, {"\u0398", "Theta"}, {"\u0399", "Iota"}, {"\u039a", "Kappa"}, {"\u039b", "Lambda"}, {"\u039c", "Mu"}, {"\u039d", "Nu"}, {"\u039e", "Xi"}, {"\u039f", "Omicron"}, {"\u03a0", "Pi"}, {"\u03a1", "Rho"}, {"\u03a3", "Sigma"}, {"\u03a4", "Tau"}, {"\u03a5", "Upsilon"}, {"\u03a6", "Phi"}, {"\u03a7", "Chi"}, {"\u03a8", "Psi"}, {"\u03a9", "Omega"}, {"\u03b1", "alpha"}, {"\u03b2", "beta"}, {"\u03b3", "gamma"}, {"\u03b4", "delta"}, {"\u03b5", "epsilon"}, {"\u03b6", "zeta"}, {"\u03b7", "eta"}, {"\u03b8", "theta"}, {"\u03b9", "iota"}, {"\u03ba", "kappa"}, {"\u03bb", "lambda"}, {"\u03bc", "mu"}, {"\u03bd", "nu"}, {"\u03be", "xi"}, {"\u03bf", "omicron"}, {"\u03c0", "pi"}, {"\u03c1", "rho"}, {"\u03c2", "sigmaf"}, {"\u03c3", "sigma"}, {"\u03c4", "tau"}, {"\u03c5", "upsilon"}, {"\u03c6", "phi"}, {"\u03c7", "chi"}, {"\u03c8", "psi"}, {"\u03c9", "omega"}, {"\u03d1", "thetasym"}, {"\u03d2", "upsih"}, {"\u03d6", "piv"}, {"\u2002", "ensp"}, {"\u2003", "emsp"}, {"\u2009", "thinsp"}, {"\u200c", "zwnj"}, {"\u200d", "zwj"}, {"\u200e", "lrm"}, {"\u200f", "rlm"}, {"\u2013", "ndash"}, {"\u2014", "mdash"}, {"\u2018", "lsquo"}, {"\u2019", "rsquo"}, {"\u201a", "sbquo"}, {"\u201c", "ldquo"}, {"\u201d", "rdquo"}, {"\u201e", "bdquo"}, {"\u2020", "dagger"}, {"\u2021", "Dagger"}, {"\u2022", "bull"}, {"\u2026", "hellip"}, {"\u2030", "permil"}, {"\u2032", "prime"}, {"\u2033", "Prime"}, {"\u2039", "lsaquo"}, {"\u203a", "rsaquo"}, {"\u203e", "oline"}, {"\u2044", "frasl"}, {"\u20ac", "euro"}, {"\u2111", "image"}, {"\u2118", "weierp"}, {"\u211c", "real"}, {"\u2122", "trade"}, {"\u2135", "alefsym"}, {"\u2190", "larr"}, {"\u2191", "uarr"}, {"\u2192", "rarr"}, {"\u2193", "darr"}, {"\u2194", "harr"}, {"\u21b5", "crarr"}, {"\u21d0", "lArr"}, {"\u21d1", "uArr"}, {"\u21d2", "rArr"}, {"\u21d3", "dArr"}, {"\u21d4", "hArr"}, {"\u2200", "forall"}, {"\u2202", "part"}, {"\u2203", "exist"}, {"\u2205", "empty"}, {"\u2207", "nabla"}, {"\u2208", "isin"}, {"\u2209", "notin"}, {"\u220b", "ni"}, {"\u220f", "prod"}, {"\u2211", "sum"}, {"\u2212", "minus"}, {"\u2217", "lowast"}, {"\u221a", "radic"}, {"\u221d", "prop"}, {"\u221e", "infin"}, {"\u2220", "ang"}, {"\u2227", "and"}, {"\u2228", "or"}, {"\u2229", "cap"}, {"\u222a", "cup"}, {"\u222b", "int"}, {"\u2234", "there4"}, {"\u223c", "sim"}, {"\u2245", "cong"}, {"\u2248", "asymp"}, {"\u2260", "ne"}, {"\u2261", "equiv"}, {"\u2264", "le"}, {"\u2265", "ge"}, {"\u2282", "sub"}, {"\u2283", "sup"}, {"\u2284", "nsub"}, {"\u2286", "sube"}, {"\u2287", "supe"}, {"\u2295", "oplus"}, {"\u2297", "otimes"}, {"\u22a5", "perp"}, {"\u22c5", "sdot"}, {"\u2308", "lceil"}, {"\u2309", "rceil"}, {"\u230a", "lfloor"}, {"\u230b", "rfloor"}, {"\u2329", "lang"}, {"\u232a", "rang"}, {"\u25ca", "loz"}, {"\u2660", "spades"}, {"\u2663", "clubs"}, {"\u2665", "hearts"}, {"\u2666", "diams"}};
    private static final int MIN_ESCAPE = 2;
    private static final int MAX_ESCAPE = 6;
    private static HashMap<String, String> lookupMap = new HashMap();
    private static HashMap<String, String> backwardLookupMap = new HashMap();

    public static void Log(String str) {
        if (!Features.USE_LOGGER || null != logger) {
            // empty if block
        }
    }

    public static Map<String, String> getParamMap(Map<?, ?> objMap) {
        HashMap<String, String> strMap = new HashMap<String, String>();
        if (null == objMap) {
            return strMap;
        }
        for (Map.Entry<?, ?> thisEntry : objMap.entrySet()) {
            String strKey;
            Object objKey = thisEntry.getKey();
            Object objValue = thisEntry.getValue();
            if (null == objKey || null == (strKey = objKey.toString()) || 0 >= strKey.length()) continue;
            String strValue = "";
            if (null != objValue) {
                String[] values;
                strValue = objValue instanceof String[] ? ((values = (String[])objValue).length > 0 ? values[0] : "") : objValue.toString();
            }
            strMap.put(strKey, strValue);
        }
        return strMap;
    }

    public static int countSymbol(String str, char ch) {
        if (str == null || str.length() == 0) {
            return 0;
        }
        int counter = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (str.charAt(i) != ch) continue;
            ++counter;
        }
        return counter;
    }

    public static boolean isNumeric(Object obj, char decimalSymbol, String digitGroupingSymbol) {
        if (null == obj) {
            return false;
        }
        try {
            double d = 0.0;
            if (Features.CORRECT_NUMBER_FORMATTING) {
                if (obj instanceof Double || obj instanceof Long || obj instanceof Integer || obj instanceof Float) {
                    return true;
                }
                d = Conversion.parseDouble(obj.toString(), decimalSymbol, digitGroupingSymbol);
            } else {
                d = Double.parseDouble(obj.toString());
            }
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }

    public static boolean isArray(Object obj) {
        if (null == obj) {
            return false;
        }
        return obj.getClass().isArray();
    }

    public static String getStringParametersBraces() {
        return UNIQUE_BRACES;
    }

    public static String makeMacroDef(String name, String bodyContent, Map<String, String> parameters) {
        String paramString = "";
        if (null != parameters) {
            TreeMap<String, String> treeMap = new TreeMap<String, String>(parameters);
            paramString = ((Object)treeMap).toString();
        }
        String result = "Name:" + name + "; Body:" + bodyContent + "; Parameters:" + paramString;
        return result;
    }

    public static boolean hasFormulaAccordingToParams(String src, NumericalExpressionMacroParams param) {
        if (NumericalExpressionMacroParams.ExpressionPlacementKind.SINGLE_EXPRESSION == param.placement) {
            return true;
        }
        if (NumericalExpressionMacroParams.ExpressionPlacementKind.IN_CURLY_BRACES == param.placement && MacroHelper.hasCurlyBraces(src, param)) {
            return true;
        }
        return NumericalExpressionMacroParams.ExpressionPlacementKind.IN_SQUARE_BRACES == param.placement && MacroHelper.hasSquareBraces(src, param);
    }

    public static String getElementDelimeter(String name) {
        if (name.indexOf("!") > -1) {
            return "!";
        }
        if (name.indexOf(".") > -1) {
            return ".";
        }
        return "";
    }

    public static String GenerateSequence(int num) {
        if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && num < 0) {
            return "*";
        }
        --num;
        String str = "";
        while (true) {
            int mod = num % 26 + 65;
            char achar = (char)mod;
            str = achar + str;
            if ((num /= 26) > 0) {
                --num;
                continue;
            }
            if (num == 0) break;
        }
        return str;
    }

    private static String removeDateTimeMacroString(String content) {
        String result = "";
        if (Features.FIX_DATETIME_REPLACEMENT) {
            result = content;
            result = result.replaceAll("<time datetime=[\"]([^<]*)[\"]> <\\/time>", "$1");
            result = result.replaceAll("<time datetime=[\"]([^<]*)[\"][ ]*\\/>", "$1");
        } else {
            result = content.replaceAll("<time datetime=([^<]*)/>", "$1");
        }
        return result;
    }

    public static String getMathMacroBodyWithReplacedParam(String body) {
        int index = 0;
        int len = null != body ? body.length() : 0;
        String bodyWithParams = "";
        int previousIndex = 0;
        while (index < len) {
            String strSearchMacroStart = "ac:name=\"numerical-expression\"";
            String strSearchMacroStartCloud = "ac:name=\"numerical-expression-cloud\"";
            String strSearchMacroEnd = "</ac:structured-macro>";
            String strSearchMacroParamStart = "ac:name=\"load-macro-dynamically\"";
            String strSearchMacroParamEnd = "</ac:parameter>";
            int idxStart = Math.max(body.indexOf(strSearchMacroStart, index), body.indexOf(strSearchMacroStartCloud, index));
            if (idxStart < 0) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                break;
            }
            index = idxStart + strSearchMacroStart.length();
            int idxParamStart = body.indexOf(strSearchMacroParamStart, index);
            int idxEnd = body.indexOf(strSearchMacroEnd, index);
            if (idxEnd < 0) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                break;
            }
            if (idxParamStart > 0 && idxParamStart < idxEnd) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, idxParamStart);
                bodyWithParams = bodyWithParams + strSearchMacroParamStart;
                bodyWithParams = bodyWithParams + ">false";
                int idxParamEnd = body.indexOf(strSearchMacroParamEnd, idxParamStart);
                if (idxParamEnd < 0) {
                    bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                    break;
                }
                bodyWithParams = bodyWithParams + strSearchMacroParamEnd;
                index = previousIndex = idxParamEnd + strSearchMacroParamEnd.length();
                continue;
            }
            bodyWithParams = bodyWithParams + body.substring(previousIndex, idxEnd);
            bodyWithParams = bodyWithParams + "<ac:parameter ac:name=\"load-macro-dynamically\">false</ac:parameter>";
            if (Features.CLOUD_FIX_PAGE_ID) {
                bodyWithParams = bodyWithParams + "<ac:parameter ac:name=\"internal-page-id\">123</ac:parameter>";
            }
            bodyWithParams = bodyWithParams + strSearchMacroEnd;
            index = previousIndex = idxEnd + strSearchMacroEnd.length();
        }
        return bodyWithParams;
    }

    public static String getJiraIssuesMacroBodyWithReplacedParam(String body) {
        int index = 0;
        int len = null != body ? body.length() : 0;
        String bodyWithParams = "";
        int previousIndex = 0;
        while (index < len) {
            String strSearchMacroStart = "ac:name=\"jira\"";
            String strSearchMacroEnd = "</ac:structured-macro>";
            String strSearchMacroParamStart = "ac:name=\"renderMode\"";
            String strSearchMacroParamEnd = "</ac:parameter>";
            int idxStart = body.indexOf(strSearchMacroStart, index);
            if (idxStart < 0) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                break;
            }
            index = idxStart + strSearchMacroStart.length();
            int idxParamStart = body.indexOf(strSearchMacroParamStart, index);
            int idxEnd = body.indexOf(strSearchMacroEnd, index);
            if (idxEnd < 0) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                break;
            }
            if (idxParamStart > 0 && idxParamStart < idxEnd) {
                bodyWithParams = bodyWithParams + body.substring(previousIndex, idxParamStart);
                bodyWithParams = bodyWithParams + strSearchMacroParamStart;
                bodyWithParams = bodyWithParams + ">static";
                int idxParamEnd = body.indexOf(strSearchMacroParamEnd, idxParamStart);
                if (idxParamEnd < 0) {
                    bodyWithParams = bodyWithParams + body.substring(previousIndex, body.length());
                    break;
                }
                bodyWithParams = bodyWithParams + strSearchMacroParamEnd;
                index = previousIndex = idxParamEnd + strSearchMacroParamEnd.length();
                continue;
            }
            bodyWithParams = bodyWithParams + body.substring(previousIndex, idxEnd);
            bodyWithParams = bodyWithParams + "<ac:parameter ac:name=\"renderMode\">static</ac:parameter>";
            bodyWithParams = bodyWithParams + strSearchMacroEnd;
            index = previousIndex = idxEnd + strSearchMacroEnd.length();
        }
        return bodyWithParams;
    }

    public static String html2text(String str) {
        if (str.contains("<time datetime=")) {
            str = MacroHelper.removeDateTimeMacroString(str);
        }
        if (Features.CLOUD_FIX_TRIAL_REMOVAL) {
            str = str.replace("\"\\&quot;ccs-math-trial\"", "\"ccs-math-trial\"");
        }
        Document doc = Jsoup.parseBodyFragment(str);
        if (Features.REMOVE_TRIAL_TEXT_FROM_INTERNAL_VALUES) {
            Elements elements = doc.getElementsByClass("ccs-math-trial");
            int count = elements.size();
            for (int i = 0; i < count; ++i) {
                Element element = (Element)elements.get(i);
                if (null == element) continue;
                element.remove();
            }
        }
        String text = doc.body().text();
        text = MacroHelper.unescapeHtml3(text);
        return text;
    }

    public static String encodeTextInsideHtml(String str) {
        Document doc = Jsoup.parseBodyFragment(str);
        doc.outputSettings().escapeMode(Entities.EscapeMode.extended);
        doc.outputSettings().charset("ASCII");
        String result = doc.body().html();
        return result;
    }

    public static int getExcelColumnNumber(String column) {
        column = column.toUpperCase();
        int startI = 0;
        if (Features.FORMULA_SUPPORT_IN_CONDITIONS && column.length() > 1 && column.charAt(0) == '$') {
            ++startI;
        }
        int result = 0;
        for (int i = startI; i < column.length(); ++i) {
            result *= 26;
            result += column.charAt(i) - 65 + 1;
        }
        return result;
    }

    public static boolean hasCurlyBraces(String src, NumericalExpressionMacroParams param) {
        int firstIndex = src.indexOf("{");
        if (firstIndex < 0) {
            return false;
        }
        int secondIndex = src.indexOf("}", firstIndex);
        return secondIndex >= 0;
    }

    public static boolean hasSquareBraces(String src, NumericalExpressionMacroParams param) {
        int firstIndex = src.indexOf("[");
        if (firstIndex < 0) {
            return false;
        }
        int secondIndex = src.indexOf("]", firstIndex);
        return secondIndex >= 0;
    }

    public static void getVariableNamesFromFormula(String formula, ArrayList<VariableSpecification> variableSpecifications) {
        String elemName = "Table";
        int intElemIndex = 0;
        int intColumnIndex = 0;
        int intRowIndex = 0;
        int len = formula.length();
        int startIndex = 0;
        while (startIndex < len && (startIndex = formula.toLowerCase().indexOf(elemName.toLowerCase(), startIndex)) >= 0) {
            int varStartIndex = startIndex;
            int endIndex = formula.indexOf("!", startIndex + elemName.length());
            if (endIndex < 0) {
                endIndex = formula.indexOf(".", startIndex + elemName.length());
            }
            if (endIndex < 0) break;
            boolean res = true;
            String str = "";
            for (int i = startIndex + elemName.length(); i < endIndex; ++i) {
                if (!Character.isDigit(formula.charAt(i))) {
                    res = false;
                    break;
                }
                str = str + formula.charAt(i);
            }
            if (!res) break;
            try {
                intElemIndex = Integer.parseInt(str);
            }
            catch (Exception e) {
                break;
            }
            res = false;
            str = "";
            for (startIndex = endIndex + 1; startIndex < len && Character.isLetter(formula.charAt(startIndex)); ++startIndex) {
                str = str + formula.charAt(startIndex);
                res = true;
            }
            if (!res || (intColumnIndex = MacroHelper.getExcelColumnNumber(str)) < 0) break;
            res = false;
            str = "";
            while (startIndex < len && Character.isDigit(formula.charAt(startIndex))) {
                str = str + formula.charAt(startIndex);
                res = true;
                ++startIndex;
            }
            if (!res) break;
            try {
                intRowIndex = Integer.parseInt(str);
            }
            catch (Exception e) {
                break;
            }
            int intColumnIndex2 = -1;
            int intRowIndex2 = -1;
            if (startIndex < len && formula.charAt(startIndex) == ':') {
                ++startIndex;
                res = false;
                str = "";
                while (startIndex < len && Character.isLetter(formula.charAt(startIndex))) {
                    str = str + formula.charAt(startIndex);
                    res = true;
                    ++startIndex;
                }
                if (!res) break;
                intColumnIndex2 = MacroHelper.getExcelColumnNumber(str);
                if (intColumnIndex < 0) break;
                res = false;
                str = "";
                while (startIndex < len && Character.isDigit(formula.charAt(startIndex))) {
                    str = str + formula.charAt(startIndex);
                    res = true;
                    ++startIndex;
                }
                if (!res) break;
                try {
                    intRowIndex2 = Integer.parseInt(str);
                }
                catch (Exception e) {
                    break;
                }
            }
            String originalVarName = formula.substring(varStartIndex, startIndex);
            VariableSpecification variableSpecification = new VariableSpecification(originalVarName, elemName, intElemIndex, intColumnIndex, intRowIndex, intColumnIndex2, intRowIndex2);
            variableSpecifications.add(variableSpecification);
        }
    }

    public static int getColumnIndex(String s) {
        if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && null != s && s.startsWith("*")) {
            return -1;
        }
        int result = -1;
        Pattern p = Pattern.compile("[a-zA-Z]+");
        Matcher m = p.matcher(s);
        if (m.find()) {
            String strFound = m.group();
            result = MacroHelper.getExcelColumnNumber(strFound);
        }
        return result;
    }

    public static int getRowIndex(String s) {
        if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && null != s && s.endsWith("*")) {
            return -1;
        }
        int result = -1;
        Pattern p = Pattern.compile("[0-9]+");
        Matcher m = p.matcher(s);
        if (m.find()) {
            String strFound = m.group();
            try {
                result = Integer.parseInt(strFound);
            }
            catch (NumberFormatException e) {
                result = -1;
            }
        }
        return result;
    }

    public static String getPageIdFromVarName(String varName) {
        int idx;
        String result = "";
        if (varName.startsWith("[") && (idx = varName.lastIndexOf("]")) > 1 && idx < varName.length() - 1) {
            result = varName.substring(1, idx);
        }
        return result;
    }

    public static int getElementIndexFromVarName(String varName, String elemName, boolean bAllowAbsentElement) {
        int index2_2;
        int result = 1;
        if (Features.ANY_PAGE_AS_A_SOURCE && varName.startsWith("[")) {
            int idx = varName.lastIndexOf("]");
            if (idx > 1 && idx < varName.length() - 1) {
                varName = varName.substring(idx + 1, varName.length());
            } else {
                return -1;
            }
        }
        if (null == varName || !varName.toLowerCase().startsWith(elemName.toLowerCase())) {
            if (!Features.CURRENT_TABLE_SUPPORT || bAllowAbsentElement) {
                return 1;
            }
            return -1;
        }
        int index1 = elemName.length();
        int index2_1 = varName.indexOf(".");
        int index2 = index2_1 > (index2_2 = varName.indexOf("!")) ? index2_1 : index2_2;
        String strElemIndex = varName.substring(index1, index2);
        try {
            result = Integer.parseInt(strElemIndex);
        }
        catch (Exception e) {
            result = 1;
        }
        return result;
    }

    public static String getVarNameWithoutPageId(String varName) {
        int found;
        int startIndex = 0;
        if (Features.SPACE_AND_TITLE_FOR_SRC_PAGE && (found = varName.toLowerCase().indexOf("]Table".toLowerCase())) > -1) {
            startIndex = found + 1;
        }
        return varName.substring(startIndex);
    }

    public static int getCellColumnFromVarName(String varName) {
        if (null == varName) {
            return -1;
        }
        String explicitVarName = varName = MacroHelper.getVarNameWithoutPageId(varName);
        if (varName.contains(".")) {
            explicitVarName = varName.substring(varName.indexOf(".") + 1);
        } else if (varName.contains("!")) {
            explicitVarName = varName.substring(varName.indexOf("!") + 1);
        }
        int result = MacroHelper.getColumnIndex(explicitVarName);
        return result;
    }

    public static int getCellRowFromVarName(String varName) {
        if (null == varName) {
            return -1;
        }
        String explicitVarName = varName = MacroHelper.getVarNameWithoutPageId(varName);
        if (varName.contains(".")) {
            explicitVarName = varName.substring(varName.indexOf(".") + 1);
        } else if (varName.contains("!")) {
            explicitVarName = varName.substring(varName.indexOf("!") + 1);
        }
        int result = MacroHelper.getRowIndex(explicitVarName);
        return result;
    }

    public static void getSimpleVariableNamesFromFormula(String formula, ArrayList<VariableSpecification> variableSpecifications) {
        try {
            ArrayList<String> varNames = new ArrayList<String>();
            Pattern p1 = Pattern.compile("[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+");
            Matcher m1 = p1.matcher(formula);
            while (m1.find()) {
                String s = m1.group();
                String s1 = s.substring(0, s.indexOf(":"));
                String s2 = s.substring(s.indexOf(":") + 1);
                int intColumnIndex1 = MacroHelper.getColumnIndex(s1);
                int intRowIndex1 = MacroHelper.getRowIndex(s1);
                int intColumnIndex2 = MacroHelper.getColumnIndex(s2);
                int intRowIndex2 = MacroHelper.getRowIndex(s2);
                int intColumnIndexStart = Math.min(intColumnIndex1, intColumnIndex2);
                int intRowIndexStart = Math.min(intRowIndex1, intRowIndex2);
                int intColumnIndexFinish = Math.max(intColumnIndex1, intColumnIndex2);
                int intRowIndexFinish = Math.max(intRowIndex1, intRowIndex2);
                if (intColumnIndexStart <= -1 || intRowIndexStart <= -1 || intColumnIndexFinish <= -1 || intRowIndexFinish <= -1) continue;
                varNames.add(s1);
                varNames.add(s2);
                VariableSpecification variableSpecification = new VariableSpecification(s, "Table", -1, intColumnIndexStart, intRowIndexStart, intColumnIndexFinish, intRowIndexFinish);
                variableSpecifications.add(variableSpecification);
            }
            Pattern p = Pattern.compile("[a-zA-Z]+[0-9]+");
            Matcher m = p.matcher(formula);
            while (m.find()) {
                String s = m.group();
                if (m.end() < formula.length() && formula.charAt(m.end()) == '.') continue;
                int intColumnIndex = MacroHelper.getColumnIndex(s);
                int intRowIndex = MacroHelper.getRowIndex(s);
                if (intColumnIndex <= -1 || intRowIndex <= -1) continue;
                VariableSpecification variableSpecification = new VariableSpecification(s, "Table", -1, intColumnIndex, intRowIndex, -1, -1);
                if (MacroHelper.hasSuchString(varNames, s)) continue;
                varNames.add(s);
                variableSpecifications.add(variableSpecification);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String decodeAposEtc(String src) {
        String result = src;
        HashMap<String, String> valueMap = new HashMap<String, String>();
        valueMap.put("&lt;", "<");
        valueMap.put("&gt;", ">");
        valueMap.put("&quot;", "\"");
        valueMap.put("&amp;", "&");
        valueMap.put("&apos;", "'");
        for (Map.Entry entry : valueMap.entrySet()) {
            result = result.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return result;
    }

    public static boolean hasSuchString(List<String> strings, String s) {
        int size = strings.size();
        for (int i = 0; i < size; ++i) {
            String s2 = strings.get(i);
            if (0 != s2.compareToIgnoreCase(s)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFormattingTag(Tag tag) {
        if (tag == null) {
            return false;
        }
        for (int i = 0; i < formattingTags.length; ++i) {
            if (!tag.getName().equalsIgnoreCase(formattingTags[i])) continue;
            return true;
        }
        return false;
    }

    public static boolean hasStyleAttribute(Element lastChild) {
        if (null == lastChild) {
            return false;
        }
        return lastChild.attr("style").trim().length() > 0;
    }

    public static String applyFormattingFromHtml(String value, String htmlWithFormatting) {
        Document doc = null;
        doc = Jsoup.parseBodyFragment(htmlWithFormatting, org.jsoup.parser.Parser.xmlParser());
        Element content = doc.getElementsByTag("body").first();
        ArrayList<Element> elements = new ArrayList<Element>();
        Element lastChild = content;
        while (lastChild != null && lastChild.children() != null && lastChild.children().size() > 0) {
            if ((lastChild = (Element)lastChild.children().get(0)) == null || !MacroHelper.isFormattingTag(lastChild.tag()) && !MacroHelper.hasStyleAttribute(lastChild)) continue;
            elements.add(lastChild);
        }
        Document newDoc = doc.clone();
        newDoc.empty();
        Element html = newDoc.appendElement("html");
        html.appendElement("head");
        lastChild = html.appendElement("body");
        for (int i = 0; i < elements.size(); ++i) {
            lastChild.appendChild(((Element)elements.get(i)).clone().empty());
            lastChild = lastChild.child(0);
        }
        if (Features.ACCURATE_ESCAPING_IN_FORMATTER) {
            String uniqueText = "WERDFDBDFDDGHDFGHDFGHDFGHDFDGHDFGRTYERTYERTYERT";
            lastChild.appendText(uniqueText);
            String text = newDoc.body().html();
            text = text.replace(uniqueText, value);
            return text;
        }
        lastChild.appendText(value);
        String text = newDoc.body().html();
        return text;
    }

    public static double findNumber(String str, boolean findFirst, double defaultValue, char decimalSymbol, String digitGroupingSymbol) {
        try {
            int indexOfEqualSign = str.indexOf(61);
            if (indexOfEqualSign > -1) {
                str = str.substring(indexOfEqualSign + 1);
            }
            Pattern p = null;
            p = Features.CORRECT_NUMBER_FORMATTING ? (null != digitGroupingSymbol && 1 == digitGroupingSymbol.length() ? Pattern.compile("[-+]?(\\" + digitGroupingSymbol + "?\\d*)+(\\" + decimalSymbol + "\\d*)?") : Pattern.compile("[-+]?(\\d+(\\" + decimalSymbol + "\\d*)?|\\" + decimalSymbol + "\\d+)([eE][-+]?\\d+)?")) : Pattern.compile("[-+]?(\\d+(\\" + decimalSymbol + "\\d*)?|\\" + decimalSymbol + "\\d+)([eE][-+]?\\d+)?");
            ArrayList<String> al = new ArrayList<String>();
            Matcher m = p.matcher(str);
            while (m.find()) {
                String s = m.group();
                if (null == s || s.length() <= 0) continue;
                al.add(s);
            }
            if (al.size() < 1) {
                return defaultValue;
            }
            int resultIndex = 0;
            if (!findFirst) {
                resultIndex = al.size() - 1;
            }
            String strResult = (String)al.get(resultIndex);
            double dResult = 0.0;
            dResult = Features.CORRECT_NUMBER_FORMATTING ? Conversion.parseDouble(strResult.toString(), decimalSymbol, digitGroupingSymbol) : Double.parseDouble(strResult.replace(String.valueOf(decimalSymbol), "."));
            return dResult;
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static String format(double value, char decimalSeparator, String groupingSeparator, int decimalPlaces, boolean groupingUsed) {
        DecimalFormatSymbols separatorSymbols = new DecimalFormatSymbols(Locale.getDefault());
        separatorSymbols.setDecimalSeparator(decimalSeparator);
        if (Features.MATH_CONDITIONS_INTEGRATION && null != groupingSeparator && 1 == groupingSeparator.length()) {
            separatorSymbols.setGroupingSeparator(groupingSeparator.charAt(0));
        }
        if (Features.MATH_CONDITIONS_INTEGRATION && null != groupingSeparator && 1 == groupingSeparator.length()) {
            groupingUsed = true;
        }
        DecimalFormat newFormatter = null;
        newFormatter = new DecimalFormat("###,###.###");
        newFormatter.setDecimalFormatSymbols(separatorSymbols);
        newFormatter.setMaximumFractionDigits(decimalPlaces);
        newFormatter.setGroupingUsed(groupingUsed);
        String result = newFormatter.format(value);
        return result;
    }

    public static int findCurrentTableIndex(String sourceText, String macro_id) throws ExpressionCalculationException {
        Document doc = Jsoup.parse(sourceText, "", org.jsoup.parser.Parser.xmlParser());
        Elements elements = null;
        elements = doc.select("table");
        if (null == elements || null == macro_id || macro_id.isEmpty()) {
            return -1;
        }
        int count = elements.size();
        String tmp = "";
        for (int i = 0; i < count; ++i) {
            Element element = (Element)elements.get(i);
            String elemHtml = element.outerHtml();
            tmp = tmp + ServletTools.encode(elemHtml);
            if (null == elemHtml || !elemHtml.contains(macro_id)) continue;
            return i + 1;
        }
        return -1;
    }

    public static String findTableCellContainingMacro(String sourceText, String macro_id) throws ExpressionCalculationException {
        String cellName = "";
        if (null == macro_id || !sourceText.contains(macro_id)) {
            return "";
        }
        Document doc = Jsoup.parse(sourceText, "", org.jsoup.parser.Parser.xmlParser());
        Elements tables = null;
        tables = doc.select("table");
        if (null == tables || null == macro_id || macro_id.isEmpty()) {
            return "";
        }
        int countTables = tables.size();
        boolean foundMacro = false;
        for (int i = 0; i < countTables && !foundMacro; ++i) {
            Element table = (Element)tables.get(i);
            if (null == table) continue;
            Elements trs = null;
            trs = table.select("tr");
            if (null == trs) continue;
            int countTrs = trs.size();
            for (int j = 0; j < countTrs && !foundMacro; ++j) {
                Element tr = (Element)trs.get(j);
                if (null == tr) continue;
                Elements ths = null;
                ths = tr.select("th, td");
                if (null == ths) continue;
                int countThs = ths.size();
                for (int k = 0; k < countThs && !foundMacro; ++k) {
                    String thHtml;
                    Element th = (Element)ths.get(k);
                    if (null == th || null == (thHtml = th.outerHtml()) || !thHtml.contains(macro_id)) continue;
                    cellName = "Table" + (i + 1) + '.' + MacroHelper.GenerateSequence(k + 1).toUpperCase() + (j + 1);
                    return cellName;
                }
            }
        }
        return "";
    }

    public static Object findTableValue(String pageId, boolean previewMode, int elemIndex, int columnIndex, int rowIndex, String textToSearchVariablesFor, PageContentProvider pageContentProvider, NumericalExpressionMacroParams param, MathTextResolver i18n) throws ExpressionCalculationException {
        String varName = "";
        if (Features.ANY_PAGE_AS_A_SOURCE && null != pageId && !pageId.isEmpty()) {
            varName = varName + "[" + pageId + "]";
            textToSearchVariablesFor = pageContentProvider.getPage(pageId);
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0) {
            varName = varName + "CurrentTable." + MacroHelper.GenerateSequence(columnIndex).toUpperCase() + rowIndex;
            textToSearchVariablesFor = pageContentProvider.getOwnPage(previewMode);
        } else {
            varName = varName + "Table" + (elemIndex > -1 ? elemIndex : 1) + '.' + MacroHelper.GenerateSequence(columnIndex).toUpperCase() + rowIndex;
        }
        Document doc = Jsoup.parse(textToSearchVariablesFor, "", org.jsoup.parser.Parser.xmlParser());
        Elements elements = null;
        Element element = null;
        elements = doc.select("table");
        if (null == elements || elements.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.NoElementsOfSuchType"), "table", varName));
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0 && null != pageContentProvider && null != param && (elemIndex = pageContentProvider.getCurrentTableIndexOneBased() > 0 ? pageContentProvider.getCurrentTableIndexOneBased() : MacroHelper.findCurrentTableIndex(pageContentProvider.getOwnPageInStorageFormat(previewMode), pageContentProvider.getMacroId())) < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.CurrentTableNotFound"), varName));
        }
        if (elemIndex > 0 && elements.size() < elemIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        element = elemIndex > -1 ? (Element)elements.get(elemIndex - 1) : (Element)elements.get(0);
        if (null == element || element.text().isEmpty()) {
            if (!param.backwardCompatibilityMode) {
                return new String("");
            }
            return 0.0;
        }
        elements = element.select("tr");
        if (null == elements || elements.size() < rowIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table row", rowIndex, varName, null == elements ? 0 : elements.size()));
        }
        element = (Element)elements.get(rowIndex - 1);
        if (null == element || element.text().isEmpty()) {
            if (!param.backwardCompatibilityMode) {
                return new String("");
            }
            return 0.0;
        }
        elements = element.select("td,th");
        if (null == elements || elements.size() < columnIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table column", MacroHelper.GenerateSequence(columnIndex), varName, null == elements ? Integer.valueOf(0) : MacroHelper.GenerateSequence(elements.size())));
        }
        element = (Element)elements.get(columnIndex - 1);
        if (null == element || element.text().isEmpty()) {
            if (!param.backwardCompatibilityMode) {
                return new String("");
            }
            return 0.0;
        }
        return MacroHelper.getValueFromElement(element, pageContentProvider, param, i18n);
    }

    protected static Object getValueFromElement(Element element, PageContentProvider pageContentProvider, NumericalExpressionMacroParams param, MathTextResolver i18n) {
        String html = element.html();
        String text = null != html ? html.trim() : "";
        String bodyWithNumbers = "";
        String bodyContent = text;
        try {
            bodyWithNumbers = pageContentProvider.replaceMacroDefinitionsWithString(bodyContent);
        }
        catch (Exception e) {
            String msg = e.getMessage();
            MacroHelper.Log("Exception during looking for table value: " + msg);
        }
        String plainText = MacroHelper.html2text(bodyWithNumbers);
        Object result = null;
        if (!param.backwardCompatibilityMode) {
            result = new String(plainText);
        } else {
            double value = MacroHelper.findNumber(plainText, true, 0.0, param.decimalSymbol, param.digitGroupingSymbol);
            result = value;
        }
        return result;
    }

    public static int[] findTableRowOrColCount(String pageId, boolean previewMode, int elemIndex, int rowOrColIndex, boolean countColumns, String textToSearchVariablesFor, PageContentProvider pageContentProvider, NumericalExpressionMacroParams param, MathTextResolver i18n) throws ExpressionCalculationException {
        int[] result = new int[]{0, 0};
        String varName = "";
        if (Features.ANY_PAGE_AS_A_SOURCE && null != pageId && !pageId.isEmpty()) {
            varName = varName + "[" + pageId + "]";
            textToSearchVariablesFor = pageContentProvider.getPage(pageId);
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0) {
            varName = varName + "CurrentTable." + MacroHelper.GenerateSequence(-1).toUpperCase() + -1;
            textToSearchVariablesFor = pageContentProvider.getOwnPage(previewMode);
        } else {
            varName = varName + "Table" + (elemIndex > -1 ? elemIndex : 1) + '.' + MacroHelper.GenerateSequence(-1).toUpperCase() + -1;
        }
        Document doc = Jsoup.parse(textToSearchVariablesFor, "", org.jsoup.parser.Parser.xmlParser());
        Elements elements = null;
        Element element = null;
        elements = doc.select("table");
        if (null == elements || elements.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.NoElementsOfSuchType"), "table", varName));
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0 && null != pageContentProvider && null != param && (elemIndex = pageContentProvider.getCurrentTableIndexOneBased() > 0 ? pageContentProvider.getCurrentTableIndexOneBased() : MacroHelper.findCurrentTableIndex(pageContentProvider.getOwnPageInStorageFormat(previewMode), pageContentProvider.getMacroId())) < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.CurrentTableNotFound"), varName));
        }
        if (elemIndex > 0 && elements.size() < elemIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        element = elemIndex > -1 ? (Element)elements.get(elemIndex - 1) : (Element)elements.get(0);
        if (null == element || element.text().isEmpty()) {
            return result;
        }
        if (countColumns) {
            elements = element.select("tr");
            if (null == elements || elements.size() < rowOrColIndex) {
                return result;
            }
            element = (Element)elements.get(rowOrColIndex - 1);
            if (null == element || element.text().isEmpty()) {
                return result;
            }
            elements = element.select("td,th");
            if (null == elements || elements.size() < 1) {
                return result;
            }
            result[0] = elements.size();
            elements = element.select("td");
            if (null == elements || elements.size() < 1) {
                return result;
            }
            result[1] = elements.size();
            return result;
        }
        elements = element.select("tr");
        if (null == elements) {
            return result;
        }
        result[0] = elements.size();
        int trCount = elements.size();
        int tdCount = 0;
        for (int i = 0; i < trCount; ++i) {
            Element trElement;
            element = (Element)elements.get(i);
            Elements trElements = element.select("td,th");
            if (null == elements || elements.size() < 1 || !(trElement = (Element)trElements.get(rowOrColIndex - 1)).hasAttr("td")) continue;
            ++tdCount;
        }
        result[1] = tdCount;
        return result;
    }

    public static TableElementType[][] getTableElementTypes(String pageId, int elemIndex, PageContentProvider pageContentProvider, MathTextResolver i18n) throws ExpressionCalculationException {
        String textToSearchVariablesFor = "";
        String varName = "";
        if (Features.ANY_PAGE_AS_A_SOURCE && null != pageId && !pageId.isEmpty()) {
            varName = varName + "[" + pageId + "]";
            textToSearchVariablesFor = pageContentProvider.getPage(pageId);
        } else if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0) {
            varName = varName + "CurrentTable";
            textToSearchVariablesFor = null == pageContentProvider ? "" : pageContentProvider.getOwnPage(false);
        } else {
            textToSearchVariablesFor = pageContentProvider.getOwnPage(false);
            varName = varName + "Table" + (elemIndex > -1 ? elemIndex : 1);
        }
        Document doc = Jsoup.parse(textToSearchVariablesFor, "", org.jsoup.parser.Parser.xmlParser());
        Elements elementsTr = null;
        Elements elements = null;
        Element elemTable = null;
        elements = doc.select("table");
        if (null == elements || elements.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.NoElementsOfSuchType"), "table", varName));
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0 && null != pageContentProvider && (elemIndex = pageContentProvider.getCurrentTableIndexOneBased() > 0 ? pageContentProvider.getCurrentTableIndexOneBased() : MacroHelper.findCurrentTableIndex(pageContentProvider.getOwnPageInStorageFormat(false), pageContentProvider.getMacroId())) < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.CurrentTableNotFound"), varName));
        }
        if (elemIndex > 0 && elements.size() < elemIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        elemTable = elemIndex > -1 ? (Element)elements.get(elemIndex - 1) : (Element)elements.get(0);
        if (null == elemTable || elemTable.text().isEmpty()) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        elementsTr = elemTable.select("tr");
        if (null == elementsTr || elementsTr.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        int rowCount = elementsTr.size();
        int colCount = 0;
        for (int i = 0; i < rowCount; ++i) {
            Element elementTr = (Element)elementsTr.get(i);
            if (null == elementTr || null == (elements = elementTr.select("td,th")) || 0 == elements.size()) continue;
            colCount = Math.max(colCount, elements.size());
        }
        if (rowCount < 1 || colCount < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        TableElementType[][] result = new TableElementType[rowCount][colCount];
        for (int i = 0; i < rowCount; ++i) {
            for (int j = 0; j < colCount; ++j) {
                result[i][j] = TableElementType.Empty;
            }
        }
        elementsTr = elemTable.select("tr");
        int currRowCount = elementsTr.size();
        int currColCount = 0;
        for (int i = 0; i < currRowCount; ++i) {
            Element elementTr = (Element)elementsTr.get(i);
            if (null == elementTr || null == (elements = elementTr.select("td,th")) || 0 == elements.size()) continue;
            currColCount = elements.size();
            for (int j = 0; j < currColCount; ++j) {
                Element elementTdTh = (Element)elements.get(j);
                if (null == elementTdTh) continue;
                String tag = elementTdTh.tagName();
                if (null != tag && tag.equalsIgnoreCase("td")) {
                    result[i][j] = TableElementType.Td;
                    continue;
                }
                if (null == tag || !tag.equalsIgnoreCase("th")) continue;
                result[i][j] = TableElementType.Th;
            }
        }
        return result;
    }

    public static TableBoundsInfo findTableBounds(String pageId, int elemIndex, String textToSearchVariablesFor, PageContentProvider pageContentProvider, NumericalExpressionMacroParams param, MathTextResolver i18n) throws ExpressionCalculationException {
        String varName = "";
        if (Features.ANY_PAGE_AS_A_SOURCE && null != pageId && !pageId.isEmpty()) {
            varName = varName + "[" + pageId + "]";
            textToSearchVariablesFor = pageContentProvider.getPage(pageId);
        } else if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0) {
            varName = varName + "CurrentTable";
            textToSearchVariablesFor = null == pageContentProvider ? "" : pageContentProvider.getOwnPage(false);
        } else {
            textToSearchVariablesFor = pageContentProvider.getOwnPage(false);
            varName = varName + "Table" + (elemIndex > -1 ? elemIndex : 1);
        }
        Document doc = Jsoup.parse(textToSearchVariablesFor, "", org.jsoup.parser.Parser.xmlParser());
        Elements elementsTr = null;
        Elements elements = null;
        Element element = null;
        elements = doc.select("table");
        if (null == elements || elements.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.NoElementsOfSuchType"), "table", varName));
        }
        if (Features.CURRENT_TABLE_SUPPORT && elemIndex == 0 && null != pageContentProvider && null != param && (elemIndex = pageContentProvider.getCurrentTableIndexOneBased() > 0 ? pageContentProvider.getCurrentTableIndexOneBased() : MacroHelper.findCurrentTableIndex(pageContentProvider.getOwnPageInStorageFormat(false), pageContentProvider.getMacroId())) < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.CurrentTableNotFound"), varName));
        }
        if (elemIndex > 0 && elements.size() < elemIndex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        element = elemIndex > -1 ? (Element)elements.get(elemIndex - 1) : (Element)elements.get(0);
        if (null == element || element.text().isEmpty()) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        elementsTr = element.select("tr");
        if (null == elementsTr || elementsTr.size() < 1) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        boolean bFirstRowIsHeader = false;
        boolean bFirstColumnIsHeader = false;
        int rowCount = -1;
        int colCount = -1;
        rowCount = elementsTr.size();
        element = (Element)elementsTr.get(0);
        if (null == element || element.text().isEmpty()) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
        }
        elements = element.select("td");
        if (null != elements && 0 != elements.size()) {
            bFirstRowIsHeader = true;
        }
        if (bFirstRowIsHeader && elementsTr.size() == 1) {
            bFirstColumnIsHeader = true;
        }
        if (bFirstRowIsHeader && elementsTr.size() > 1) {
            element = (Element)elementsTr.get(1);
            Elements elements2 = elements = null == element ? null : element.select("th");
            if (null != elements && elements.size() > 0) {
                bFirstColumnIsHeader = true;
            }
            Elements elements3 = elements = null == element ? null : element.select("td, th");
            if (null == elements || elements.size() < 1) {
                throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
            }
            colCount = elements.size();
        } else {
            element = (Element)elementsTr.get(0);
            elements = element.select("td, th");
            if (null == elements || elements.size() < 1) {
                throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TableIndexOutOfBounds"), "table", elemIndex, varName, null == elements ? 0 : elements.size()));
            }
            colCount = elements.size();
        }
        TableBoundsInfo result = new TableBoundsInfo(bFirstColumnIsHeader ? 1 : 0, bFirstRowIsHeader ? 1 : 0, colCount, rowCount);
        return result;
    }

    public static boolean containsRangeValue(String string, boolean forConditions) {
        if (string == null) {
            throw new IllegalArgumentException("string");
        }
        if (string.length() == 0) {
            return false;
        }
        if (!(Character.isLetter(string.charAt(0)) || Features.ANY_PAGE_AS_A_SOURCE && string.charAt(0) == '[' || Features.FORMULA_SUPPORT_IN_CONDITIONS && string.charAt(0) == '$')) {
            return false;
        }
        String[] patterns = null;
        patterns = !Features.FORMULA_SUPPORT_IN_CONDITIONS || !forConditions ? new String[]{"[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+", "Table[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+", "CurrentTable[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+", "\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+", "\\x5B.+\\x5DTable[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+", "Table[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+", "Table[0-9]+[.!][0-9]+:[0-9]+", "CurrentTable[.!][a-zA-Z]+:[a-zA-Z]+", "CurrentTable[.!][0-9]+:[0-9]+", "\\x5B[0-9]+\\x5DTable[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+", "\\x5B[0-9]+\\x5DTable[0-9]+[.!][0-9]+:[0-9]+"} : new String[]{"\\$[a-zA-Z]+\\$[0-9]+:\\$[a-zA-Z]+\\$[0-9]+"};
        for (int i = 0; i < patterns.length; ++i) {
            String s;
            Pattern p = Pattern.compile(patterns[i], 2);
            Matcher m = p.matcher(string);
            if (!m.find() || null == (s = m.group()) || 0 != s.compareTo(string)) continue;
            return true;
        }
        return false;
    }

    public static VariableValue[] readAllVariablesFromMacroBody(String bodyWithNumbers, NumericalExpressionMacroParams param, boolean previewMode, PageContentProvider pageContentProvider, MathTextResolver mathTextResolver) throws Exception, ExpressionCalculationException {
        ArrayList<VariableValue> result = new ArrayList<VariableValue>();
        if (param.placement == NumericalExpressionMacroParams.ExpressionPlacementKind.SINGLE_EXPRESSION) {
            String formula = MacroHelper.html2text(bodyWithNumbers);
            if (formula != null && formula.trim().length() > 0) {
                ArrayList<VariableValue> variables = new ArrayList<VariableValue>();
                MacroHelper.findVariables(formula, previewMode, bodyWithNumbers, pageContentProvider, param, variables, mathTextResolver, false);
                result.addAll(variables);
            }
        } else {
            int foundOpen;
            int countClose;
            int formulaCounter = 0;
            char braceOpen = param.getOpenBrace();
            char braceClose = param.getCloseBrace();
            int countOpen = MacroHelper.countSymbol(bodyWithNumbers, braceOpen);
            if (countOpen != (countClose = MacroHelper.countSymbol(bodyWithNumbers, braceClose))) {
                String errMsg = countOpen > countClose ? "com.celestecs.confluence.math.numerical-expression.error.NotAllOpeningBracesHaveAppropriateClosingBrace" : "com.celestecs.confluence.math.numerical-expression.error.NotAllClosingBracesHaveAppropriateOpeningBrace";
                throw new Exception(String.format(mathTextResolver.getText(errMsg), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
            }
            int index = 0;
            while (index < bodyWithNumbers.length() && (foundOpen = bodyWithNumbers.indexOf(braceOpen, index)) >= 0) {
                int foundClose;
                int currentSearchStart = foundOpen;
                if (Features.ANY_PAGE_AS_A_SOURCE) {
                    int foundClosePageBrace;
                    int foundOpenPageBrace;
                    int index2 = currentSearchStart + 1;
                    while (index2 < bodyWithNumbers.length() && (foundOpenPageBrace = bodyWithNumbers.indexOf("[", index2)) >= 0 && (foundClosePageBrace = bodyWithNumbers.indexOf("]Table", index2 + 1)) >= 1) {
                        if (foundOpenPageBrace < foundClosePageBrace) {
                            currentSearchStart = index2 = foundClosePageBrace + "]Table".length();
                            continue;
                        }
                        throw new Exception(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NextOpeningBraceBeforePreviousClosing"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                    }
                }
                if ((foundClose = bodyWithNumbers.indexOf(braceClose, currentSearchStart + 1)) < 1) break;
                int nextFindOpen = bodyWithNumbers.indexOf(braceOpen, currentSearchStart + 1);
                if (nextFindOpen > -1 && nextFindOpen < foundClose) {
                    throw new Exception(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NextOpeningBraceBeforePreviousClosing"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
                }
                String formula = MacroHelper.html2text(bodyWithNumbers.substring(foundOpen + 1, foundClose));
                if (formula != null && formula.trim().length() > 0) {
                    ArrayList<VariableValue> variables = new ArrayList<VariableValue>();
                    MacroHelper.findVariables(formula, previewMode, bodyWithNumbers, pageContentProvider, param, variables, mathTextResolver, false);
                    result.addAll(variables);
                    ++formulaCounter;
                }
                index = foundClose + 1;
            }
            if (formulaCounter == 0) {
                throw new Exception(String.format(mathTextResolver.getText("com.celestecs.confluence.math.numerical-expression.error.NoExpressionWasFound"), Character.valueOf(braceOpen), Character.valueOf(braceClose)));
            }
        }
        return result.toArray(new VariableValue[0]);
    }

    public static void findVariables(String formula, boolean previewMode, String textToSearchVariablesFor, PageContentProvider pageContentProvider, NumericalExpressionMacroParams param, ArrayList<VariableValue> variables, MathTextResolver i18n, boolean readVarValues) throws ExpressionCalculationException {
        MacroHelper.Log("Parsing formula: " + formula);
        PreparedExpression expr = null;
        Parser p = ToolsHelper.getParser(param.decimalSymbol, param.digitGroupingSymbol);
        expr = p.Parse(formula, false, false, param.decimalSymbol, param.digitGroupingSymbol);
        int elemCount = null == expr.getPreparedExpressionItems() ? 0 : expr.getPreparedExpressionItems().size();
        for (int l = 0; l < elemCount; ++l) {
            String[][] varNames;
            PreparedExpressionItem item = expr.getPreparedExpressionItems().get(l);
            if (null == item || item.getKind() != PreparedExpressionItemKind.Variable) continue;
            String varName = item.getVariableName();
            if (MacroHelper.containsRangeValue(varName, false)) {
                varNames = Compiler.rangeToVarNamesAsArray(item.getVariableName(), pageContentProvider, i18n);
                int rowCount = varNames.length;
                int colCount = varNames[0].length;
                if (Features.WHOLE_ROW_AND_COLUMN_RANGE_SUPPORT && readVarValues && varNames[0][0].endsWith("*")) {
                    colCount = varNames[0].length;
                }
                VariableValue[][] varValues = new VariableValue[rowCount][colCount];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        VariableValue var;
                        int elemIndex = -1;
                        String name = varNames[i][j];
                        if (null == name || 0 == name.length()) {
                            varValues[i][j] = null;
                            continue;
                        }
                        String pageId = "";
                        if (Features.ANY_PAGE_AS_A_SOURCE) {
                            pageId = MacroHelper.getPageIdFromVarName(name);
                        }
                        if (Features.CURRENT_TABLE_SUPPORT && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                            elemIndex = 0;
                        }
                        if (elemIndex < 0) {
                            elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                        }
                        int colIndex = MacroHelper.getCellColumnFromVarName(name);
                        int rowIndex = MacroHelper.getCellRowFromVarName(name);
                        Object value = null;
                        if (readVarValues) {
                            value = MacroHelper.findTableValue(pageId, previewMode, elemIndex, colIndex, rowIndex, textToSearchVariablesFor, pageContentProvider, param, i18n);
                        }
                        varValues[i][j] = var = new VariableValue(name, value);
                        variables.add(var);
                    }
                }
                continue;
            }
            varNames = Compiler.rangeToVarNames(item.getVariableName());
            int varNamesCount = varNames.size();
            for (int k = 0; k < varNamesCount; ++k) {
                String name = (String)varNames.get(k);
                String pageId = "";
                if (Features.ANY_PAGE_AS_A_SOURCE) {
                    pageId = MacroHelper.getPageIdFromVarName(name);
                }
                int elemIndex = -1;
                if (Features.CURRENT_TABLE_SUPPORT && name.contains("CurrentTable") && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                    elemIndex = 0;
                }
                if (elemIndex < 0) {
                    elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                }
                int colIndex = MacroHelper.getCellColumnFromVarName(name);
                int rowIndex = MacroHelper.getCellRowFromVarName(name);
                Object value = null;
                if (readVarValues) {
                    value = MacroHelper.findTableValue(pageId, previewMode, elemIndex, colIndex, rowIndex, textToSearchVariablesFor, pageContentProvider, param, i18n);
                }
                VariableValue var = new VariableValue(name, value);
                variables.add(var);
                MacroHelper.Log("Found value: " + var.getVariableName() + "=" + (null == var.getValue() ? "Empty" : var.getValue().toString()));
            }
        }
    }

    public static void findVariablesForConditions(String formula, String textToSearchVariablesFor, PageContentProvider pageContentProvider, ArrayList<VariableValue> variables, MathTextResolver i18n, char decimalSymbol, String digitGroupingSymbol) throws ExpressionCalculationException {
        MacroHelper.Log("Parsing conditions formula: " + formula);
        PreparedExpression expr = null;
        Parser p = ToolsHelper.getParser(decimalSymbol, digitGroupingSymbol);
        expr = p.Parse(formula, true, false, decimalSymbol, digitGroupingSymbol);
        int elemCount = null == expr.getPreparedExpressionItems() ? 0 : expr.getPreparedExpressionItems().size();
        for (int l = 0; l < elemCount; ++l) {
            String[][] varNames;
            PreparedExpressionItem item = expr.getPreparedExpressionItems().get(l);
            if (null == item || item.getKind() != PreparedExpressionItemKind.Variable) continue;
            String varName = item.getVariableName();
            long f = 10L;
            if (MacroHelper.containsRangeValue(varName, true)) {
                varNames = Compiler.rangeToVarNamesAsArray(item.getVariableName(), pageContentProvider, i18n);
                int rowCount = varNames.length;
                int colCount = varNames[0].length;
                VariableValue[][] varValues = new VariableValue[rowCount][colCount];
                for (int i = 0; i < rowCount; ++i) {
                    for (int j = 0; j < colCount; ++j) {
                        VariableValue var;
                        int elemIndex = -1;
                        String name = varNames[i][j];
                        if (null == name || 0 == name.length()) {
                            varValues[i][j] = null;
                            continue;
                        }
                        String pageId = "";
                        if (Features.ANY_PAGE_AS_A_SOURCE) {
                            pageId = MacroHelper.getPageIdFromVarName(name);
                        }
                        if (Features.CURRENT_TABLE_SUPPORT && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                            elemIndex = 0;
                        }
                        if (elemIndex < 0) {
                            elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                        }
                        int colIndex = MacroHelper.getCellColumnFromVarName(name);
                        int rowIndex = MacroHelper.getCellRowFromVarName(name);
                        Object value = null;
                        varValues[i][j] = var = new VariableValue(name, value);
                        variables.add(var);
                        MacroHelper.Log("Found range value: " + var.getVariableName() + "=" + (null == var.getValue() ? "Empty" : var.getValue().toString()));
                    }
                }
                continue;
            }
            varNames = Compiler.rangeToVarNames(item.getVariableName());
            int varNamesCount = varNames.size();
            for (int k = 0; k < varNamesCount; ++k) {
                String name = (String)varNames.get(k);
                String pageId = "";
                if (Features.ANY_PAGE_AS_A_SOURCE) {
                    pageId = MacroHelper.getPageIdFromVarName(name);
                }
                int elemIndex = -1;
                if (Features.CURRENT_TABLE_SUPPORT && name.contains("CurrentTable") && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                    elemIndex = 0;
                }
                if (elemIndex < 0) {
                    elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                }
                int colIndex = MacroHelper.getCellColumnFromVarName(name);
                int rowIndex = MacroHelper.getCellRowFromVarName(name);
                Object value = null;
                VariableValue var = new VariableValue(name, value);
                variables.add(var);
                MacroHelper.Log("Found value: " + var.getVariableName() + "=" + (null == var.getValue() ? "Empty" : var.getValue().toString()));
            }
        }
    }

    public static void findVariablesForReporting(String formula, String textToSearchVariablesFor, PageContentProvider pageContentProvider, ArrayList<VariableValue> variables, MathTextResolver i18n, char decimalSymbol, String digitGroupingSymbol) throws ExpressionCalculationException {
        MacroHelper.Log("Parsing conditions formula: " + formula);
        PreparedExpression expr = null;
        Parser p = ToolsHelper.getParser(decimalSymbol, digitGroupingSymbol);
        expr = p.Parse(formula, false, true, decimalSymbol, digitGroupingSymbol);
        int elemCount = null == expr.getPreparedExpressionItems() ? 0 : expr.getPreparedExpressionItems().size();
        for (int l = 0; l < elemCount; ++l) {
            PreparedExpressionItem item = expr.getPreparedExpressionItems().get(l);
            if (null == item || item.getKind() != PreparedExpressionItemKind.Variable) continue;
            String varName = item.getVariableName();
            long f = 10L;
            List<String> varNames = Compiler.rangeToVarNames(item.getVariableName());
            int varNamesCount = varNames.size();
            for (int k = 0; k < varNamesCount; ++k) {
                String name = varNames.get(k);
                String pageId = "";
                if (Features.ANY_PAGE_AS_A_SOURCE) {
                    pageId = MacroHelper.getPageIdFromVarName(name);
                }
                int elemIndex = -1;
                if (Features.CURRENT_TABLE_SUPPORT && name.contains("CurrentTable") && (elemIndex = MacroHelper.getElementIndexFromVarName(name, "CurrentTable", false)) == 1) {
                    elemIndex = 0;
                }
                if (elemIndex < 0) {
                    elemIndex = MacroHelper.getElementIndexFromVarName(name, "Table", true);
                }
                int colIndex = MacroHelper.getCellColumnFromVarName(name);
                int rowIndex = MacroHelper.getCellRowFromVarName(name);
                Object value = null;
                VariableValue var = new VariableValue(name, value);
                variables.add(var);
                MacroHelper.Log("Found value: " + var.getVariableName() + "=" + (null == var.getValue() ? "Empty" : var.getValue().toString()));
            }
        }
    }

    public static boolean containsSpaceKey(String pageId) {
        String s;
        String pattern = "[0-9a-zA-Z]+:.+";
        Pattern p = Pattern.compile(pattern, 2);
        Matcher m = p.matcher(pageId);
        return m.find() && null != (s = m.group()) && 0 == s.compareTo(pageId);
    }

    public static Object calculate(String str, ArrayList<VariableValue> variables, NumericalExpressionMacroParams params, PageContentProvider pageContentProvider, MathTextResolver i18n, boolean allowDollarSigns, boolean allowReportingVariablesOnly, char decimalSymbol, String digitGroupingSymbol) throws ExpressionCalculationException {
        Object objResult = null;
        try {
            PreparedExpression preparedExpression = null;
            preparedExpression = ToolsHelper.getParser(decimalSymbol, digitGroupingSymbol).Parse(str.trim(), allowDollarSigns, allowReportingVariablesOnly, decimalSymbol, digitGroupingSymbol);
            CompiledExpression compiledExpression = ToolsHelper.getCompiler(decimalSymbol, digitGroupingSymbol).Compile(preparedExpression);
            objResult = ToolsHelper.getCalculator(decimalSymbol, digitGroupingSymbol).Calculate(compiledExpression, variables, pageContentProvider, i18n);
            objResult = Conversion.sanitizeFromVariableValue(objResult);
        }
        catch (TypeMismatchException ex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.TypeMismatchException"), str));
        }
        catch (VariableNotInitializedException ex) {
            if (null != params && NumericalExpressionMacroParams.OuterValuesSource.MACRO_BODY == params.outerValuesSource) {
                throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.VariableNotInitializedChecksource"), str, ex.getMessage()));
            }
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.VariableNotInitializedException"), str, ex.getMessage()));
        }
        catch (NotValidVariableIdentifierException ex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.NotValidVariableIdentifierException"), str, ex.getMessage()));
        }
        catch (UnexpectedItemException ex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.UnexpectedItemException"), str));
        }
        catch (BracesSyntaxException ex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.BracesSyntaxException"), str));
        }
        catch (OperandsDisbalanceException ex) {
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.OperandsDisbalanceException"), str));
        }
        catch (CalculatorException ex) {
            throw new ExpressionCalculationException(ex.getMessage());
        }
        catch (CompilerSyntaxException ex) {
            MacroHelper.Log("Compiler syntax error: " + ex.getMessage());
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.CompilerSyntaxException"), str) + " " + ex.getMessage());
        }
        catch (MathProcessorException ex) {
            String strMessage = String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.MathProcessorException"), str);
            if (null != ex.getMessage()) {
                strMessage = strMessage + ". Error message: '" + ex.getMessage() + "'";
            }
            if (null != ex.getClass()) {
                strMessage = strMessage + ". Exception type: '" + ex.getClass().toString() + "'";
            }
            if (null != ex.getCause() && null != ex.getCause().getClass()) {
                strMessage = strMessage + ". Cause: '" + ex.getCause().getClass().toString() + "'";
            }
            throw new ExpressionCalculationException(strMessage);
        }
        catch (IllegalArgumentException ex) {
            MacroHelper.Log("Error in input data.");
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.IllegalArgumentException"), str) + " " + ex.getMessage());
        }
        catch (UnsupportedOperationException ex) {
            MacroHelper.Log("Unsupported Operation Exception.");
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.UnsupportedOperationException"), str));
        }
        catch (Exception ex) {
            MacroHelper.Log("Unexpected exception.");
            throw new ExpressionCalculationException(String.format(i18n.getText("com.celestecs.confluence.math.numerical-expression.error.UnexpectedCalculationException"), str) + " " + ex.getMessage());
        }
        return objResult;
    }

    public static String unescapeHtml3(String input) {
        if (Features.BETTER_HTML2TEXT_CONVERSION) {
            input = input.replace("&amp;", "&");
            for (Map.Entry<String, String> entry : lookupMap.entrySet()) {
                input = input.replace("&" + entry.getKey() + ";", entry.getValue());
            }
        }
        StringWriter writer = null;
        int len = input.length();
        int i = 1;
        int st = 0;
        while (true) {
            int j;
            block16: {
                if (i < len && input.charAt(i - 1) != '&') {
                    ++i;
                    continue;
                }
                if (i >= len) break;
                for (j = i; j < len && j < i + 6 + 1 && input.charAt(j) != ';'; ++j) {
                }
                if (j == len || j < i + 2 || j == i + 6 + 1) {
                    ++i;
                    continue;
                }
                if (input.charAt(i) == '#') {
                    int k = i + 1;
                    int radix = 10;
                    char firstChar = input.charAt(k);
                    if (firstChar == 'x' || firstChar == 'X') {
                        ++k;
                        radix = 16;
                    }
                    try {
                        int entityValue = Integer.parseInt(input.substring(k, j), radix);
                        if (writer == null) {
                            writer = new StringWriter(input.length());
                        }
                        writer.append(input.substring(st, i - 1));
                        if (entityValue > 65535) {
                            char[] chrs = Character.toChars(entityValue);
                            writer.write(chrs[0]);
                            writer.write(chrs[1]);
                        } else {
                            writer.write(entityValue);
                        }
                        break block16;
                    }
                    catch (NumberFormatException ex) {
                        ++i;
                        continue;
                    }
                }
                CharSequence value = lookupMap.get(input.substring(i, j));
                if (value == null) {
                    ++i;
                    continue;
                }
                if (writer == null) {
                    writer = new StringWriter(input.length());
                }
                writer.append(input.substring(st, i - 1));
                writer.append(value);
            }
            i = st = j + 1;
        }
        if (writer != null) {
            writer.append(input.substring(st, len));
            return writer.toString();
        }
        return input;
    }

    public static String escapeToHtml3(String input) {
        if (Features.BETTER_TO_HTML3_ESCAPER) {
            String result = "";
            int len = null == input ? 0 : input.length();
            for (int i = 0; i < len; ++i) {
                String nthSymbol = input.substring(i, i + 1);
                String mappedSymbol = backwardLookupMap.get(nthSymbol);
                result = null != mappedSymbol ? result + "&" + mappedSymbol + ";" : result + nthSymbol;
            }
            return result;
        }
        input = input.replace("&", "&amp;");
        for (Map.Entry<String, String> entry : lookupMap.entrySet()) {
            input = input.replace(entry.getValue(), "&" + entry.getKey() + ";");
        }
        return input;
    }

    static {
        if (Features.NEW_URL_ENCODE_SET) {
            for (String[] seq : ESCAPES_2) {
                lookupMap.put(seq[1].toString(), seq[0].toString());
                backwardLookupMap.put(seq[0].toString(), seq[1].toString());
            }
        } else {
            for (String[] seq : ESCAPES) {
                lookupMap.put(seq[1].toString(), seq[0]);
            }
        }
    }

    public static class VariableSpecification {
        public String variableName;
        public String elemName = "";
        public int elemIndex = -1;
        public int columnIndex = -1;
        public int rowIndex = -1;
        public int columnIndex2 = -1;
        public int rowIndex2 = -1;

        public VariableSpecification(String variableName, String elemName, int elemIndex, int columnIndex, int rowIndex, int columnIndex2, int rowIndex2) {
            this.variableName = variableName;
            this.elemName = elemName;
            this.elemIndex = elemIndex;
            this.columnIndex = columnIndex;
            this.rowIndex = rowIndex;
            this.columnIndex2 = columnIndex2;
            this.rowIndex2 = rowIndex2;
        }
    }

    public static enum TableElementType {
        Empty,
        Th,
        Td;

    }
}

