/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.confluence.conditions;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.content.render.xhtml.XhtmlException;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.Format;
import com.atlassian.confluence.content.render.xhtml.macro.annotation.RequiresFormat;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.confluence.pages.Page;
import com.atlassian.confluence.pages.PageManager;
import com.atlassian.confluence.security.Permission;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.confluence.xhtml.api.MacroDefinition;
import com.atlassian.confluence.xhtml.api.MacroDefinitionReplacer;
import com.atlassian.confluence.xhtml.api.XhtmlContent;
import com.atlassian.license.LicenseManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.LicenseError;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.celestecs.conditionalrules.Conditional2ColorScale;
import com.celestecs.conditionalrules.Conditional2ColorScaleMacroParams;
import com.celestecs.conditionalrules.ConditionalRule;
import com.celestecs.conditionalrules.ConditionalRuleMacroParams;
import com.celestecs.conditionalrules.ConditionalRulesManagerMacroParams;
import com.celestecs.conditionalrules.HtmlTools;
import com.celestecs.conditionalrules.IConditionalRule;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import java.util.ArrayList;
import java.util.Map;

public class ConditionalRulesManagerMacro
implements Macro {
    private final XhtmlContent xhtmlUtils;
    private final I18nResolver i18n;
    protected final PluginLicenseManager licenseManager;
    protected final UserAccessor userAccessor;
    protected final PageManager pageManager;
    protected final PermissionManager permissionManager;
    protected String DUMMY_BODY = "    <p class=\"auto-cursor-target\">\r\n      <ac:structured-macro ac:macro-id=\"05eafe11-0fe4-43cb-b1cc-c2bcd8cf25d6\" ac:name=\"conditional-rule\" ac:schema-version=\"1\">\r\n        <ac:parameter ac:name=\"background-color\">Red</ac:parameter>\r\n        <ac:parameter ac:name=\"value-1\">High</ac:parameter>\r\n      </ac:structured-macro>\r\n    </p>\r\n    <p class=\"auto-cursor-target\">\r\n      <ac:structured-macro ac:macro-id=\"81fa1c70-54f3-4e9b-8c83-442056aac2c2\" ac:name=\"conditional-rule\" ac:schema-version=\"1\">\r\n        <ac:parameter ac:name=\"background-color\">Yellow</ac:parameter>\r\n        <ac:parameter ac:name=\"value-1\">Medium</ac:parameter>\r\n      </ac:structured-macro>\r\n    </p>\r\n    <p class=\"auto-cursor-target\">\r\n      <ac:structured-macro ac:macro-id=\"ed15c09f-76b2-4b1a-a968-6fbe79977e42\" ac:name=\"conditional-rule\" ac:schema-version=\"1\">\r\n        <ac:parameter ac:name=\"background-color\">Green</ac:parameter>\r\n        <ac:parameter ac:name=\"value-1\">Low</ac:parameter>\r\n      </ac:structured-macro>\r\n    </p>\r\n    <p class=\"auto-cursor-target\">\r\n      <br/>\r\n    </p>\r\n    <table>\r\n      <colgroup> <col style=\"width: 1038.0px;\"/> <col style=\"width: 85.0px;\"/> <col style=\"width: 96.0px;\"/> <col style=\"width: 140.0px;\"/> </colgroup>\r\n      <tbody>\r\n        <tr>\r\n          <th>\r\n            <br/>\r\n          </th>\r\n          <th>Difficulty</th>\r\n          <th>\r\n            <p>Estimated Days</p>\r\n          </th>\r\n          <th colspan=\"1\">\r\n            <div class=\"content-wrapper\">\r\n              <p>Estimated Days RemainingTask</p>\r\n            </div>\r\n          </th>\r\n        </tr>\r\n        <tr>\r\n          <td>Construction of Pan/Tilt platform</td>\r\n          <td>?</td>\r\n          <td>14</td>\r\n          <td colspan=\"1\">14</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>Drivers for the Pan/Tilt motors</p>\r\n            <p>(9/4/21) Use the compatible driver board for the motors. Will need step and direction provided by an Arduino or STM32 microcontroller</p>\r\n            <p>Need to support step and direction output at the speeds required by the platform</p>\r\n            <p>Need to support limit switches</p>\r\n            <p>Need to support a homing function.</p>\r\n          </td>\r\n          <td colspan=\"1\">Medium</td>\r\n          <td colspan=\"1\">4</td>\r\n          <td colspan=\"1\">4</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>Port of MMS to Nvidia Jetson platform</p>\r\n            <p>(9/4/21) Work on RPi was done in 2018 as part of the Deakin drone project. Need to refresh code with latest camera library. Initial version of V4L camera drivers were broken and needed work arounds in the code.</p>\r\n            <p>(12/4/21) The Nvidia Jetson boards are 64 bit ARM architectures and do not support the MIPI modules that were available on the RPi. </p>\r\n            <p>(15/4/21) All unit tests pass. All platform changes committed to MMS tower_camera branch.</p>\r\n          </td>\r\n          <td colspan=\"1\">Low</td>\r\n          <td colspan=\"1\">4</td>\r\n          <td colspan=\"1\">0</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>Driver for the RPI HD camera</p>\r\n            <p>(8/4/21) Camera and Lenses ordered </p>\r\n            <p>(12/4/21) Not all RPi cameras are supported so some testing and development will need to be done on this.</p>\r\n            <p>Need to apply the following packages from RidgeRun</p>\r\n            <p>\r\n              <a href=\"https://developer.ridgerun.com/wiki/index.php?title=Raspberry_Pi_HQ_camera_IMX477_Linux_driver_for_Jetson#Installing_the_Driver_-_Option_A:_Debian_Packages_.28Recommended.29\">https://developer.ridgerun.com/wiki/index.php?title=Raspberry_Pi_HQ_camera_IMX477_Linux_driver_for_Jetson#Installing_the_Driver_-_Option_A:_Debian_Packages_.28Recommended.29</a>\r\n            </p>\r\n          </td>\r\n          <td colspan=\"1\">Low</td>\r\n          <td colspan=\"1\">2</td>\r\n          <td colspan=\"1\">1</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">Enhancements to the CameraTrackingExtension module. Need to see how well the tracking module follows towers. Parameter tuning</td>\r\n          <td colspan=\"1\">Medium</td>\r\n          <td colspan=\"1\">4</td>\r\n          <td colspan=\"1\">3</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>Touch screen HDMI display. Need to select suitable display that will interface with Jetson. Custom full screen application that displays the tracking camera controls</p>\r\n          </td>\r\n          <td colspan=\"1\">Medium</td>\r\n          <td colspan=\"1\">3</td>\r\n          <td colspan=\"1\">3</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>Image processing pipeline for tower tracking</p>\r\n            <p>(8/4/21) Some work on this is already done but will need to review the code</p>\r\n          </td>\r\n          <td colspan=\"1\">Medium</td>\r\n          <td colspan=\"1\">2</td>\r\n          <td colspan=\"1\">2</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\">\r\n            <p>\r\n              <span style=\"color: rgb(0,0,0);\">Control of Pan/Tilt platform using either Reflexxes library or a Feed-Forward controller</span>\r\n            </p>\r\n            <p>\r\n              <span style=\"color: rgb(0,0,0);\">(19/4/21) Work on a new control function based on FHAN function</span>\r\n            </p>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <span style=\"color: rgb(0,0,0);\">Medium</span>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <span style=\"color: rgb(0,0,0);\">3</span>\r\n          </td>\r\n          <td colspan=\"1\">2</td>\r\n        </tr>\r\n        <tr>\r\n          <td colspan=\"1\" style=\"text-align: right;\">\r\n            <span style=\"color: rgb(255,0,255);\">Total</span>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <br/>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <br/>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <div class=\"content-wrapper\">\r\n              <p>\r\n                <br/>\r\n              </p>\r\n            </div>\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align: right;\">\r\n            <span style=\"color: rgb(255,0,255);\">Contingency</span>\r\n          </td>\r\n          <td>\r\n            <br/>\r\n          </td>\r\n          <td>\r\n            <span style=\"color: rgb(255,0,255);\">100%</span>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <br/>\r\n          </td>\r\n        </tr>\r\n        <tr>\r\n          <td style=\"text-align: right;\">\r\n            <span style=\"color: rgb(255,0,255);\">Schedule</span>\r\n          </td>\r\n          <td>\r\n            <br/>\r\n          </td>\r\n          <td>\r\n            <span style=\"color: rgb(255,0,255);\">40</span>\r\n          </td>\r\n          <td colspan=\"1\">\r\n            <br/>\r\n          </td>\r\n        </tr>\r\n      </tbody>\r\n    </table>\r\n    <p class=\"auto-cursor-target\">\r\n      <br/>\r\n    </p>\r\n";

    public ConditionalRulesManagerMacro(XhtmlContent xhtmlUtils, I18nResolver i18nResolver, PluginLicenseManager licenseMgr, UserAccessor userAccessor, PageManager pageManager, PermissionManager permissionManager) {
        this.xhtmlUtils = xhtmlUtils;
        this.i18n = i18nResolver;
        this.licenseManager = licenseMgr;
        this.userAccessor = userAccessor;
        this.pageManager = pageManager;
        this.permissionManager = permissionManager;
    }

    public static boolean isUserAuthorizedToReadThePage(PermissionManager permissionManager, User user, Page page) {
        return null != permissionManager && user != null && permissionManager.hasPermission(user, Permission.VIEW, (Object)page);
    }

    @RequiresFormat(value=Format.Storage)
    public String execute(Map<String, String> parameters, String bodyContent, ConversionContext conversionContext) throws MacroExecutionException {
        String body = "";
        String convertedResult = "";
        String result = "";
        try {
            boolean isTrialLicense;
            if (Features.CHECK_SERVER_LICENSE) {
                this.validateLicense();
            }
            final ConditionalRulesManagerMacroParams macroParams = new ConditionalRulesManagerMacroParams(parameters);
            final ConversionContext cc = conversionContext;
            final ArrayList rules = new ArrayList();
            body = this.xhtmlUtils.replaceMacroDefinitionsWithString(bodyContent, conversionContext, new MacroDefinitionReplacer(){

                public String replace(MacroDefinition macro) throws XhtmlException {
                    if (null != macro && null != macro.getName() && macro.getName().equalsIgnoreCase("conditional-rule")) {
                        ConditionalRuleMacroParams params = new ConditionalRuleMacroParams(macro.getParameters());
                        ConditionalRule rule = new ConditionalRule(params, macroParams.decimalSymbol, macroParams.digitGroupingSymbol);
                        if (null != rule) {
                            rules.add(rule);
                        }
                        return "";
                    }
                    if (Features.SUPPORT_FOR_2_COLOR_SCALE && null != macro && null != macro.getName() && macro.getName().equalsIgnoreCase("conditional-2-color-scale")) {
                        Conditional2ColorScaleMacroParams params = new Conditional2ColorScaleMacroParams(macro.getParameters());
                        Conditional2ColorScale rule = new Conditional2ColorScale(params, macroParams.decimalSymbol, macroParams.digitGroupingSymbol);
                        if (null != rule) {
                            rules.add(rule);
                        }
                        return "";
                    }
                    String result = ConditionalRulesManagerMacro.this.xhtmlUtils.convertMacroDefinitionToView(macro, cc);
                    return result;
                }
            });
            result = convertedResult = this.xhtmlUtils.convertStorageToView(body, conversionContext);
            IConditionalRule[] arrRules = rules.toArray(new IConditionalRule[rules.size()]);
            result = HtmlTools.processRules(convertedResult, macroParams.skipHeadingCells, arrRules, null, null);
            boolean bl = isTrialLicense = this.isTrialLicense() || this.isDeveloperLicense();
            if (isTrialLicense) {
                result = result + MacroHelper.CONDITIONS_TRIAL_STRING;
            }
        }
        catch (MacroExecutionException exception) {
            throw new MacroExecutionException(exception.getMessage());
        }
        catch (Exception exception) {
            throw new MacroExecutionException(String.format(this.i18n.getText("com.celestecs.confluence.celestecs-conditions.conditional-rules-manager.error.UnknowException"), exception.toString()));
        }
        return result;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }

    protected boolean exemptDeveloperLicense() {
        return true;
    }

    protected boolean exemptOnDemand() {
        return false;
    }

    protected boolean isDeveloperLicense() throws MacroExecutionException {
        String type;
        boolean licenseOk;
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                }
            }
            catch (Exception exception) {
                licenseOk = false;
            }
        }
        return !licenseOk && this.exemptDeveloperLicense() && (licenseOk = (type = LicenseManager.getInstance().getLicense("CONF").getLicenseType().getNewLicenseTypeName()).equalsIgnoreCase("DEVELOPER"));
    }

    protected boolean isTrialLicense() throws MacroExecutionException {
        boolean licenseOk;
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    return pluginLicense.isEvaluation();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return false;
    }

    protected void validateLicense() throws MacroExecutionException {
        boolean licenseOk;
        String reason = String.format(this.i18n.getText("com.celestecs.confluence.celestecs-conditions.conditional-rules-manager.licensing.unknown-error"), new Object[0]);
        boolean bl = licenseOk = this.licenseManager != null;
        if (licenseOk) {
            try {
                licenseOk = this.licenseManager.getLicense().isDefined();
                if (licenseOk) {
                    PluginLicense pluginLicense = (PluginLicense)this.licenseManager.getLicense().get();
                    licenseOk = pluginLicense.isValid();
                    if (!licenseOk) {
                        String errorName = ((LicenseError)pluginLicense.getError().get()).name();
                        reason = String.format(this.i18n.getText("com.celestecs.confluence.celestecs-conditions.conditional-rules-manager.licensing." + errorName), new Object[0]);
                    }
                } else {
                    reason = String.format(this.i18n.getText("com.celestecs.confluence.celestecs-conditions.conditional-rules-manager.licensing.no-license"), new Object[0]);
                }
            }
            catch (Exception exception) {
                licenseOk = false;
            }
        }
        if (!licenseOk && this.exemptDeveloperLicense()) {
            String type = LicenseManager.getInstance().getLicense("CONF").getLicenseType().getNewLicenseTypeName();
            licenseOk = type.equalsIgnoreCase("DEVELOPER");
        }
        if (!licenseOk && this.exemptOnDemand()) {
            String onDemand = System.getProperty("atlassian.upm.on.demand");
            boolean bl2 = licenseOk = onDemand != null && onDemand.equals("true");
        }
        if (!licenseOk) {
            throw new MacroExecutionException(String.format(this.i18n.getText("com.celestecs.confluence.celestecs-conditions.conditional-rules-manager.licensing.invalid-license"), reason));
        }
    }
}

