/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.conditionalrules;

import com.celestecs.conditionalrules.CommonParamProcessingFunctions;
import com.celestecs.conditionalrules.Conditional2ColorScaleMacroParams;
import com.celestecs.conditionalrules.ConditionalRuleMacroParams;
import com.celestecs.conditionalrules.IConditionalRule;
import com.celestecs.conditionalrules.RuleSubject;
import com.celestecs.conditionalrules.StyleApplicationType;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.PageContentProvider;
import java.awt.Color;
import java.util.List;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.parser.Parser;
import org.jsoup.select.Elements;

public class HtmlTools {
    public static void applyTableElementChangesForConditionalRule(Element element, StyleApplicationType bold, StyleApplicationType italic, StyleApplicationType underline, String textColor, String backgroundColor, String replacementText) {
        if (null != replacementText && replacementText.length() > 0 && 0 != replacementText.compareTo("Keep original")) {
            element.html(replacementText);
        }
        if (null != element.html() && StyleApplicationType.KeepOriginal != bold) {
            HtmlTools.removeIntermediateTag(element, "strong", "");
            if (StyleApplicationType.ApplyStyle == bold) {
                element.html("<strong>" + element.html() + "</strong>");
            }
        }
        if (null != element.html() && StyleApplicationType.KeepOriginal != italic) {
            HtmlTools.removeIntermediateTag(element, "em", "");
            if (StyleApplicationType.ApplyStyle == italic) {
                element.html("<em>" + element.html() + "</em>");
            }
        }
        if (null != element.html() && StyleApplicationType.KeepOriginal != underline) {
            HtmlTools.removeIntermediateTag(element, "u", "");
            if (StyleApplicationType.ApplyStyle == underline) {
                element.html("<u>" + element.html() + "</u>");
            }
        }
        if (null != element.html() && null != textColor && textColor.length() > 0 && 0 != textColor.compareTo("Keep original")) {
            HtmlTools.removeIntermediateTag(element, "span", "style");
            element.html("<span style=\"color: " + textColor + ";\">" + element.html() + "</span>");
        }
        if (null != element.html() && null != backgroundColor && backgroundColor.length() > 0 && 0 != backgroundColor.compareTo("Keep original")) {
            HtmlTools.setBackgroundColor(element, backgroundColor);
        }
    }

    public static String applyAnyElementChangesForConditionalRule(String originalHtml, StyleApplicationType bold, StyleApplicationType italic, StyleApplicationType underline, String textColor, String backgroundColor, String replacementText) {
        Document element = Jsoup.parse(originalHtml, "", Parser.xmlParser());
        if (null == element) {
            return originalHtml;
        }
        HtmlTools.applyAnyElementChangesForConditionalRule(element, bold, italic, underline, textColor, backgroundColor, replacementText, "", "");
        return element.html();
    }

    public static void applyAnyElementChangesForConditionalRule(Element element, StyleApplicationType bold, StyleApplicationType italic, StyleApplicationType underline, String textColor, String backgroundColor, String replacementText, String trimStart, String trimEnd) {
        boolean hasBkgColor;
        boolean hadStrong = false;
        boolean hadEm = false;
        boolean hadU = false;
        Elements elements = null;
        elements = element.getElementsByTag("string");
        if (null != elements && elements.size() > 0) {
            hadStrong = true;
        }
        if (null != (elements = element.getElementsByTag("em")) && elements.size() > 0) {
            hadEm = true;
        }
        if (null != (elements = element.getElementsByTag("u")) && elements.size() > 0) {
            hadU = true;
        }
        element.tagName("div");
        boolean needStrong = false;
        boolean needEm = false;
        boolean needU = false;
        if (StyleApplicationType.KeepOriginal == bold) {
            needStrong = hadStrong;
        } else if (StyleApplicationType.ApplyStyle == bold) {
            needStrong = true;
        }
        if (StyleApplicationType.KeepOriginal == italic) {
            needEm = hadEm;
        } else if (StyleApplicationType.ApplyStyle == italic) {
            needEm = true;
        }
        if (StyleApplicationType.KeepOriginal == underline) {
            needU = hadU;
        } else if (StyleApplicationType.ApplyStyle == underline) {
            needU = true;
        }
        String text = "";
        text = null != replacementText && replacementText.length() > 0 && 0 != replacementText.compareTo("Keep original") ? trimStart + replacementText + trimEnd : trimStart + element.html() + trimEnd;
        String span = "";
        boolean hasColor = null != textColor && textColor.length() > 0 && 0 != textColor.compareTo("Keep original");
        boolean bl = hasBkgColor = null != backgroundColor && backgroundColor.length() > 0 && 0 != backgroundColor.compareTo("Keep original");
        if (hasColor && !hasBkgColor) {
            span = "<span style=\"color: " + textColor + ";\"";
        }
        if (!hasColor && hasBkgColor) {
            span = "<span style=\"background-color: " + backgroundColor + ";\">";
        }
        if (hasColor && hasBkgColor) {
            span = "<span style=\"color: " + textColor + "; background-color: " + backgroundColor + ";\">";
        }
        String html = (needStrong ? "<strong>" : "") + (needU ? "<u>" : "") + (needEm ? "<em>" : "") + (!span.isEmpty() ? span : "") + text + (!span.isEmpty() ? "</span>" : "") + (needEm ? "</em>" : "") + (needU ? "</u>" : "") + (needStrong ? "</strong>" : "");
        element.html(html);
    }

    public static String replaceAll(String originalText, String findText, StyleApplicationType bold, StyleApplicationType italic, StyleApplicationType underline, String textColor, String backgroundColor, String replacementText) {
        if (originalText == null) {
            return null;
        }
        if (findText == null || findText.length() == 0) {
            return originalText;
        }
        if (findText.length() > originalText.length()) {
            return originalText;
        }
        int counter = 0;
        String thesubstr = "";
        while (counter < originalText.length() && originalText.substring(counter).length() >= findText.length()) {
            thesubstr = originalText.substring(counter, counter + findText.length());
            if (thesubstr.equalsIgnoreCase(findText)) {
                String textToReplaceWith = HtmlTools.applyAnyElementChangesForConditionalRule(thesubstr, bold, italic, underline, textColor, backgroundColor, replacementText);
                originalText = originalText.substring(0, counter) + textToReplaceWith + originalText.substring(counter + findText.length());
                counter += textToReplaceWith.length();
                continue;
            }
            ++counter;
        }
        return originalText;
    }

    public static void applyTableElementChangesForConditional2ColorScale(Element element, String minColor, String maxColor) {
        if (null != element.html() && null != minColor && minColor.length() > 0 && null != maxColor && maxColor.length() > 0) {
            HtmlTools.removeIntermediateTag(element, "span", "style");
            element.html("<span style=\"background: linear-gradient(to right, " + minColor + " 0%, " + maxColor + " 100%);\">" + element.html() + "</span>");
        }
    }

    public static String replaceCharsWithNegativeCodesWithSpaces(String src) {
        if (null == src || src.isEmpty()) {
            return "";
        }
        byte[] bytes = src.getBytes();
        int count = src.length();
        String result = "";
        for (int i = 0; i < count; ++i) {
            result = bytes[i] >= 0 ? result + src.charAt(i) : result + " ";
        }
        return result;
    }

    protected static void setBackgroundColor(Element element, String backgroundColor) {
        HtmlTools.removeHighlightAttrs(element);
        if (HtmlTools.isOneOfConfluenceBkColors(backgroundColor)) {
            element.attr("class", backgroundColor + " " + HtmlTools.getConfluenceCellElementClass(element));
            element.attr("data-highlight-colour", backgroundColor.substring("highlight-".length()));
        } else {
            element.attr("style", "background-color: " + backgroundColor);
        }
    }

    protected static boolean isOneOfConfluenceBkColors(String color) {
        if (null == color) {
            return false;
        }
        return 0 == (color = color.toLowerCase()).compareTo("highlight-grey") || 0 == color.compareTo("highlight-red") || 0 == color.compareTo("highlight-green") || 0 == color.compareTo("highlight-blue") || 0 == color.compareTo("highlight-yellow");
    }

    protected static void removeIntermediateTag(Element element, String tagName, String attrName) {
        int counter = 100000;
        while (counter > 0) {
            --counter;
            Elements childElements = element.getAllElements();
            boolean foundOne = false;
            for (Element childElement : childElements) {
                if (null == childElement.tagName() || 0 != childElement.tagName().compareToIgnoreCase(tagName) || null != attrName && attrName.length() >= 1 && !childElement.hasAttr(attrName)) continue;
                Node previousNode = childElement;
                List<Node> grandChildNodes = childElement.childNodes();
                for (Node grandChildNode : grandChildNodes) {
                    Node cloneNode = grandChildNode.clone();
                    ((Node)previousNode).after(cloneNode);
                    previousNode = cloneNode;
                }
                childElement.remove();
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
    }

    protected static void removeIntermediateTagForAllElements(Element element, String tagName, String attrName) {
        int counter = 100000;
        while (counter > 0) {
            --counter;
            Elements childElements = element.getAllElements();
            boolean foundOne = false;
            boolean skip = true;
            for (Element childElement : childElements) {
                if (skip) {
                    skip = false;
                    continue;
                }
                if (null == childElement || null == childElement.tagName() || 0 != childElement.tagName().compareToIgnoreCase(tagName) || null != attrName && attrName.length() >= 1 && !childElement.hasAttr(attrName)) continue;
                Node previousNode = childElement;
                List<Node> grandChildNodes = childElement.childNodes();
                for (Node grandChildNode : grandChildNodes) {
                    if (null == previousNode || null == previousNode.parentNode()) continue;
                    Node cloneNode = grandChildNode.clone();
                    ((Node)previousNode).after(cloneNode);
                    previousNode = cloneNode;
                }
                if (null == childElement || null == childElement.parentNode()) continue;
                childElement.remove();
                foundOne = true;
            }
            if (foundOne) continue;
            break;
        }
    }

    protected static String getConfluenceCellElementClass(Element element) {
        if (null == element.tagName()) {
            return "";
        }
        if (0 == element.tagName().compareToIgnoreCase("td")) {
            return "confluenceTd";
        }
        if (0 == element.tagName().compareToIgnoreCase("th")) {
            return "confluenceTh";
        }
        return "";
    }

    protected static void removeHighlightAttrs(Element element) {
        if (element.hasAttr("class")) {
            element.attr("class", HtmlTools.getConfluenceCellElementClass(element));
        }
        if (element.hasAttr("data-highlight-colour")) {
            element.attr("data-highlight-colour", false);
        }
    }

    public static String getConditionalRuleMacroText(String body, ConditionalRuleMacroParams params) {
        Element element;
        Elements elementsTd;
        String s1 = "<div class=\"table-wrap\">\t<table class=\"confluenceTable\">\t\t<colgroup>\t\t\t<col />\t\t</colgroup>\t\t<tbody>\t\t\t<tr>\t\t\t\t<td class=\"confluenceTd\">" + body + "\t\t\t\t</td>\t\t\t</tr>\t\t</tbody>\t</table></div>";
        String result = "";
        Document doc = Jsoup.parse(s1, "", Parser.xmlParser());
        if (null != doc && null != (elementsTd = doc.select("td")) && elementsTd.size() > 0 && null != (element = elementsTd.first())) {
            HtmlTools.applyTableElementChangesForConditionalRule(element, params.styleBold, params.styleItalic, params.styleUnderline, params.textColor, params.backgroundColor, params.replacementText);
            result = doc.outerHtml();
        }
        return result;
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    public static String getConditional2ColorScaleMacroText_Cloud(Conditional2ColorScaleMacroParams params) {
        int numOfBricks = 10;
        String minColorHex = CommonParamProcessingFunctions.convertAnyColorToHex(params.minimumValueColor);
        Color minColor = HtmlTools.hex2Rgb(minColorHex);
        String maxColorHex = CommonParamProcessingFunctions.convertAnyColorToHex(params.maximumValueColor);
        Color maxColor = HtmlTools.hex2Rgb(maxColorHex);
        float minR = minColor.getRed();
        float minG = minColor.getGreen();
        float minB = minColor.getBlue();
        float maxR = maxColor.getRed();
        float maxG = maxColor.getGreen();
        float maxB = maxColor.getBlue();
        float incR = (maxR - minR) / (float)numOfBricks;
        float incG = (maxG - minG) / (float)numOfBricks;
        float incB = (maxB - minB) / (float)numOfBricks;
        String s1 = "<div class=\"table-wrap\">\t<table class=\"confluenceTable\">\t\t<colgroup>\t\t\t<col />\t\t</colgroup>\t\t<tbody>\t\t\t<tr>";
        for (int i = 0; i < numOfBricks; ++i) {
            float fR = minR + incR * (float)i;
            float fG = minG + incG * (float)i;
            float fB = minB + incB * (float)i;
            String c = String.format("#%02x%02x%02x", Math.round(fR), Math.round(fG), Math.round(fB));
            s1 = s1 + "\t\t\t\t<td class=\"confluenceTd\"\t\t\t\t\tstyle=\"background-color:" + c + "; table-layout: fixed; width: 40px;\" \t\t\t\t>\t\t\t\t\t&nbsp;\t\t\t\t</td>";
        }
        s1 = s1 + "\t\t\t</tr>\t\t</tbody>\t</table></div>";
        return s1;
    }

    public static String getConditional2ColorScaleMacroText(Conditional2ColorScaleMacroParams params) {
        String s1 = "<div class=\"table-wrap\">\t<table class=\"confluenceTable\">\t\t<colgroup>\t\t\t<col />\t\t</colgroup>\t\t<tbody>\t\t\t<tr>\t\t\t\t<td class=\"confluenceTd\"\t\t\t\t\tstyle=\"background: linear-gradient(to right, " + CommonParamProcessingFunctions.convertAnyColorToHex(params.minimumValueColor) + " 0%, " + CommonParamProcessingFunctions.convertAnyColorToHex(params.maximumValueColor) + " 100%); table-layout: fixed; width: 400px;\" \t\t\t\t>\t\t\t\t\t&nbsp;\t\t\t\t</td>\t\t\t</tr>\t\t</tbody>\t</table></div>";
        return s1;
    }

    /*
     * WARNING - void declaration
     */
    public static String processRules(String src, boolean skipHeadingCells, IConditionalRule[] rules, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        int n;
        IConditionalRule[] elementsSpan;
        String result = "";
        Document doc = Jsoup.parse(src, "", Parser.xmlParser());
        if (Features.REPLACE_MATH_CONDITIONS_TRIAL_STRING && null != (elementsSpan = doc.select("span")) && elementsSpan.size() > 0) {
            for (Element element : elementsSpan) {
                if (null == element || !element.hasClass(MacroHelper.TRIAL_CSS_CLASS)) continue;
                element.remove();
            }
        }
        if (Features.WHOLE_CONTENT_SUPPORT) {
            void var9_12;
            elementsSpan = rules;
            int n2 = elementsSpan.length;
            boolean bl = false;
            while (var9_12 < n2) {
                IConditionalRule rule = elementsSpan[var9_12];
                rule.processWholeText(doc);
                ++var9_12;
            }
        }
        RuleSubject[][][] ruleSubjects = Features.FIX_CONDITIONS_NULLPOINTER_WHEN_NO_RULES ? new RuleSubject[][][]{} : null;
        Elements elementsTables = doc.select("table");
        int n3 = n = null == elementsTables ? 0 : elementsTables.size();
        if (n > 0) {
            ruleSubjects = new RuleSubject[n][][];
            for (int i = 0; i < n; ++i) {
                int rowCount;
                Element table = (Element)elementsTables.get(i);
                if (null == table) continue;
                Elements elementsTr = table.select("tr");
                int n4 = rowCount = null == elementsTr ? 0 : elementsTr.size();
                if (rowCount > 0) {
                    int colCount;
                    Elements elementsTdTh;
                    Element elementTr;
                    int j;
                    ruleSubjects[i] = new RuleSubject[rowCount][];
                    int maxColCount = 0;
                    for (j = 0; j < rowCount; ++j) {
                        elementTr = (Element)elementsTr.get(j);
                        elementsTdTh = elementTr.select("td,th");
                        int n5 = colCount = null == elementsTdTh ? 0 : elementsTdTh.size();
                        if (maxColCount >= colCount) continue;
                        maxColCount = colCount;
                    }
                    for (j = 0; j < rowCount; ++j) {
                        int k;
                        ruleSubjects[i][j] = new RuleSubject[maxColCount];
                        elementTr = (Element)elementsTr.get(j);
                        elementsTdTh = elementTr.select("td,th");
                        colCount = null == elementsTdTh ? 0 : elementsTdTh.size();
                        for (k = 0; k < colCount; ++k) {
                            RuleSubject ruleSubject;
                            Element elementTdTh = (Element)elementsTdTh.get(k);
                            ruleSubjects[i][j][k] = null == elementTdTh || null != elementTdTh && skipHeadingCells && 0 == elementTdTh.tagName().compareToIgnoreCase("th") ? null : (ruleSubject = new RuleSubject(elementTdTh, MacroHelper.html2text(elementTdTh.html())));
                        }
                        for (k = colCount; k < maxColCount; ++k) {
                            ruleSubjects[i][j][k] = null;
                        }
                    }
                    continue;
                }
                ruleSubjects[i] = new RuleSubject[0][];
            }
            for (IConditionalRule rule : rules) {
                rule.processElements(ruleSubjects, pageContentProvider, i18n);
            }
        }
        for (int i = 0; i < ruleSubjects.length; ++i) {
            if (null == ruleSubjects[i]) continue;
            for (int j = 0; j < ruleSubjects[i].length; ++j) {
                if (null == ruleSubjects[i][j]) continue;
                for (int k = 0; k < ruleSubjects[i][j].length; ++k) {
                    RuleSubject ruleSubject = ruleSubjects[i][j][k];
                    if (null == ruleSubject) continue;
                    Element element = (Element)ruleSubject.subject;
                    HtmlTools.applyTableElementChangesForConditionalRule(element, ruleSubject.bold, ruleSubject.italic, ruleSubject.underline, ruleSubject.textColor, ruleSubject.backgroundColor, ruleSubject.replacementText);
                }
            }
        }
        result = doc.outerHtml();
        return result;
    }
}

