/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.conditionalrules;

import com.celestecs.expression.MacroHelper;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class AffectedElementsSpecification {
    protected SpecificationType specificationType = SpecificationType.Self;
    protected int min = -1;
    protected int max = -1;

    public SpecificationType getSpecificationType() {
        return this.specificationType;
    }

    public int getMin() {
        return this.min;
    }

    public int getMax() {
        return this.max;
    }

    public AffectedElementsSpecification(String affectedElements) {
        if (null == affectedElements || affectedElements.length() < 1) {
            return;
        }
        if (affectedElements.equalsIgnoreCase("Self")) {
            this.min = -1;
            this.max = -1;
            this.specificationType = SpecificationType.Self;
            return;
        }
        if (AffectedElementsSpecification.matchesRegexp(affectedElements, "[a-zA-Z]+:[a-zA-Z]+")) {
            int idx1 = 0;
            int idx4 = affectedElements.indexOf(":", idx1);
            if (idx4 < 0) {
                return;
            }
            String strFirstColumnIndex = affectedElements.substring(idx1, idx4);
            idx1 = idx4 + 1;
            idx4 = affectedElements.length();
            if (idx4 <= idx1) {
                return;
            }
            String strLastColumnIndex = affectedElements.substring(idx1, idx4);
            int firstColumnIndex = -1;
            int lastColumnIndex = -1;
            try {
                firstColumnIndex = MacroHelper.getExcelColumnNumber(strFirstColumnIndex);
                lastColumnIndex = MacroHelper.getExcelColumnNumber(strLastColumnIndex);
            }
            catch (Exception e) {
                return;
            }
            if (lastColumnIndex < firstColumnIndex) {
                int tmp = lastColumnIndex;
                lastColumnIndex = firstColumnIndex;
                firstColumnIndex = tmp;
            }
            this.min = firstColumnIndex;
            this.max = lastColumnIndex;
            this.specificationType = SpecificationType.A_B;
            return;
        }
        if (AffectedElementsSpecification.matchesRegexp(affectedElements, "[0-9]+:[0-9]+")) {
            int idx1 = 0;
            int idx4 = affectedElements.indexOf(":", idx1);
            if (idx4 < 0) {
                return;
            }
            String strFirstColumnIndex = affectedElements.substring(idx1, idx4);
            idx1 = idx4 + 1;
            idx4 = affectedElements.length();
            if (idx4 <= idx1) {
                return;
            }
            String strLastColumnIndex = affectedElements.substring(idx1, idx4);
            int firstColumnIndex = -1;
            int lastColumnIndex = -1;
            try {
                firstColumnIndex = Integer.parseInt(strFirstColumnIndex);
                lastColumnIndex = Integer.parseInt(strLastColumnIndex);
            }
            catch (Exception e) {
                return;
            }
            if (lastColumnIndex < firstColumnIndex) {
                int tmp = lastColumnIndex;
                lastColumnIndex = firstColumnIndex;
                firstColumnIndex = tmp;
            }
            this.min = firstColumnIndex;
            this.max = lastColumnIndex;
            this.specificationType = SpecificationType.One_Two;
            return;
        }
    }

    protected static boolean matchesRegexp(String str, String regexp) {
        if (null == str || str.length() < 1 || null == regexp || regexp.length() < 1) {
            return false;
        }
        Pattern p = Pattern.compile(regexp);
        Matcher m = p.matcher(str);
        return m.matches();
    }

    public static enum SpecificationType {
        Self,
        A_B,
        One_Two;

    }
}

