/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.financial.FinanceFunctions;

public final class CalculatorNper
extends CalculatorBase {
    public CalculatorNper(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    protected void checkToBeDouble(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isDoubleOrLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Double.");
        }
    }

    protected void checkToBeLong(Object param, String paramName) {
        if (null == param) {
            throw new IllegalArgumentException("Parameter '" + paramName + "' has null value.");
        }
        if (!Conversion.isLong(param, this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("Wrong type of parameter '" + paramName + "', which should be Long.");
        }
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 3 || objParams.length > 5) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 3 and no more than 5.");
        }
        this.checkToBeDouble(objParams[0], "Rate");
        double Rate = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        this.checkToBeDouble(objParams[1], "Pmt");
        double Pmt = Conversion.objectToDouble(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        this.checkToBeDouble(objParams[2], "Pv");
        double Pv = Conversion.objectToDouble(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        double Fv = 0.0;
        if (objParams.length > 3) {
            this.checkToBeDouble(objParams[3], "Fv");
            Fv = Conversion.objectToDouble(objParams[3], this.decimalSymbol, this.digitGroupingSymbol);
        }
        int Type2 = 0;
        if (objParams.length > 4) {
            this.checkToBeLong(objParams[4], "Type");
            Type2 = new Long(Conversion.objectToLong(objParams[4], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        return new Double(FinanceFunctions.nper(Rate, Pmt, Pv, Fv, Type2));
    }
}

