/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.financial;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.financial.FinanceFunctions;

public final class CalculatorFv
extends CalculatorBase {
    public CalculatorFv(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 3 || objParams.length > 5) {
            throw new IllegalArgumentException("Wrong parameter count, which should be not less than 3 and no more than 5.");
        }
        Conversion.checkToBeDouble(objParams[0], "Rate", this.decimalSymbol, this.digitGroupingSymbol);
        double Rate = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        Conversion.checkToBeLong(objParams[1], "Nper", this.decimalSymbol, this.digitGroupingSymbol);
        int Nper = new Long(Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        Conversion.checkToBeDouble(objParams[2], "Pmt", this.decimalSymbol, this.digitGroupingSymbol);
        double Pmt = Conversion.objectToDouble(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        double Pv = 0.0;
        if (objParams.length > 3) {
            Conversion.checkToBeDouble(objParams[3], "Pv", this.decimalSymbol, this.digitGroupingSymbol);
            Pv = Conversion.objectToDouble(objParams[3], this.decimalSymbol, this.digitGroupingSymbol);
        }
        int Type2 = 0;
        if (objParams.length > 4) {
            Conversion.checkToBeLong(objParams[4], "Type", this.decimalSymbol, this.digitGroupingSymbol);
            Type2 = new Long(Conversion.objectToLong(objParams[4], this.decimalSymbol, this.digitGroupingSymbol)).intValue();
        }
        return new Double(FinanceFunctions.fv(Rate, Nper, Pmt, Pv, Type2));
    }
}

