/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.dateandtime;

import com.celestecs.expression.DateTime;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.dateandtime.CalculatorNetWorkdays;
import java.util.ArrayList;
import java.util.Date;
import org.apache.poi.ss.usermodel.DateUtil;

public final class CalculatorWorkday
extends CalculatorBase {
    public CalculatorWorkday(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        if (null == (objParams = Conversion.objectArrayWithRangesToFlatObjectArray(objParams)) || objParams.length < 2) {
            throw new IllegalArgumentException("Wrong parameter count, which should be be greater or equal to 2.");
        }
        if (null == objParams[0] || !Conversion.isDateTime(objParams[0])) {
            throw new IllegalArgumentException("The WORKDAY function first parameter with value '" + objParams[0] + "' does not look to be a valid date.");
        }
        if (null == objParams[1] || !Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)) {
            throw new IllegalArgumentException("The WORKDAY function second parameter with value '" + objParams[1] + "' does not look to be a valid numeric value.");
        }
        for (int i = 2; i < objParams.length; ++i) {
            if (null != objParams[i] && Conversion.isDateTime(objParams[i])) continue;
            throw new IllegalArgumentException("The WORKDAY function parameter number " + (i + 1) + " with value '" + objParams[i] + "' does not look to be a valid date.");
        }
        try {
            DateTime d0 = Conversion.objectToDateTime(objParams[0]);
            Date jd0 = DateTime.getClearDate(DateUtil.getJavaDate(d0.getValue()));
            double start = DateUtil.getExcelDate(jd0);
            int days = (int)Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
            ArrayList<Double> arrHolidays = new ArrayList<Double>();
            for (int i = 2; i < objParams.length; ++i) {
                DateTime dzz = Conversion.objectToDateTime(objParams[i]);
                Date jdzz = DateTime.getClearDate(DateUtil.getJavaDate(dzz.getValue()));
                double ddzz = DateUtil.getExcelDate(jdzz);
                arrHolidays.add(ddzz);
            }
            Double[] holidays = arrHolidays.size() < 1 ? null : arrHolidays.toArray(new Double[1]);
            Date dRes = CalculatorNetWorkdays.calculateWorkdays(start, days, holidays);
            return new DateTime(DateUtil.getExcelDate(dRes));
        }
        catch (Exception e) {
            return -1L;
        }
    }
}

