/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.conditionalrules;

import com.celestecs.conditionalrules.CommonParamProcessingFunctions;
import com.celestecs.conditionalrules.Conditional2ColorScaleMacroParams;
import com.celestecs.conditionalrules.IConditionalRule;
import com.celestecs.conditionalrules.MaximumValueType;
import com.celestecs.conditionalrules.MinimumValueType;
import com.celestecs.conditionalrules.RuleSubject;
import com.celestecs.expression.Features;
import com.celestecs.expression.MacroHelper;
import com.celestecs.expression.MathTextResolver;
import com.celestecs.expression.PageContentProvider;
import com.celestecs.expression.calculators.Conversion;
import java.awt.Color;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jsoup.nodes.Document;

public class Conditional2ColorScale
implements IConditionalRule {
    public String minimumValue = Conditional2ColorScaleMacroParams.DEF_MINIMUM_VALUE;
    public MinimumValueType minimumValueType = Conditional2ColorScaleMacroParams.DEF_MINIMUM_VALUE_TYPE;
    public String minimumValueColor = Conditional2ColorScaleMacroParams.DEF_MINIMUM_VALUE_COLOR;
    public String maximumValue = Conditional2ColorScaleMacroParams.DEF_MAXIMUM_VALUE;
    public MaximumValueType maximumValueType = Conditional2ColorScaleMacroParams.DEF_MAXIMUM_VALUE_TYPE;
    public String maximumValueColor = Conditional2ColorScaleMacroParams.DEF_MAXIMUM_VALUE_COLOR;
    public String appliesTo = Conditional2ColorScaleMacroParams.DEF_APPLIES_TO;
    protected char decimalSymbol = (char)46;
    protected String digitGroupingSymbol = "";

    public Conditional2ColorScale(Conditional2ColorScaleMacroParams params, char decimalSymbol, String digitGroupingSymbol) {
        this.minimumValue = params.minimumValue;
        this.minimumValueType = params.minimumValueType;
        this.minimumValueColor = params.minimumValueColor;
        this.maximumValue = params.maximumValue;
        this.maximumValueType = params.maximumValueType;
        this.maximumValueColor = params.maximumValueColor;
        this.appliesTo = params.appliesTo;
        this.decimalSymbol = decimalSymbol;
        this.digitGroupingSymbol = digitGroupingSymbol;
    }

    @Override
    public void processWholeText(Document doc) {
    }

    @Override
    public void processElements(RuleSubject[][][] ruleSubjects, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        this.processRuleSubjects(ruleSubjects, pageContentProvider, i18n);
    }

    public String getAppliesTo() {
        return this.appliesTo;
    }

    protected Object getValueFromRuleSubject(RuleSubject[][][] ruleSubjects, int tableIndexZeroBased, int rowZeroBased, int colZeroBased) {
        if (tableIndexZeroBased >= 0 && tableIndexZeroBased < ruleSubjects.length && rowZeroBased >= 0 && rowZeroBased < ruleSubjects[tableIndexZeroBased].length && colZeroBased >= 0 && colZeroBased < ruleSubjects[tableIndexZeroBased][rowZeroBased].length) {
            RuleSubject ruleSubject = ruleSubjects[tableIndexZeroBased][rowZeroBased][colZeroBased];
            if (null != ruleSubject) {
                return ruleSubject.originalValue;
            }
            return null;
        }
        return null;
    }

    public void processRuleSubjects(RuleSubject[][][] ruleSubjects, PageContentProvider pageContentProvider, MathTextResolver i18n) {
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        boolean[][][] appliedSubjects = this.prepareAppliedSubjectsArray(ruleSubjects, this.appliesTo);
        Double dMin = null;
        Double dMax = null;
        for (int i = 0; i < countI; ++i) {
            if (null == ruleSubjects[i]) continue;
            for (int j = 0; j < countJ; ++j) {
                if (null == ruleSubjects[i][j]) continue;
                for (int k = 0; k < countK; ++k) {
                    Double dValue;
                    RuleSubject ruleSubject = ruleSubjects[i][j][k];
                    if (null == ruleSubject || !appliedSubjects[i][j][k] || null == (dValue = this.getDoubleValueFromRuleSubject(ruleSubject))) continue;
                    if (null == dMin) {
                        dMin = dValue;
                    } else if (dMin > dValue) {
                        dMin = dValue;
                    }
                    if (null == dMax) {
                        dMax = dValue;
                        continue;
                    }
                    if (!(dMax < dValue)) continue;
                    dMax = dValue;
                }
            }
        }
        Double dRealMin = null;
        Double dRealMax = null;
        switch (this.minimumValueType) {
            case LowestValue: {
                dRealMin = dMin;
                break;
            }
            case Number: {
                Double dTmp;
                if (!Conversion.isDoubleOrLong(this.minimumValue, this.decimalSymbol, this.digitGroupingSymbol) || null == (dTmp = Double.valueOf(Conversion.objectToDouble(this.minimumValue, this.decimalSymbol, this.digitGroupingSymbol)))) break;
                dRealMin = dTmp;
                break;
            }
            case Percent: {
                if (!Conversion.isDoubleOrLong(this.minimumValue, this.decimalSymbol, this.digitGroupingSymbol)) break;
                Double dValue = Conversion.objectToDouble(this.minimumValue, this.decimalSymbol, this.digitGroupingSymbol);
                if (null == dMin || null == dMax || !(dMin <= dMax) || null == dValue || !(dValue >= 0.0) || !(dValue <= 100.0)) break;
                dRealMin = dMin + (dMax - dMin) * dValue / 100.0;
                break;
            }
            default: {
                dRealMin = null;
            }
        }
        switch (this.maximumValueType) {
            case HighestValue: {
                dRealMax = dMax;
                break;
            }
            case Number: {
                Double dTmp;
                if (!Conversion.isDoubleOrLong(this.maximumValue, this.decimalSymbol, this.digitGroupingSymbol) || null == (dTmp = Double.valueOf(Conversion.objectToDouble(this.maximumValue, this.decimalSymbol, this.digitGroupingSymbol)))) break;
                dRealMax = dTmp;
                break;
            }
            case Percent: {
                if (!Conversion.isDoubleOrLong(this.maximumValue, this.decimalSymbol, this.digitGroupingSymbol)) break;
                Double dTmp = Conversion.objectToDouble(this.maximumValue, this.decimalSymbol, this.digitGroupingSymbol);
                if (null == dMin || null == dMax || !(dMin <= dMax) || null == dTmp || !(dTmp >= 0.0) || !(dTmp <= 100.0)) break;
                dRealMax = dMax - (dMax - dMin) * (100.0 - dTmp) / 100.0;
                break;
            }
            default: {
                dRealMax = null;
            }
        }
        if (null == dRealMin || null == dRealMax || dRealMin >= dRealMax) {
            return;
        }
        for (int i = 0; i < countI; ++i) {
            if (null == ruleSubjects[i]) continue;
            for (int j = 0; j < countJ; ++j) {
                if (null == ruleSubjects[i][j]) continue;
                for (int k = 0; k < countK; ++k) {
                    RuleSubject ruleSubject = ruleSubjects[i][j][k];
                    if (null == ruleSubject || !appliedSubjects[i][j][k]) continue;
                    this.applyRuleForRuleSubject(ruleSubject, dRealMin, dRealMax);
                }
            }
        }
    }

    protected boolean[][][] prepareAppliedSubjectsArray(RuleSubject[][][] ruleSubjects, String appliesTo) {
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        boolean shouldProcessAllTables = false;
        if (appliesTo.toLowerCase().contains("All tables".toLowerCase())) {
            shouldProcessAllTables = true;
        }
        boolean[][][] appliedSubjects = Conditional2ColorScale.create3dArray(countI, countJ, countK, shouldProcessAllTables);
        if (shouldProcessAllTables) {
            return appliedSubjects;
        }
        String[] appliesToElems = appliesTo.contains(",") ? appliesTo.split(",") : (appliesTo.contains(";") ? appliesTo.split(";") : appliesTo.split(" "));
        int count = appliesToElems.length;
        for (int i = 0; i < count; ++i) {
            String appliesToElem = appliesToElems[i].trim();
            this.processTable1_A_B(ruleSubjects, appliesToElem, appliedSubjects);
            if (!Features.APPLES_TO_PARAM_ADDITIONAL_VARIANTS) continue;
            this.processA_B(ruleSubjects, appliesToElem, appliedSubjects);
            this.processTable1_1_2(ruleSubjects, appliesToElem, appliedSubjects);
            this.process1_2(ruleSubjects, appliesToElem, appliedSubjects);
            this.processTable1_A2_B3(ruleSubjects, appliesToElem, appliedSubjects);
            this.processA2_B3(ruleSubjects, appliesToElem, appliedSubjects);
        }
        return appliedSubjects;
    }

    protected static boolean[][][] create3dArray(int countI, int countJ, int countK, boolean initialValue) {
        boolean[][][] result = new boolean[countI][countJ][countK];
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    result[i][j][k] = initialValue;
                }
            }
        }
        return result;
    }

    protected void processTable1_A_B(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "Table[0-9]+[.!][a-zA-Z]+:[a-zA-Z]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = MacroHelper.getExcelColumnNumber(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getExcelColumnNumber(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processTable1_A2_B3(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        int tmp;
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "Table[0-9]+[.!][a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = MacroHelper.getColumnIndex(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getColumnIndex(strLastColumnIndex);
            firstRowIndex = MacroHelper.getRowIndex(strFirstColumnIndex);
            lastRowIndex = MacroHelper.getRowIndex(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        if (lastRowIndex < firstRowIndex) {
            tmp = lastRowIndex;
            lastRowIndex = firstRowIndex;
            firstRowIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                if (firstRowIndex - 1 > j || j > lastRowIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processA2_B3(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        int tmp;
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "[a-zA-Z]+[0-9]+:[a-zA-Z]+[0-9]+")) {
            return;
        }
        int idx1 = -1;
        int idx2 = -1;
        int idx3 = -1;
        int idx4 = -1;
        idx1 = 0;
        idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        int firstRowIndex = -1;
        int lastRowIndex = -1;
        try {
            firstColumnIndex = MacroHelper.getColumnIndex(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getColumnIndex(strLastColumnIndex);
            firstRowIndex = MacroHelper.getRowIndex(strFirstColumnIndex);
            lastRowIndex = MacroHelper.getRowIndex(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        if (lastRowIndex < firstRowIndex) {
            tmp = lastRowIndex;
            lastRowIndex = firstRowIndex;
            firstRowIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                if (firstRowIndex - 1 > j || j > lastRowIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected void processTable1_1_2(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "Table[0-9]+[.!][0-9]+:[0-9]+")) {
            return;
        }
        int idx1 = "Table".length();
        int idx2 = appliesToElem.indexOf(".", idx1 + 1);
        int idx3 = appliesToElem.indexOf("!", idx1 + 1);
        int idx4 = -1;
        if (idx2 > -1) {
            idx4 = idx2;
        }
        if (idx3 > -1) {
            idx4 = idx3;
        }
        if (idx4 < 0) {
            return;
        }
        String strTableIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        if ((idx4 = appliesToElem.indexOf(":", idx1)) < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = Integer.parseInt(strTableIndex);
            firstColumnIndex = Integer.parseInt(strFirstColumnIndex);
            lastColumnIndex = Integer.parseInt(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (tableIndex > ruleSubjects.length) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            if (i != tableIndex - 1) continue;
            for (int j = 0; j < countJ; ++j) {
                if (firstColumnIndex - 1 > j || j > lastColumnIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
    }

    protected void processA_B(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "[a-zA-Z]+:[a-zA-Z]+")) {
            return;
        }
        int idx1 = 0;
        int idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = -1;
            firstColumnIndex = MacroHelper.getExcelColumnNumber(strFirstColumnIndex);
            lastColumnIndex = MacroHelper.getExcelColumnNumber(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                for (int k = 0; k < countK; ++k) {
                    if (firstColumnIndex - 1 > k || k > lastColumnIndex - 1) continue;
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected void process1_2(RuleSubject[][][] ruleSubjects, String appliesToElem, boolean[][][] appliedSubjects) {
        if (!Conditional2ColorScale.conformsToPattern(appliesToElem, "[0-9]+:[0-9]+")) {
            return;
        }
        int idx1 = 0;
        int idx4 = appliesToElem.indexOf(":", idx1);
        if (idx4 < 0) {
            return;
        }
        String strFirstColumnIndex = appliesToElem.substring(idx1, idx4);
        idx1 = idx4 + 1;
        idx4 = appliesToElem.length();
        if (idx4 <= idx1) {
            return;
        }
        String strLastColumnIndex = appliesToElem.substring(idx1, idx4);
        int tableIndex = -1;
        int firstColumnIndex = -1;
        int lastColumnIndex = -1;
        try {
            tableIndex = -1;
            firstColumnIndex = Integer.parseInt(strFirstColumnIndex);
            lastColumnIndex = Integer.parseInt(strLastColumnIndex);
        }
        catch (Exception e) {
            return;
        }
        if (lastColumnIndex < firstColumnIndex) {
            int tmp = lastColumnIndex;
            lastColumnIndex = firstColumnIndex;
            firstColumnIndex = tmp;
        }
        int countI = ruleSubjects.length;
        int countJ = ruleSubjects[0].length;
        int countK = ruleSubjects[0][0].length;
        for (int i = 0; i < countI; ++i) {
            for (int j = 0; j < countJ; ++j) {
                if (firstColumnIndex - 1 > j || j > lastColumnIndex - 1) continue;
                for (int k = 0; k < countK; ++k) {
                    appliedSubjects[i][j][k] = true;
                }
            }
        }
        long l = 10L;
    }

    protected static boolean conformsToPattern(String str, String pattern) {
        String s;
        Pattern p = Pattern.compile(pattern, 2);
        Matcher m = p.matcher(str);
        return m.find() && null != (s = m.group()) && 0 == s.compareToIgnoreCase(str);
    }

    protected void applyRuleForRuleSubject(RuleSubject ruleSubject, Double dRealMin, Double dRealMax) {
        if (null == ruleSubject) {
            return;
        }
        String value = null == ruleSubject.originalValue ? "" : ruleSubject.originalValue;
        Double dValue = null;
        if (Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
            dValue = Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol);
        }
        if (null == dValue) {
            return;
        }
        if (dValue <= dRealMin) {
            ruleSubject.backgroundColor = this.minimumValueColor;
        } else if (dValue >= dRealMax) {
            ruleSubject.backgroundColor = this.maximumValueColor;
        } else {
            String minimumValueColorInHex = CommonParamProcessingFunctions.convertAnyColorToHex(this.minimumValueColor);
            String maximumValueColorInHex = CommonParamProcessingFunctions.convertAnyColorToHex(this.maximumValueColor);
            if (null != minimumValueColorInHex && minimumValueColorInHex.length() > 0 && null != maximumValueColorInHex && maximumValueColorInHex.length() > 0) {
                Color minColor = Conditional2ColorScale.hex2Rgb(minimumValueColorInHex);
                Color maxColor = Conditional2ColorScale.hex2Rgb(maximumValueColorInHex);
                if (null != minColor && null != maxColor) {
                    String newColor;
                    double minRed = minColor.getRed();
                    double minGreen = minColor.getGreen();
                    double minBlue = minColor.getBlue();
                    double maxRed = maxColor.getRed();
                    double maxGreen = maxColor.getGreen();
                    double maxBlue = maxColor.getBlue();
                    double ratio = (dValue - dRealMin) / (dRealMax - dRealMin);
                    long lRed = Math.round(minRed + (maxRed - minRed) * ratio);
                    long lGreen = Math.round(minGreen + (maxGreen - minGreen) * ratio);
                    long lBlue = Math.round(minBlue + (maxBlue - minBlue) * ratio);
                    int iRed = (int)Math.max(0L, Math.min(lRed, 255L));
                    int iGreen = (int)Math.max(0L, Math.min(lGreen, 255L));
                    int iBlue = (int)Math.max(0L, Math.min(lBlue, 255L));
                    ruleSubject.backgroundColor = newColor = String.format("#%02x%02x%02x", iRed, iGreen, iBlue).toLowerCase();
                }
            }
        }
    }

    public static Color hex2Rgb(String colorStr) {
        return new Color(Integer.valueOf(colorStr.substring(1, 3), 16), Integer.valueOf(colorStr.substring(3, 5), 16), Integer.valueOf(colorStr.substring(5, 7), 16));
    }

    protected Double getDoubleValueFromRuleSubject(RuleSubject ruleSubject) {
        Double dValue;
        String value;
        if (null == ruleSubject) {
            return null;
        }
        if (!ruleSubject.shouldContinueRuleProcessing) {
            return null;
        }
        Double result = null;
        String string = value = null == ruleSubject.originalValue ? "" : ruleSubject.originalValue;
        if (Conversion.isLong(value, this.decimalSymbol, this.digitGroupingSymbol)) {
            Long lValue = Conversion.objectToLong(value, this.decimalSymbol, this.digitGroupingSymbol);
            if (null != lValue) {
                result = new Double(lValue.doubleValue());
            }
        } else if (Conversion.isDoubleOrLong(value, this.decimalSymbol, this.digitGroupingSymbol) && null != (dValue = Double.valueOf(Conversion.objectToDouble(value, this.decimalSymbol, this.digitGroupingSymbol)))) {
            result = new Double(dValue);
        }
        return result;
    }

    public static class MinMaxHolder {
        public int min = -1;
        public int max = -1;

        public MinMaxHolder(int min, int max) {
            this.min = min;
            this.max = max;
        }
    }
}

