/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.expressions;

import com.celestecs.expression.expressions.PreparedExpressionItem;
import java.util.ArrayList;

public final class PreparedExpression {
    public ArrayList<PreparedExpressionItem> preparedExpressionItems;

    public ArrayList<PreparedExpressionItem> getPreparedExpressionItems() {
        return this.preparedExpressionItems;
    }

    public PreparedExpression(ArrayList<PreparedExpressionItem> preparedExpressionItems) {
        this.preparedExpressionItems = preparedExpressionItems;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (PreparedExpressionItem item : this.preparedExpressionItems) {
            block0 : switch (item.getKind()) {
                case Constant: {
                    Object constantItem = item.getConstant();
                    if (constantItem instanceof Double) {
                        stringBuilder.append((Double)constantItem);
                        break;
                    }
                    stringBuilder.append(constantItem.toString());
                    break;
                }
                case Delimiter: {
                    switch (item.getDelimiterKind()) {
                        case OpeningBrace: {
                            stringBuilder.append("(");
                            break block0;
                        }
                        case ClosingBrace: {
                            stringBuilder.append(")");
                            break block0;
                        }
                        case Comma: {
                            stringBuilder.append(",");
                            break block0;
                        }
                    }
                    throw new UnsupportedOperationException("Unknown delimiter kind.");
                }
                case Variable: {
                    stringBuilder.append(item.getVariableName());
                    break;
                }
                case Signature: {
                    stringBuilder.append(item.getSignature());
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown item kind.");
                }
            }
            stringBuilder.append(" ");
        }
        return stringBuilder.toString();
    }
}

