/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.expressions;

import com.celestecs.expression.expressions.CompiledExpressionItemKind;

public final class CompiledExpressionItem {
    private CompiledExpressionItemKind kind = CompiledExpressionItemKind.CONSTANT;
    private Object constantValue;
    private String variableName;
    private String operationName;
    private int operationParamCount = -1;

    public CompiledExpressionItemKind getKind() {
        return this.kind;
    }

    public Object getConstant() {
        if (this.kind != CompiledExpressionItemKind.CONSTANT) {
            throw new UnsupportedOperationException("Type mismatch.");
        }
        return this.constantValue;
    }

    public String getVariableName() {
        if (this.kind != CompiledExpressionItemKind.VARIABLE) {
            throw new UnsupportedOperationException("Type mismatch.");
        }
        return this.variableName;
    }

    public String getOperationName() {
        if (this.kind != CompiledExpressionItemKind.OPERATION) {
            throw new UnsupportedOperationException("Type mismatch.");
        }
        return this.operationName;
    }

    public void setOperationParamCount(int operationParamCount) {
        if (this.kind != CompiledExpressionItemKind.OPERATION) {
            throw new UnsupportedOperationException("Type mismatch.");
        }
        this.operationParamCount = operationParamCount;
    }

    public int getOperationParamCount() {
        if (this.kind != CompiledExpressionItemKind.OPERATION) {
            throw new UnsupportedOperationException("Type mismatch.");
        }
        return this.operationParamCount;
    }

    public CompiledExpressionItem(CompiledExpressionItemKind kind, Object value, int operationParamCount) {
        if (value == null) {
            throw new IllegalArgumentException("value");
        }
        this.kind = kind;
        switch (kind) {
            case CONSTANT: {
                this.constantValue = value;
                break;
            }
            case VARIABLE: {
                this.variableName = (String)value;
                break;
            }
            case OPERATION: {
                this.operationName = (String)value;
                this.operationParamCount = operationParamCount;
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unexpected kind.");
            }
        }
    }

    public String toString() {
        return String.format("%1$s %2$s", new Object[]{this.kind, this.kind == CompiledExpressionItemKind.CONSTANT ? this.constantValue.toString() : (this.kind == CompiledExpressionItemKind.OPERATION ? this.operationName : this.variableName)});
    }
}

