/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.text;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import org.apache.poi.ss.usermodel.DataFormatter;

public final class CalculatorText
extends CalculatorBase {
    protected static final DataFormatter formatter = new DataFormatter();

    public CalculatorText(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 2);
        super.CheckForNotHavingRanges(objParams);
        if (!Conversion.isNumeric(objParams[0], this.decimalSymbol, this.digitGroupingSymbol)) {
            return new String("");
        }
        double s0 = Conversion.objectToDouble(objParams[0], this.decimalSymbol, this.digitGroupingSymbol);
        String s1 = objParams[1].toString();
        try {
            String formattedStr = formatter.formatRawCellContents(s0, -1, s1);
            return new String(formattedStr);
        }
        catch (Exception e) {
            return "";
        }
    }
}

