/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.text;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorMid
extends CalculatorBase {
    public CalculatorMid(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        super.CheckParams(objParams, 3);
        if (!Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol) || !Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)) {
            return "NaN";
        }
        int startNum = (int)Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        int numChars = (int)Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol);
        String srcText = objParams[0].toString();
        if (startNum < 1 || numChars < 0) {
            return "NaN";
        }
        if (0 == numChars || null == srcText || 0 == srcText.length()) {
            return "";
        }
        if (startNum > srcText.length()) {
            return "";
        }
        String result = srcText.substring(startNum - 1, Math.min(srcText.length(), startNum - 1 + numChars));
        return result;
    }
}

