/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.operators;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorEqual
extends CalculatorBase {
    public CalculatorEqual(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        String str2;
        super.CheckForNotHavingRanges(objParams);
        Object[] parameters = Conversion.objectArrayToSpecificTypeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        super.CheckParams(parameters, 2);
        Object param1 = parameters[0];
        Object param2 = parameters[1];
        if (!(null != param1 && param1.toString().length() >= 1 || null != param2 && param2.toString().length() >= 1)) {
            return new Boolean(true);
        }
        if (Conversion.isBoolean(param1) && Conversion.isBoolean(param2)) {
            boolean val2;
            boolean val1 = Conversion.objectToBoolean(param1, this.decimalSymbol, this.digitGroupingSymbol);
            return new Boolean(val1 == (val2 = Conversion.objectToBoolean(param2, this.decimalSymbol, this.digitGroupingSymbol)));
        }
        if (Conversion.isLong(param1, this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isLong(param2, this.decimalSymbol, this.digitGroupingSymbol)) {
            long val2;
            long val1 = Conversion.objectToLong(param1, this.decimalSymbol, this.digitGroupingSymbol);
            return new Boolean(val1 == (val2 = Conversion.objectToLong(param2, this.decimalSymbol, this.digitGroupingSymbol)));
        }
        if (Conversion.isDateTime(param1) && Conversion.isDateTime(param2)) {
            double val2;
            double val1 = Conversion.objectToDateTime(param1).getValue();
            return new Boolean(val1 == (val2 = Conversion.objectToDateTime(param2).getValue()));
        }
        if (Conversion.isDoubleOrLong(param1, this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isDoubleOrLong(param2, this.decimalSymbol, this.digitGroupingSymbol)) {
            double val2;
            double val1 = Conversion.objectToDouble(param1, this.decimalSymbol, this.digitGroupingSymbol);
            return new Boolean(Math.abs(val1 - (val2 = Conversion.objectToDouble(param2, this.decimalSymbol, this.digitGroupingSymbol))) < 1.0E-13);
        }
        String str1 = param1.toString();
        return new Boolean(str1.compareTo(str2 = param2.toString()) == 0);
    }
}

