/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.operators;

import com.celestecs.expression.Calculator;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.exceptions.DivisionByZeroException;

public final class CalculatorDivision
extends CalculatorBase {
    public CalculatorDivision(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckForNotHavingRanges(objParams);
        Object[] parameters = Conversion.objectArrayToSpecificTypeArray(objParams, this.decimalSymbol, this.digitGroupingSymbol);
        super.CheckParams(parameters, 2);
        Object param1 = parameters[0];
        Object param2 = parameters[1];
        if (Conversion.isDoubleOrLong(param1, this.decimalSymbol, this.digitGroupingSymbol) && Conversion.isDoubleOrLong(param2, this.decimalSymbol, this.digitGroupingSymbol)) {
            if (Math.abs(Conversion.objectToDouble(param2, this.decimalSymbol, this.digitGroupingSymbol)) < Calculator.eps) {
                throw new DivisionByZeroException();
            }
            return new Double(Conversion.objectToDouble(param1, this.decimalSymbol, this.digitGroupingSymbol) / Conversion.objectToDouble(param2, this.decimalSymbol, this.digitGroupingSymbol));
        }
        return "NaN";
    }
}

