/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.mathandtrigonometry;

import com.celestecs.expression.VariableRange;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.celestecs.expression.calculators.operators.CalculatorAddition;
import com.celestecs.expression.calculators.operators.CalculatorEqual;
import com.celestecs.expression.calculators.operators.CalculatorGreater;
import com.celestecs.expression.calculators.operators.CalculatorGreaterOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorLess;
import com.celestecs.expression.calculators.operators.CalculatorLessOrEqual;
import com.celestecs.expression.calculators.operators.CalculatorNotEqual;

public final class CalculatorSumIf
extends CalculatorBase {
    public static final int NONE = 0;
    public static final int EQ = 1;
    public static final int NE = 2;
    public static final int LE = 3;
    public static final int LT = 4;
    public static final int GT = 5;
    public static final int GE = 6;

    public CalculatorSumIf(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        if (null == objParams || objParams.length < 2 || objParams.length > 3) {
            return new Long(0L);
        }
        Object objRange = null;
        Object objCriteria = null;
        Object objSumRange = null;
        if (2 == objParams.length) {
            objRange = objParams[0];
            objCriteria = objParams[1];
            objSumRange = objParams[0];
        } else {
            objRange = objParams[0];
            objCriteria = objParams[1];
            objSumRange = objParams[2];
        }
        if (!(objRange instanceof VariableRange) || objCriteria instanceof VariableRange || !(objSumRange instanceof VariableRange)) {
            return new Long(0L);
        }
        Object[] arrRange = Conversion.objectArrayWithRangesToFlatObjectArray(new Object[]{objRange});
        Object[] arrSumRange = Conversion.objectArrayWithRangesToFlatObjectArray(new Object[]{objSumRange});
        if (null == arrRange || null == arrSumRange || arrSumRange.length < arrRange.length) {
            return new Long(0L);
        }
        Object objValue = objCriteria;
        String strValue = null == objValue ? "" : CalculatorSumIf.getValue(objValue.toString());
        CalculatorAddition calcSummarizer = new CalculatorAddition(this.decimalSymbol, this.digitGroupingSymbol);
        CalculatorBase calcComparer = null;
        if (null == objValue || strValue.length() == objValue.toString().length()) {
            calcComparer = this.getCalculator(1);
        } else {
            int operation = CalculatorSumIf.getOperation(objValue.toString());
            calcComparer = this.getCalculator(operation);
            objValue = strValue;
        }
        Object[] calcSummarizerParams = new Object[2];
        Object[] calcComparerParams = new Object[2];
        calcComparerParams[1] = objValue;
        boolean bFirstTime = true;
        Object objSumResult = null;
        for (int i = 0; i < arrRange.length; ++i) {
            Object objParam;
            calcComparerParams[0] = objParam = arrRange[i];
            Object objComparerResult = calcComparer.Calculate(calcComparerParams);
            if (null == objComparerResult || !(objComparerResult instanceof Boolean) || !((Boolean)objComparerResult).booleanValue() || !Conversion.isDoubleOrLong(arrSumRange[i], this.decimalSymbol, this.digitGroupingSymbol) && !Conversion.isDateTime(arrSumRange[i])) continue;
            if (bFirstTime) {
                objSumResult = arrSumRange[i];
                bFirstTime = false;
                continue;
            }
            calcSummarizerParams[0] = objSumResult;
            calcSummarizerParams[1] = arrSumRange[i];
            objSumResult = calcSummarizer.Calculate(calcSummarizerParams);
        }
        if (null == objSumResult) {
            objSumResult = new Long(0L);
        }
        return objSumResult;
    }

    public CalculatorBase getCalculator(int operation) {
        CalculatorBase calc = null;
        switch (operation) {
            case 0: 
            case 1: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 2: {
                calc = new CalculatorNotEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 3: {
                calc = new CalculatorLessOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 4: {
                calc = new CalculatorLess(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 5: {
                calc = new CalculatorGreater(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            case 6: {
                calc = new CalculatorGreaterOrEqual(this.decimalSymbol, this.digitGroupingSymbol);
                break;
            }
            default: {
                calc = new CalculatorEqual(this.decimalSymbol, this.digitGroupingSymbol);
            }
        }
        return calc;
    }

    public static int getOperation(String param) {
        int len = param.length();
        if (len < 1) {
            return 0;
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return 1;
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 6;
                        }
                    }
                }
                return 5;
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return 3;
                        }
                        case '>': {
                            return 2;
                        }
                    }
                }
                return 4;
            }
        }
        return 1;
    }

    public static String getValue(String param) {
        if (null == param) {
            return "";
        }
        int len = param.length();
        if (len < 1) {
            return "";
        }
        char firstChar = param.charAt(0);
        switch (firstChar) {
            case '=': {
                return param.substring(1);
            }
            case '>': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
            case '<': {
                if (len > 1) {
                    switch (param.charAt(1)) {
                        case '=': {
                            return param.substring(2);
                        }
                        case '>': {
                            return param.substring(2);
                        }
                    }
                }
                return param.substring(1);
            }
        }
        return param;
    }
}

