/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.lookupandreference;

import com.celestecs.expression.Variable;
import com.celestecs.expression.VariableRange;
import com.celestecs.expression.VariableValue;
import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.Conversion;

public final class CalculatorVlookup
extends CalculatorBase {
    public CalculatorVlookup(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) {
        super.CheckParams(objParams, 3);
        if (Conversion.isRange(objParams[0]) || !Conversion.isRange(objParams[1]) || !Conversion.isLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol)) {
            return new String("");
        }
        Object lookupValue = objParams[0] instanceof VariableValue ? ((VariableValue)objParams[0]).getValue() : objParams[0];
        VariableRange range = (VariableRange)objParams[1];
        Long column = Conversion.objectToLong(objParams[2], this.decimalSymbol, this.digitGroupingSymbol) - 1L;
        Object[][] variables = range.getVariables();
        if (null == variables || null == variables[0] || variables[0].length < 1) {
            throw new IllegalArgumentException("Wrong lookup source range parameter.");
        }
        int rows = variables.length;
        int columns = variables[0].length;
        if (column >= (long)columns) {
            throw new IllegalArgumentException("Wrong column parameter: '" + column + "'.");
        }
        for (int i = 0; i < rows; ++i) {
            Object var = variables[i][0];
            if (var instanceof VariableValue && ((VariableValue)var).getVariableName().equals(Variable.EMPTY_VAR_NAME)) continue;
            Object object = var = var instanceof VariableValue ? ((VariableValue)var).getValue() : var;
            if (!Conversion.objectsAreEqual(lookupValue, var, this.decimalSymbol, this.digitGroupingSymbol)) continue;
            Object result = variables[i][column.intValue()];
            return result instanceof VariableValue ? ((VariableValue)result).getValue() : result;
        }
        return new String("");
    }
}

