/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;

public final class CalculatorJsonExtractPath
extends CalculatorBase {
    public CalculatorJsonExtractPath(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 2 || objParams.length > 3) {
            throw new IllegalArgumentException("Wrong parameter count, which should be 2 or 3.");
        }
        String resultIfNan = "NaN";
        if (objParams.length > 2 && null != objParams[2]) {
            resultIfNan = objParams[2].toString();
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return resultIfNan;
        }
        Object objJson = objParams[0];
        if (null == objParams[1] || objParams[1].toString().isEmpty()) {
            return resultIfNan;
        }
        String path = objParams[1].toString();
        try {
            JsonParser jsonParser = new JsonParser();
            JsonElement jsonParsed = jsonParser.parse(objJson.toString());
            if (null == jsonParsed) {
                return resultIfNan;
            }
            JsonElement jsonElement = this.getJsonElement(jsonParsed, path);
            if (null == jsonElement) {
                return resultIfNan;
            }
            String strResult = jsonElement.getAsString();
            return strResult;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }

    public JsonElement getJsonElement(JsonElement json, String path) throws Exception {
        String[] parts = path.split("\\.|\\[|\\]");
        JsonElement result = json;
        for (String key : parts) {
            if ((key = key.trim()).isEmpty()) continue;
            if (result == null) {
                result = null;
                break;
            }
            if (result.isJsonObject()) {
                result = ((JsonObject)result).get(key);
                continue;
            }
            if (!result.isJsonArray()) break;
            if (!Conversion.isLong(key, this.decimalSymbol, this.digitGroupingSymbol)) {
                throw new Exception("Json array index is supposed to be specified, but '" + key + "' value is specified instead.");
            }
            int ix = new Long(Conversion.objectToLong(key, this.decimalSymbol, this.digitGroupingSymbol)).intValue();
            if (ix < 0 || ix >= ((JsonArray)result).size()) {
                return null;
            }
            result = ((JsonArray)result).get(ix);
        }
        return result;
    }
}

