/*
 * Decompiled with CFR 0.152.
 */
package com.celestecs.expression.calculators.json;

import com.celestecs.expression.calculators.CalculatorBase;
import com.celestecs.expression.calculators.CalculatorException;
import com.celestecs.expression.calculators.Conversion;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;

public final class CalculatorJsonArrayGet
extends CalculatorBase {
    public CalculatorJsonArrayGet(char decimalSymbol, String digitGroupingSymbol) {
        super(decimalSymbol, digitGroupingSymbol);
    }

    @Override
    public Object Calculate(Object[] objParams) throws CalculatorException {
        super.CheckForNotHavingRanges(objParams);
        if (objParams.length < 2 || objParams.length > 3) {
            throw new IllegalArgumentException("Wrong parameter count, which should be 2 or 3.");
        }
        String resultIfNan = "NaN";
        if (objParams.length > 2 && null != objParams[2]) {
            resultIfNan = objParams[2].toString();
        }
        if (null == objParams[0] || objParams[0].toString().isEmpty()) {
            return resultIfNan;
        }
        Object objJson = objParams[0];
        if (null == objParams[1] || !Conversion.isLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol)) {
            return resultIfNan;
        }
        Long index = Conversion.objectToLong(objParams[1], this.decimalSymbol, this.digitGroupingSymbol);
        try {
            JsonArray jsonArray = null;
            if (!(objJson instanceof JsonArray)) {
                JsonParser jsonParser = new JsonParser();
                JsonElement jsonParsed = jsonParser.parse(objJson.toString());
                if (null != jsonParsed && jsonParsed instanceof JsonArray) {
                    jsonArray = (JsonArray)jsonParsed;
                }
            } else {
                jsonArray = (JsonArray)objJson;
            }
            if (null == jsonArray) {
                return resultIfNan;
            }
            if (0L > index || (long)jsonArray.size() <= index) {
                return resultIfNan;
            }
            JsonElement jsonElement = jsonArray.get(new Long(index).intValue());
            if (null == jsonElement) {
                return resultIfNan;
            }
            String strResult = jsonElement.getAsString();
            return strResult;
        }
        catch (Exception e) {
            throw new CalculatorException(e.getMessage(), this, objParams);
        }
    }
}

